/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.tools.audio;

import edu.cmu.sphinx.tools.audio.AudioData;
import edu.cmu.sphinx.tools.audio.Utils;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.SourceDataLine;

public class AudioPlayer
extends Thread {
    private final AudioData audio;
    private SourceDataLine line;
    private int selectionStart;
    private int selectionEnd;

    public AudioPlayer(AudioData audio) {
        this.audio = audio;
        this.selectionStart = 0;
        this.selectionEnd = audio.getAudioData().length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void play(int selectionStart, int selectionEnd) {
        AudioData audioData = this.audio;
        synchronized (audioData) {
            this.selectionStart = selectionStart;
            this.selectionEnd = selectionEnd;
            this.audio.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        try {
            block5: while (true) {
                AudioData audioData = this.audio;
                // MONITORENTER : audioData
                this.audio.wait();
                AudioFormat format = this.audio.getAudioFormat();
                short[] data = this.audio.getAudioData();
                int start = Math.max(0, this.selectionStart);
                int end = this.selectionEnd;
                if (end == -1) {
                    end = data.length;
                }
                DataLine.Info info = new DataLine.Info(SourceDataLine.class, format);
                this.line = (SourceDataLine)AudioSystem.getLine(info);
                this.line.open(format);
                this.line.start();
                byte[] frame = new byte[2];
                int i = start;
                while (true) {
                    if (i >= end || i >= data.length) {
                        this.line.drain();
                        this.line.close();
                        this.line = null;
                        // MONITOREXIT : audioData
                        continue block5;
                    }
                    Utils.toBytes(data[i], frame, false);
                    this.line.write(frame, 0, frame.length);
                    ++i;
                }
                break;
            }
            catch (Throwable throwable) {
                // MONITOREXIT : audioData
                throw throwable;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }
}

