/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.tools.audio;

import edu.cmu.sphinx.tools.audio.AudioData;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Arrays;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class AudioPanel
extends JPanel
implements MouseMotionListener,
MouseListener {
    private final AudioData audio;
    private float[] labelTimes;
    private String[] labels;
    private float xScale;
    private final float yScale;
    private final float originalXScale;
    private int xDragStart;
    private int xDragEnd;
    protected int selectionStart = -1;
    protected int selectionEnd = -1;

    public AudioPanel(AudioData audioData, float scaleX, float scaleY) {
        this.audio = audioData;
        this.labelTimes = new float[0];
        this.labels = new String[0];
        this.xScale = scaleX;
        this.yScale = scaleY;
        this.originalXScale = this.xScale;
        int width = (int)((float)this.audio.getAudioData().length * this.xScale);
        int height = (int)(65536.0f * this.yScale);
        this.setPreferredSize(new Dimension(width, height));
        this.setBackground(Color.white);
        this.audio.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent event) {
                int width = (int)((float)AudioPanel.this.audio.getAudioData().length * AudioPanel.this.xScale);
                int height = (int)(65536.0f * AudioPanel.this.yScale);
                AudioPanel.this.labelTimes = new float[0];
                AudioPanel.this.labels = new String[0];
                AudioPanel.this.setSelectionStart(-1);
                AudioPanel.this.setSelectionEnd(-1);
                AudioPanel.this.setPreferredSize(new Dimension(width, height));
                Dimension sz = AudioPanel.this.getSize();
                AudioPanel.this.revalidate();
                AudioPanel.this.repaint(0L, 0, 0, sz.width, sz.height);
            }
        });
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
        this.setFocusable(true);
        this.requestFocus();
    }

    public void setLabels(float[] labelTimes, String[] labels) {
        this.labelTimes = labelTimes;
        this.labels = labels;
        this.repaint();
    }

    protected void zoomSet(float zoom) {
        this.xScale = this.originalXScale * zoom;
        int width = (int)((float)this.audio.getAudioData().length * this.xScale);
        int height = (int)(65536.0f * this.yScale);
        this.setPreferredSize(new Dimension(width, height));
        this.revalidate();
        this.repaint();
    }

    @Override
    public void paintComponent(Graphics g) {
        int length;
        int pos;
        super.paintComponent(g);
        Dimension sz = this.getSize();
        int gZero = sz.height / 2;
        short[] audioData = this.audio.getAudioData();
        JViewport viewport = this.getViewport();
        if (viewport != null) {
            Rectangle r = viewport.getViewRect();
            pos = (int)r.getX();
            length = (int)r.getWidth();
        } else {
            pos = 0;
            length = (int)((float)audioData.length * this.xScale);
        }
        g.setColor(Color.WHITE);
        g.fillRect(pos, 0, length, sz.height - 1);
        int index = Math.max(0, this.getSelectionStart());
        int start = (int)((float)index * this.xScale);
        index = this.getSelectionEnd();
        if (index == -1) {
            index = audioData.length - 1;
        }
        int end = (int)((float)index * this.xScale);
        g.setColor(Color.LIGHT_GRAY);
        g.fillRect(start, 0, end - start, sz.height - 1);
        int[] x = new int[length];
        int[] y = new int[length];
        int i = 0;
        while (i < length) {
            x[i] = pos;
            index = (int)((float)pos / this.xScale);
            if (index >= audioData.length) break;
            y[i] = gZero - (int)((float)audioData[index] * this.yScale);
            ++pos;
            ++i;
        }
        g.setColor(Color.RED);
        g.drawPolyline(x, y, length);
        i = 0;
        while (i < this.labelTimes.length) {
            pos = (int)(this.xScale * this.labelTimes[i] * this.audio.getAudioFormat().getSampleRate());
            g.drawLine(pos, 0, pos, sz.height - 1);
            g.drawString(this.labels[i], pos + 5, sz.height - 5);
            ++i;
        }
    }

    private JViewport getViewport() {
        Container gp;
        Container p = this.getParent();
        if (p instanceof JViewport && (gp = p.getParent()) instanceof JScrollPane) {
            JScrollPane scroller = (JScrollPane)gp;
            JViewport viewport = scroller.getViewport();
            if (viewport == null || viewport.getView() != this) {
                return null;
            }
            return viewport;
        }
        return null;
    }

    public int getSelectionStart() {
        return this.selectionStart;
    }

    public void setSelectionStart(int newStart) {
        this.selectionStart = newStart;
        if (this.selectionEnd != -1 && this.selectionEnd < this.selectionStart) {
            this.selectionEnd = this.selectionStart;
        }
    }

    public int getSelectionEnd() {
        return this.selectionEnd;
    }

    public void setSelectionEnd(int newEnd) {
        this.selectionEnd = newEnd;
        if (this.selectionEnd != -1 && this.selectionStart > this.selectionEnd) {
            this.selectionStart = this.selectionEnd;
        }
    }

    public void crop() {
        short[] shorts = this.audio.getAudioData();
        int start = Math.max(0, this.getSelectionStart());
        int end = this.getSelectionEnd();
        if (end == -1) {
            end = shorts.length;
        }
        this.audio.setAudioData(Arrays.copyOfRange(shorts, start, end));
        this.setSelectionStart(-1);
        this.setSelectionEnd(-1);
    }

    public void selectAll() {
        this.setSelectionStart(-1);
        this.setSelectionEnd(-1);
        this.repaint();
    }

    @Override
    public void mousePressed(MouseEvent evt) {
        this.xDragStart = Math.max(0, evt.getX());
        this.setSelectionStart((int)((float)this.xDragStart / this.xScale));
        this.setSelectionEnd((int)((float)this.xDragStart / this.xScale));
        this.repaint();
    }

    @Override
    public void mouseDragged(MouseEvent evt) {
        this.xDragEnd = evt.getX();
        if (this.xDragEnd < (int)((float)this.getSelectionStart() * this.xScale)) {
            this.setSelectionStart((int)((float)this.xDragEnd / this.xScale));
        } else {
            this.setSelectionEnd((int)((float)this.xDragEnd / this.xScale));
        }
        this.repaint();
    }

    @Override
    public void mouseReleased(MouseEvent evt) {
    }

    @Override
    public void mouseMoved(MouseEvent evt) {
    }

    @Override
    public void mouseEntered(MouseEvent evt) {
    }

    @Override
    public void mouseExited(MouseEvent evt) {
    }

    @Override
    public void mouseClicked(MouseEvent evt) {
    }
}

