/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.speakerid;

import edu.cmu.sphinx.speakerid.Segment;
import edu.cmu.sphinx.speakerid.SpeakerCluster;
import edu.cmu.sphinx.speakerid.SpeakerIdentification;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Random;

public class Tester {
    public static ArrayList<float[]> generateDistinctSpeakers(int vectorSize, int vectorsCount, int speakersCount) {
        Random rd = new Random();
        ArrayList<float[]> ret = new ArrayList<float[]>();
        float[] dummy = new float[vectorSize];
        int i = 0;
        while (i < speakersCount) {
            int j = 0;
            while (j < vectorSize) {
                dummy[j] = (float)(i + 1) / 10.0f + (float)rd.nextInt(5000) / 50000.0f;
                ++j;
            }
            dummy[0] = 3.0f + (float)(i + 1) / 10.0f;
            j = 0;
            while (j < vectorsCount) {
                float[] copy = new float[vectorSize];
                int k = 0;
                while (k < vectorSize) {
                    copy[k] = dummy[k] + (float)rd.nextInt(5000) / 50000.0f;
                    ++k;
                }
                ret.add(copy);
                ++j;
            }
            ++i;
        }
        return ret;
    }

    public static String time(int seconds) {
        return String.valueOf(seconds / 60000) + ":" + Math.round((double)(seconds % 60000) / 1000.0);
    }

    public static void printIntervals(ArrayList<SpeakerCluster> speakers) {
        System.out.println("Detected " + speakers.size() + " Speakers :");
        int idx = 0;
        for (SpeakerCluster spk : speakers) {
            System.out.print("Speaker " + ++idx + ": ");
            ArrayList<Segment> segments = spk.getSpeakerIntervals();
            for (Segment seg : segments) {
                System.out.print("[" + Tester.time(seg.getStartTime()) + " " + Tester.time(seg.getLength()) + "]");
            }
            System.out.println();
        }
    }

    public static void printSpeakerIntervals(ArrayList<SpeakerCluster> speakers, String fileName) throws IOException {
        String ofName = String.valueOf(fileName.substring(0, fileName.indexOf(46))) + ".seg";
        FileWriter fr = new FileWriter(ofName);
        int idx = 0;
        for (SpeakerCluster spk : speakers) {
            ++idx;
            ArrayList<Segment> segments = spk.getSpeakerIntervals();
            for (Segment seg : segments) {
                fr.write(String.valueOf(fileName) + " " + 1 + " " + seg.getStartTime() / 10 + " " + seg.getLength() / 10 + "U U U Speaker" + idx + "\n");
            }
        }
        fr.close();
    }

    public static void testDistinctSpeakerIdentification(int vectorSize, int vectorsCount, int speakersCount) {
        ArrayList<float[]> ret = Tester.generateDistinctSpeakers(vectorSize, vectorsCount, speakersCount);
        Tester.printIntervals(new SpeakerIdentification().cluster(ret));
    }

    public static void testRepeatedSpeakerIdentification(int vectorSize, int vectorsCount, int speakersCount, int repeatFactor) {
        ArrayList<float[]> lst = new ArrayList<float[]>();
        ArrayList<float[]> aux = Tester.generateDistinctSpeakers(vectorSize, vectorsCount, speakersCount);
        int i = 0;
        while (i < repeatFactor) {
            lst.addAll(aux);
            ++i;
        }
        Tester.printIntervals(new SpeakerIdentification().cluster(lst));
    }

    public static void testSpeakerIdentification(String inputFile) throws IOException {
        FileInputStream stream = new FileInputStream(inputFile);
        ArrayList<SpeakerCluster> speakers = new SpeakerIdentification().cluster(stream);
        Tester.printIntervals(speakers);
        Tester.printSpeakerIntervals(speakers, inputFile);
    }

    public static void main(String[] args) throws IOException {
        String inputFile = null;
        int i = 0;
        while (i < args.length) {
            if (args[i].equals("-i")) {
                inputFile = args[++i];
            }
            ++i;
        }
        Tester.testSpeakerIdentification(inputFile);
    }
}

