/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.result;

import edu.cmu.sphinx.decoder.search.AlternateHypothesisManager;
import edu.cmu.sphinx.decoder.search.Token;
import edu.cmu.sphinx.linguist.HMMSearchState;
import edu.cmu.sphinx.linguist.SearchState;
import edu.cmu.sphinx.linguist.UnitSearchState;
import edu.cmu.sphinx.linguist.WordSearchState;
import edu.cmu.sphinx.result.Result;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TokenGraphDumper {
    private final AlternateHypothesisManager loserManager;
    private final Result result;
    private final Map<Token, Integer> tokenIDMap;
    private final Set<Token> dumpedTokens;
    private int ID;

    public TokenGraphDumper(Result result) {
        this.result = result;
        this.loserManager = result.getAlternateHypothesisManager();
        this.tokenIDMap = new HashMap<Token, Integer>();
        this.dumpedTokens = new HashSet<Token>();
    }

    public void dumpGDL(String title, String fileName) {
        try {
            System.err.println("Dumping " + title + " to " + fileName);
            FileWriter f = new FileWriter(fileName);
            f.write(this.dumpGDL(title));
            f.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public String dumpGDL(String title) {
        StringBuilder gdl = new StringBuilder("graph: {\n");
        gdl.append("title: \"").append(title).append("\"\n");
        gdl.append("display_edge_labels: yes\n");
        for (Token token : this.result.getResultTokens()) {
            gdl.append(this.dumpTokenGDL(token));
        }
        gdl.append("}\n");
        return gdl.toString();
    }

    private String dumpTokenGDL(Token token) {
        List<Token> list;
        if (this.dumpedTokens.contains(token)) {
            return "";
        }
        String label = "[" + token.getAcousticScore() + token.getInsertionScore() + ',' + token.getLanguageScore() + ']';
        if (token.isWord()) {
            label = String.valueOf(token.getWord().getSpelling()) + label;
        }
        String color = null;
        if (token.getSearchState() != null) {
            color = this.getColor(token.getSearchState());
        }
        StringBuilder gdl = new StringBuilder().append("node: { title: \"").append(this.getTokenID(token)).append("\" label: \"").append(label).append("\" color: ");
        if (color != null) {
            gdl.append(color).append(" }");
        } else {
            gdl.append(" }");
        }
        gdl.append('\n');
        this.dumpedTokens.add(token);
        if (token.getPredecessor() != null) {
            gdl.append("edge: { sourcename: \"").append(this.getTokenID(token)).append("\" targetname: \"").append(this.getTokenID(token.getPredecessor())).append("\" }").append('\n').append(this.dumpTokenGDL(token.getPredecessor()));
        }
        if (this.loserManager != null && (list = this.loserManager.getAlternatePredecessors(token)) != null) {
            for (Token loser : list) {
                gdl.append("edge: { sourcename: \"").append(this.getTokenID(token)).append("\" targetname: \"").append(this.getTokenID(loser)).append("\" }").append('\n').append(this.dumpTokenGDL(loser));
            }
        }
        return gdl.toString();
    }

    private String getColor(SearchState state) {
        String color = "lightred";
        if (state.isFinal()) {
            color = "magenta";
        } else if (state instanceof UnitSearchState) {
            color = "green";
        } else if (state instanceof WordSearchState) {
            color = "lightblue";
        } else if (state instanceof HMMSearchState) {
            color = "orange";
        }
        return color;
    }

    private Integer getTokenID(Token token) {
        Integer id = this.tokenIDMap.get(token);
        if (id == null) {
            id = this.ID++;
            this.tokenIDMap.put(token, id);
        }
        return id;
    }
}

