/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.result;

import edu.cmu.sphinx.result.BoundedPriorityQueue;
import edu.cmu.sphinx.result.Edge;
import edu.cmu.sphinx.result.Lattice;
import edu.cmu.sphinx.result.Node;
import java.util.Collection;
import java.util.HashSet;

public class Nbest {
    protected Lattice lattice;

    public Nbest(Lattice lattice) {
        this.lattice = lattice;
    }

    public Collection<String> getNbest(int n) {
        HashSet<String> result = new HashSet<String>();
        BoundedPriorityQueue<NBestPath> queue = new BoundedPriorityQueue<NBestPath>(n);
        queue.add(new NBestPath("<s>", this.lattice.getInitialNode(), 0.0, 0.0));
        while (result.size() < n && queue.size() > 0) {
            NBestPath path = (NBestPath)queue.poll();
            if (path.node.equals(this.lattice.terminalNode)) {
                result.add(path.path);
                continue;
            }
            for (Edge e : path.node.getLeavingEdges()) {
                Node newNode = e.getToNode();
                double newForwardScore = path.forwardScore + e.getAcousticScore() + e.getLMScore();
                double newScore = newForwardScore + newNode.getBackwardScore();
                String newPathString = this.getNewPathString(path, newNode);
                NBestPath newPath = new NBestPath(newPathString, newNode, newScore, newForwardScore);
                queue.add(newPath);
            }
        }
        return result;
    }

    private String getNewPathString(NBestPath path, Node newNode) {
        String newPathString = newNode.getWord().isSentenceEndWord() ? String.valueOf(path.path) + " </s>" : (newNode.getWord().isFiller() ? path.path : String.valueOf(path.path) + " " + newNode.getWord());
        return newPathString;
    }

    private void printQueue(BoundedPriorityQueue<NBestPath> queue) {
        System.out.println();
        for (NBestPath p : queue) {
            System.out.println(p);
        }
    }

    class NBestPath
    implements Comparable<NBestPath> {
        String path;
        Node node;
        double score;
        double forwardScore;

        public NBestPath(String path, Node node, double score, double forwardScore) {
            this.path = path;
            this.node = node;
            this.score = score;
            this.forwardScore = forwardScore;
        }

        @Override
        public int compareTo(NBestPath o) {
            return Double.compare(this.score, o.score);
        }

        public String toString() {
            return String.valueOf(this.path) + " [" + this.score + ',' + this.forwardScore + ']';
        }
    }
}

