/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.result;

import edu.cmu.sphinx.linguist.WordSequence;
import edu.cmu.sphinx.linguist.dictionary.Word;
import edu.cmu.sphinx.linguist.language.ngram.LanguageModel;
import edu.cmu.sphinx.result.Edge;
import edu.cmu.sphinx.result.Lattice;
import java.util.LinkedList;
import java.util.List;

public class LatticeRescorer {
    protected final Lattice lattice;
    protected final LanguageModel model;
    private int depth;
    private float languageWeigth = 8.0f;

    public LatticeRescorer(Lattice lattice, LanguageModel model) {
        this.lattice = lattice;
        this.model = model;
        this.depth = model.getMaxDepth();
    }

    private void rescoreEdges() {
        for (Edge edge : this.lattice.edges) {
            float maxProb = -3.4028235E38f;
            if (this.lattice.isFillerNode(edge.getToNode())) {
                edge.setLMScore(maxProb);
                continue;
            }
            List<String> paths = this.allPathsTo("", edge, this.depth);
            for (String path : paths) {
                LinkedList<Word> wordList = new LinkedList<Word>();
                String[] stringArray = path.split(" ");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String pathWord = stringArray[n2];
                    wordList.add(new Word(pathWord, null, false));
                    ++n2;
                }
                wordList.add(edge.getToNode().getWord());
                WordSequence seq = new WordSequence(wordList);
                float prob = this.model.getProbability(seq) * this.languageWeigth;
                if (!(maxProb < prob)) continue;
                maxProb = prob;
            }
            edge.setLMScore(maxProb);
        }
    }

    protected List<String> allPathsTo(String path, Edge edge, int currentDepth) {
        LinkedList<String> l = new LinkedList<String>();
        String p = path;
        boolean isFiller = this.lattice.isFillerNode(edge.getFromNode());
        if (!isFiller) {
            p = String.valueOf(edge.getFromNode().getWord().toString()) + ' ' + p;
        }
        if (currentDepth == 2 || edge.getFromNode().equals(this.lattice.getInitialNode())) {
            l.add(p);
        } else {
            int decrement = isFiller ? 0 : 1;
            for (Edge e : edge.getFromNode().getEnteringEdges()) {
                l.addAll(this.allPathsTo(p, e, currentDepth - decrement));
            }
        }
        return l;
    }

    public void rescore() {
        this.rescoreEdges();
    }
}

