/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.linguist.util;

import edu.cmu.sphinx.linguist.HMMSearchState;
import edu.cmu.sphinx.linguist.SearchState;
import edu.cmu.sphinx.linguist.UnitSearchState;
import edu.cmu.sphinx.linguist.WordSearchState;

class StateLevel {
    private final int level;
    private final SearchState state;

    StateLevel(SearchState state, int level) {
        this.state = state;
        this.level = level;
    }

    SearchState getState() {
        return this.state;
    }

    int getLevel() {
        return this.level;
    }

    public String toString() {
        return String.valueOf(String.valueOf(this.level)) + ' ' + this.state.getSignature() + " 1 " + this.getTypeLabel(this.state);
    }

    public String getTypeLabel(SearchState state) {
        if (state instanceof UnitSearchState) {
            return "Unit";
        }
        if (state instanceof WordSearchState) {
            return "Word";
        }
        if (state instanceof HMMSearchState) {
            return "HMM";
        }
        return "other";
    }
}

