/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.linguist.util;

import edu.cmu.sphinx.linguist.Linguist;
import edu.cmu.sphinx.linguist.LinguistProcessor;
import edu.cmu.sphinx.linguist.SearchState;
import edu.cmu.sphinx.linguist.SearchStateArc;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;

public class LinguistStats
extends LinguistProcessor {
    private final Map<Class<? extends SearchState>, Integer> stateCountByType = new HashMap<Class<? extends SearchState>, Integer>();

    public LinguistStats(Linguist linguist) {
        super(linguist);
    }

    public LinguistStats() {
    }

    @Override
    public void run() {
        Linguist linguist = this.getLinguist();
        LinkedList<SearchState> queue = new LinkedList<SearchState>();
        HashSet<SearchState> visitedStates = new HashSet<SearchState>();
        int stateCount = 0;
        queue.add(linguist.getSearchGraph().getInitialState());
        while (!queue.isEmpty()) {
            SearchState state = (SearchState)queue.remove(0);
            if (visitedStates.contains(state)) continue;
            ++stateCount;
            this.incrementStateTypeCount(state);
            visitedStates.add(state);
            SearchStateArc[] arcs = state.getSuccessors();
            int i = arcs.length - 1;
            while (i >= 0) {
                SearchState nextState = arcs[i].getState();
                queue.add(nextState);
                --i;
            }
        }
        System.out.println("# ----------- linguist stats ------------ ");
        System.out.println("# Total states: " + stateCount);
        this.dumpStateTypeCounts();
    }

    private void incrementStateTypeCount(SearchState state) {
        Integer count = this.stateCountByType.get(state.getClass());
        if (count == null) {
            count = 0;
        }
        count = count + 1;
        this.stateCountByType.put(state.getClass(), count);
    }

    private void dumpStateTypeCounts() {
        for (Map.Entry<Class<? extends SearchState>, Integer> entry : this.stateCountByType.entrySet()) {
            System.out.println("# " + entry.getKey() + ": " + entry.getValue());
        }
    }
}

