/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.linguist.language.ngram.trie;

import edu.cmu.sphinx.linguist.language.ngram.trie.NgramTrieBitarr;

public class NgramTrieQuant {
    private int probBits;
    private int backoffBits;
    private int probMask;
    private int backoffMask;
    private float[][] tables;
    private QuantType quantType;

    public NgramTrieQuant(int order, QuantType quantType) {
        switch (quantType) {
            case NO_QUANT: {
                return;
            }
            case QUANT_16: {
                this.probBits = 16;
                this.backoffBits = 16;
                this.probMask = (1 << this.probBits) - 1;
                this.backoffMask = (1 << this.backoffBits) - 1;
                break;
            }
            default: {
                throw new Error("Unsupported quantization type: " + (Object)((Object)quantType));
            }
        }
        this.tables = new float[(order - 1) * 2 - 1][];
        this.quantType = quantType;
    }

    public void setTable(float[] table, int order, boolean isProb) {
        int index = (order - 2) * 2;
        if (!isProb) {
            ++index;
        }
        this.tables[index] = table;
    }

    public int getProbTableLen() {
        return 1 << this.probBits;
    }

    public int getBackoffTableLen() {
        return 1 << this.backoffBits;
    }

    public int getProbBoSize() {
        switch (this.quantType) {
            case NO_QUANT: {
                return 63;
            }
            case QUANT_16: {
                return 32;
            }
        }
        throw new Error("Unsupported quantization type: " + (Object)((Object)this.quantType));
    }

    public int getProbSize() {
        switch (this.quantType) {
            case NO_QUANT: {
                return 31;
            }
            case QUANT_16: {
                return 16;
            }
        }
        throw new Error("Unsupported quantization type: " + (Object)((Object)this.quantType));
    }

    private float binsDecode(int tableIdx, int encodedVal) {
        return this.tables[tableIdx][encodedVal];
    }

    public float readProb(NgramTrieBitarr bitArr, int memPtr, int bitOffset, int orderMinusTwo) {
        switch (this.quantType) {
            case NO_QUANT: {
                return bitArr.readNegativeFloat(memPtr, bitOffset);
            }
            case QUANT_16: {
                int tableIdx = orderMinusTwo * 2;
                if (tableIdx < this.tables.length - 1) {
                    bitOffset += this.backoffBits;
                }
                return this.binsDecode(tableIdx, bitArr.readInt(memPtr, bitOffset, this.backoffMask));
            }
        }
        throw new Error("Unsupported quantization type: " + (Object)((Object)this.quantType));
    }

    public float readBackoff(NgramTrieBitarr bitArr, int memPtr, int bitOffset, int orderMinusTwo) {
        switch (this.quantType) {
            case NO_QUANT: {
                return bitArr.readFloat(memPtr, bitOffset += 31);
            }
            case QUANT_16: {
                int tableIdx = orderMinusTwo * 2 + 1;
                return this.binsDecode(tableIdx, bitArr.readInt(memPtr, bitOffset, this.probMask));
            }
        }
        throw new Error("Unsupported quantization type: " + (Object)((Object)this.quantType));
    }

    public static enum QuantType {
        NO_QUANT,
        QUANT_16;

    }
}

