/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.linguist.language.ngram.trie;

import edu.cmu.sphinx.linguist.language.ngram.trie.NgramTrieModel;
import edu.cmu.sphinx.linguist.language.ngram.trie.NgramTrieQuant;
import edu.cmu.sphinx.util.Utilities;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

public class BinaryLoader {
    private static final String TRIE_HEADER = "Trie Language Model";
    private DataInputStream inStream;

    public BinaryLoader(File location) throws IOException {
        this.inStream = new DataInputStream(new FileInputStream(location));
    }

    private void loadModelData(InputStream stream) throws IOException {
        DataInputStream dataStream = new DataInputStream(new BufferedInputStream(stream));
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        byte[] buffer = new byte[4096];
        while (dataStream.read(buffer) >= 0) {
            bytes.write(buffer);
        }
        this.inStream = new DataInputStream(new ByteArrayInputStream(bytes.toByteArray()));
    }

    public BinaryLoader(URL location) throws IOException {
        this.loadModelData(location.openStream());
    }

    public void verifyHeader() throws IOException {
        String readHeader = this.readString(this.inStream, TRIE_HEADER.length());
        if (!readHeader.equals(TRIE_HEADER)) {
            throw new Error("Bad binary LM file header: " + readHeader);
        }
    }

    public int[] readCounts() throws IOException {
        int order = this.readOrder();
        int[] counts = new int[order];
        int i = 0;
        while (i < counts.length) {
            counts[i] = Utilities.readLittleEndianInt(this.inStream);
            ++i;
        }
        return counts;
    }

    public NgramTrieQuant readQuant(int order) throws IOException {
        int quantTypeInt = Utilities.readLittleEndianInt(this.inStream);
        if (quantTypeInt < 0 || quantTypeInt >= NgramTrieQuant.QuantType.values().length) {
            throw new Error("Unknown quantatization type: " + quantTypeInt);
        }
        NgramTrieQuant.QuantType quantType = NgramTrieQuant.QuantType.values()[quantTypeInt];
        NgramTrieQuant quant = new NgramTrieQuant(order, quantType);
        int i = 2;
        while (i <= order) {
            quant.setTable(this.readFloatArr(quant.getProbTableLen()), i, true);
            if (i < order) {
                quant.setTable(this.readFloatArr(quant.getBackoffTableLen()), i, false);
            }
            ++i;
        }
        return quant;
    }

    public NgramTrieModel.TrieUnigram[] readUnigrams(int count) throws IOException {
        NgramTrieModel.TrieUnigram[] unigrams = new NgramTrieModel.TrieUnigram[count + 1];
        int i = 0;
        while (i < count + 1) {
            unigrams[i] = new NgramTrieModel.TrieUnigram();
            unigrams[i].prob = Utilities.readLittleEndianFloat(this.inStream);
            unigrams[i].backoff = Utilities.readLittleEndianFloat(this.inStream);
            unigrams[i].next = Utilities.readLittleEndianInt(this.inStream);
            ++i;
        }
        return unigrams;
    }

    public void readTrieByteArr(byte[] arr) throws IOException {
        this.inStream.read(arr);
    }

    public String[] readWords(int unigramNum) throws IOException {
        int len = Utilities.readLittleEndianInt(this.inStream);
        if (len <= 0) {
            throw new Error("Bad word string size: " + len);
        }
        String[] words = new String[unigramNum];
        byte[] bytes = new byte[len];
        this.inStream.read(bytes);
        int s = 0;
        int wordStart = 0;
        int i = 0;
        while (i < len) {
            char c = (char)(bytes[i] & 0xFF);
            if (c == '\u0000') {
                words[s] = new String(bytes, wordStart, i - wordStart);
                wordStart = i + 1;
                ++s;
            }
            ++i;
        }
        assert (s == unigramNum);
        return words;
    }

    public void close() throws IOException {
        this.inStream.close();
    }

    private int readOrder() throws IOException {
        return this.inStream.readByte();
    }

    private float[] readFloatArr(int len) throws IOException {
        float[] arr = new float[len];
        int i = 0;
        while (i < len) {
            arr[i] = Utilities.readLittleEndianFloat(this.inStream);
            ++i;
        }
        return arr;
    }

    private String readString(DataInputStream stream, int length) throws IOException {
        StringBuilder builder = new StringBuilder();
        byte[] bytes = new byte[length];
        stream.read(bytes);
        int i = 0;
        while (i < length) {
            builder.append((char)bytes[i]);
            ++i;
        }
        return builder.toString();
    }
}

