/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.linguist.language.ngram.large;

import edu.cmu.sphinx.linguist.WordSequence;
import edu.cmu.sphinx.linguist.dictionary.Word;
import edu.cmu.sphinx.linguist.language.ngram.large.LargeNGramModel;
import java.util.HashMap;

public class KeywordOptimizerLargeNGramModel
extends LargeNGramModel {
    public HashMap<String, Float> keywordProbs;

    @Override
    public float getProbability(WordSequence wordSequence) {
        float prob = super.getProbability(wordSequence);
        if (this.keywordProbs == null) {
            return prob;
        }
        Word[] wordArray = wordSequence.getWords();
        int n = wordArray.length;
        int n2 = 0;
        while (n2 < n) {
            Word word = wordArray[n2];
            String ws = word.toString();
            if (this.keywordProbs.containsKey(ws)) {
                prob *= this.keywordProbs.get(ws).floatValue();
            }
            ++n2;
        }
        return prob;
    }
}

