/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.linguist.language.ngram;

import edu.cmu.sphinx.linguist.WordSequence;
import edu.cmu.sphinx.linguist.dictionary.Dictionary;
import edu.cmu.sphinx.linguist.dictionary.Word;
import edu.cmu.sphinx.linguist.language.ngram.LanguageModel;
import edu.cmu.sphinx.linguist.language.ngram.Probability;
import edu.cmu.sphinx.util.LogMath;
import edu.cmu.sphinx.util.props.ConfigurationManagerUtils;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public class SimpleNGramModel
implements LanguageModel {
    private String name;
    private LogMath logMath;
    private URL urlLocation;
    private float unigramWeight;
    private Dictionary dictionary;
    private int desiredMaxDepth;
    private int maxNGram;
    private Map<WordSequence, Probability> map;
    private Set<String> vocabulary;
    protected int lineNumber;
    protected BufferedReader reader;
    protected String fileName;
    private boolean allocated;
    private LinkedList<WordSequence> tokens;

    public SimpleNGramModel(String location, Dictionary dictionary, float unigramWeight, int desiredMaxDepth) throws MalformedURLException, ClassNotFoundException {
        this(ConfigurationManagerUtils.resourceToURL(location), dictionary, unigramWeight, desiredMaxDepth);
    }

    public SimpleNGramModel(URL urlLocation, Dictionary dictionary, float unigramWeight, int desiredMaxDepth) {
        this.urlLocation = urlLocation;
        this.unigramWeight = unigramWeight;
        this.logMath = LogMath.getLogMath();
        this.desiredMaxDepth = desiredMaxDepth;
        this.dictionary = dictionary;
        this.map = new HashMap<WordSequence, Probability>();
        this.vocabulary = new HashSet<String>();
        this.tokens = new LinkedList();
    }

    public SimpleNGramModel() {
    }

    @Override
    public void newProperties(PropertySheet ps) throws PropertyException {
        this.logMath = LogMath.getLogMath();
        if (this.allocated) {
            throw new RuntimeException("Can't change properties after allocation");
        }
        this.urlLocation = ConfigurationManagerUtils.getResource("location", ps);
        this.unigramWeight = ps.getFloat("unigramWeight");
        this.desiredMaxDepth = ps.getInt("maxDepth");
        this.dictionary = (Dictionary)ps.getComponent("dictionary");
        this.map = new HashMap<WordSequence, Probability>();
        this.vocabulary = new HashSet<String>();
        this.tokens = new LinkedList();
    }

    @Override
    public void allocate() throws IOException {
        this.allocated = true;
        this.load(this.urlLocation, this.unigramWeight, this.dictionary);
        if (this.desiredMaxDepth > 0 && this.desiredMaxDepth < this.maxNGram) {
            this.maxNGram = this.desiredMaxDepth;
        }
    }

    @Override
    public void deallocate() {
        this.allocated = false;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public float getProbability(WordSequence wordSequence) {
        float logProbability = 0.0f;
        Probability prob = this.getProb(wordSequence);
        logProbability = prob == null ? (wordSequence.size() > 1 ? this.getBackoff(wordSequence.getOldest()) + this.getProbability(wordSequence.getNewest()) : -3.4028235E38f) : prob.logProbability;
        return logProbability;
    }

    @Override
    public float getSmear(WordSequence wordSequence) {
        return 0.0f;
    }

    public float getBackoff(WordSequence wordSequence) {
        float logBackoff = 0.0f;
        Probability prob = this.getProb(wordSequence);
        if (prob != null) {
            logBackoff = prob.logBackoff;
        }
        return logBackoff;
    }

    @Override
    public int getMaxDepth() {
        return this.maxNGram;
    }

    @Override
    public Set<String> getVocabulary() {
        return Collections.unmodifiableSet(this.vocabulary);
    }

    @Override
    public void onUtteranceEnd() {
    }

    private Probability getProb(WordSequence wordSequence) {
        return this.map.get(wordSequence);
    }

    private String listToString(List<Word> wordList) {
        StringBuilder sb = new StringBuilder();
        for (Word word : wordList) {
            sb.append(word).append(' ');
        }
        return sb.toString();
    }

    public void dump() {
        for (Map.Entry<WordSequence, Probability> entry : this.map.entrySet()) {
            System.out.println(entry.getKey() + " " + entry.getValue());
        }
    }

    private String getRepresentation(List<String> wordList) {
        if (wordList.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (String word : wordList) {
            sb.append(word).append('+');
        }
        sb.setLength(sb.length() - 1);
        return sb.toString();
    }

    private void load(URL location, float unigramWeight, Dictionary dictionary) throws IOException {
        String line;
        float logUnigramWeight = this.logMath.linearToLog(unigramWeight);
        float inverseLogUnigramWeight = this.logMath.linearToLog(1.0 - (double)unigramWeight);
        this.open(location);
        this.readUntil("\\data\\");
        ArrayList<Integer> ngramList = new ArrayList<Integer>();
        while ((line = this.readLine()) != null) {
            if (line.startsWith("ngram")) {
                StringTokenizer st = new StringTokenizer(line, " \t\n\r\f=");
                if (st.countTokens() != 3) {
                    this.corrupt("corrupt ngram field " + line + ' ' + st.countTokens());
                }
                st.nextToken();
                int index = Integer.parseInt(st.nextToken());
                int count = Integer.parseInt(st.nextToken());
                ngramList.add(index - 1, count);
                this.maxNGram = Math.max(index, this.maxNGram);
                continue;
            }
            if (line.equals("\\1-grams:")) break;
        }
        int numUnigrams = (Integer)ngramList.get(0) - 1;
        float logUniformProbability = -this.logMath.linearToLog(numUnigrams);
        int index = 0;
        while (index < ngramList.size()) {
            int ngram = index + 1;
            int ngramCount = (Integer)ngramList.get(index);
            int i = 0;
            while (i < ngramCount) {
                StringTokenizer tok = new StringTokenizer(this.readLine());
                int tokenCount = tok.countTokens();
                if (tokenCount != ngram + 1 && tokenCount != ngram + 2) {
                    this.corrupt("Bad format");
                }
                float log10Prob = Float.parseFloat(tok.nextToken());
                float log10Backoff = 0.0f;
                ArrayList<Word> wordList = new ArrayList<Word>(this.maxNGram);
                int j = 0;
                while (j < ngram) {
                    String word = tok.nextToken();
                    this.vocabulary.add(word);
                    Word wordObject = dictionary.getWord(word);
                    if (wordObject == null) {
                        wordObject = Word.UNKNOWN;
                    }
                    wordList.add(wordObject);
                    ++j;
                }
                WordSequence wordSequence = new WordSequence(wordList);
                if (tok.hasMoreTokens()) {
                    log10Backoff = Float.parseFloat(tok.nextToken());
                }
                float logProb = this.logMath.log10ToLog(log10Prob);
                float logBackoff = this.logMath.log10ToLog(log10Backoff);
                if (ngram == 1) {
                    float p1 = logProb + logUnigramWeight;
                    float p2 = logUniformProbability + inverseLogUnigramWeight;
                    logProb = this.logMath.addAsLinear(p1, p2);
                }
                this.put(wordSequence, logProb, logBackoff);
                ++i;
            }
            if (index < ngramList.size() - 1) {
                String next = "\\" + (ngram + 1) + "-grams:";
                this.readUntil(next);
            }
            ++index;
        }
        this.readUntil("\\end\\");
        this.close();
    }

    private void put(WordSequence wordSequence, float logProb, float logBackoff) {
        this.map.put(wordSequence, new Probability(logProb, logBackoff));
        this.tokens.add(wordSequence);
    }

    public LinkedList<WordSequence> getNGrams() {
        return this.tokens;
    }

    private String readLine() throws IOException {
        ++this.lineNumber;
        String line = this.reader.readLine();
        if (line == null) {
            this.corrupt("Premature EOF");
        }
        return line.trim();
    }

    private void open(URL location) throws IOException {
        this.lineNumber = 0;
        this.fileName = location.toString();
        this.reader = new BufferedReader(new InputStreamReader(location.openStream()));
    }

    private void readUntil(String match) throws IOException {
        try {
            while (!this.readLine().equals(match)) {
            }
        }
        catch (IOException ioe) {
            this.corrupt("Premature EOF while waiting for " + match);
        }
    }

    private void close() throws IOException {
        this.reader.close();
        this.reader = null;
    }

    private void corrupt(String why) throws IOException {
        throw new IOException("Corrupt Language Model " + this.fileName + " at line " + this.lineNumber + ':' + why);
    }
}

