/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.linguist.language.ngram;

import edu.cmu.sphinx.linguist.WordSequence;
import edu.cmu.sphinx.linguist.dictionary.Dictionary;
import edu.cmu.sphinx.linguist.dictionary.Word;
import edu.cmu.sphinx.linguist.language.ngram.LanguageModel;
import edu.cmu.sphinx.util.LogMath;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class DynamicTrigramModel
implements LanguageModel {
    private Dictionary dictionary;
    private final Set<String> vocabulary = new HashSet<String>();
    private int maxDepth;
    private float unigramWeight;
    private List<String> sentences;
    private Map<WordSequence, Float> logProbs = new HashMap<WordSequence, Float>();
    private Map<WordSequence, Float> logBackoffs = new HashMap<WordSequence, Float>();

    public DynamicTrigramModel() {
    }

    public DynamicTrigramModel(Dictionary dictionary) {
        this();
        this.dictionary = dictionary;
    }

    @Override
    public void newProperties(PropertySheet ps) throws PropertyException {
        this.dictionary = (Dictionary)ps.getComponent("dictionary");
        this.maxDepth = ps.getInt("maxDepth");
        this.unigramWeight = ps.getFloat("unigramWeight");
    }

    @Override
    public void allocate() throws IOException {
        this.vocabulary.clear();
        this.logProbs.clear();
        this.logBackoffs.clear();
        HashMap<WordSequence, Integer> unigrams = new HashMap<WordSequence, Integer>();
        HashMap<WordSequence, Integer> bigrams = new HashMap<WordSequence, Integer>();
        HashMap<WordSequence, Integer> trigrams = new HashMap<WordSequence, Integer>();
        int wordCount = 0;
        for (String sentence : this.sentences) {
            String[] textWords = sentence.split("\\s+");
            ArrayList<Word> words = new ArrayList<Word>();
            words.add(this.dictionary.getSentenceStartWord());
            String[] stringArray = textWords;
            int n = textWords.length;
            int n2 = 0;
            while (n2 < n) {
                String wordString = stringArray[n2];
                if (wordString.length() != 0) {
                    this.vocabulary.add(wordString);
                    Word word = this.dictionary.getWord(wordString);
                    if (word == null) {
                        words.add(Word.UNKNOWN);
                    } else {
                        words.add(word);
                    }
                }
                ++n2;
            }
            words.add(this.dictionary.getSentenceEndWord());
            if (words.size() > 0) {
                this.addSequence(unigrams, new WordSequence((Word)words.get(0)));
                ++wordCount;
            }
            if (words.size() > 1) {
                ++wordCount;
                this.addSequence(unigrams, new WordSequence((Word)words.get(1)));
                this.addSequence(bigrams, new WordSequence((Word)words.get(0), (Word)words.get(1)));
            }
            int i = 2;
            while (i < words.size()) {
                ++wordCount;
                this.addSequence(unigrams, new WordSequence((Word)words.get(i)));
                this.addSequence(bigrams, new WordSequence((Word)words.get(i - 1), (Word)words.get(i)));
                this.addSequence(trigrams, new WordSequence((Word)words.get(i - 2), (Word)words.get(i - 1), (Word)words.get(i)));
                ++i;
            }
        }
        float discount = 0.5f;
        float deflate = 1.0f - discount;
        HashMap<WordSequence, Float> uniprobs = new HashMap<WordSequence, Float>();
        for (Map.Entry e : unigrams.entrySet()) {
            uniprobs.put((WordSequence)e.getKey(), Float.valueOf((float)((Integer)e.getValue()).intValue() * deflate / (float)wordCount));
        }
        LogMath lmath = LogMath.getLogMath();
        float logUnigramWeight = lmath.linearToLog(this.unigramWeight);
        float invLogUnigramWeight = lmath.linearToLog(1.0f - this.unigramWeight);
        float logUniformProb = -lmath.linearToLog(uniprobs.size());
        TreeSet sorted1grams = new TreeSet(unigrams.keySet());
        Iterator iter = new TreeSet(bigrams.keySet()).iterator();
        WordSequence ws = iter.hasNext() ? (WordSequence)iter.next() : null;
        for (WordSequence unigram : sorted1grams) {
            float f = lmath.linearToLog(((Float)uniprobs.get(unigram)).floatValue());
            f += logUnigramWeight;
            f = lmath.addAsLinear(f, logUniformProb + invLogUnigramWeight);
            this.logProbs.put(unigram, Float.valueOf(f));
            float sum = 0.0f;
            while (ws != null) {
                int cmp = ws.getOldest().compareTo(unigram);
                if (cmp > 0) break;
                if (cmp == 0) {
                    sum += ((Float)uniprobs.get(ws.getNewest())).floatValue();
                }
                WordSequence wordSequence = ws = iter.hasNext() ? (WordSequence)iter.next() : null;
            }
            this.logBackoffs.put(unigram, Float.valueOf(lmath.linearToLog(discount / (1.0f - sum))));
        }
        HashMap<WordSequence, Float> biprobs = new HashMap<WordSequence, Float>();
        for (Map.Entry entry : bigrams.entrySet()) {
            int unigramCount = unigrams.get(((WordSequence)entry.getKey()).getOldest());
            biprobs.put((WordSequence)entry.getKey(), Float.valueOf((float)((Integer)entry.getValue()).intValue() * deflate / (float)unigramCount));
        }
        TreeSet<WordSequence> sorted2grams = new TreeSet<WordSequence>(bigrams.keySet());
        iter = new TreeSet(trigrams.keySet()).iterator();
        ws = iter.hasNext() ? (WordSequence)iter.next() : null;
        for (WordSequence wordSequence : sorted2grams) {
            this.logProbs.put(wordSequence, Float.valueOf(lmath.linearToLog(((Float)biprobs.get(wordSequence)).floatValue())));
            float sum = 0.0f;
            while (ws != null) {
                int cmp = ws.getOldest().compareTo(wordSequence);
                if (cmp > 0) break;
                if (cmp == 0) {
                    sum += ((Float)biprobs.get(ws.getNewest())).floatValue();
                }
                WordSequence wordSequence2 = ws = iter.hasNext() ? (WordSequence)iter.next() : null;
            }
            this.logBackoffs.put(wordSequence, Float.valueOf(lmath.linearToLog(discount / (1.0f - sum))));
        }
        for (Map.Entry entry : trigrams.entrySet()) {
            float p = (float)((Integer)entry.getValue()).intValue() * deflate;
            this.logProbs.put((WordSequence)entry.getKey(), Float.valueOf(lmath.linearToLog(p /= (float)bigrams.get(((WordSequence)entry.getKey()).getOldest()).intValue())));
        }
    }

    private void addSequence(HashMap<WordSequence, Integer> grams, WordSequence wordSequence) {
        Integer count = grams.get(wordSequence);
        if (count != null) {
            grams.put(wordSequence, count + 1);
        } else {
            grams.put(wordSequence, 1);
        }
    }

    @Override
    public void deallocate() throws IOException {
    }

    @Override
    public float getProbability(WordSequence wordSequence) {
        Float backoff;
        float prob = this.logProbs.containsKey(wordSequence) ? this.logProbs.get(wordSequence).floatValue() : (wordSequence.size() > 1 ? ((backoff = this.logBackoffs.get(wordSequence.getOldest())) == null ? 0.0f + this.getProbability(wordSequence.getNewest()) : backoff.floatValue() + this.getProbability(wordSequence.getNewest())) : -3.4028235E38f);
        return prob;
    }

    @Override
    public float getSmear(WordSequence wordSequence) {
        return 0.0f;
    }

    @Override
    public Set<String> getVocabulary() {
        return this.vocabulary;
    }

    @Override
    public int getMaxDepth() {
        return this.maxDepth;
    }

    @Override
    public void onUtteranceEnd() {
    }

    public void setText(List<String> sentences) {
        this.sentences = sentences;
    }
}

