/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.linguist.language.grammar;

import edu.cmu.sphinx.linguist.dictionary.Dictionary;
import edu.cmu.sphinx.linguist.dictionary.Word;
import edu.cmu.sphinx.linguist.language.grammar.GrammarArc;
import edu.cmu.sphinx.linguist.language.grammar.GrammarInterface;
import edu.cmu.sphinx.linguist.language.grammar.GrammarNode;
import edu.cmu.sphinx.util.Timer;
import edu.cmu.sphinx.util.TimerPool;
import edu.cmu.sphinx.util.props.Configurable;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.S4Boolean;
import edu.cmu.sphinx.util.props.S4Component;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class Grammar
implements Configurable,
GrammarInterface {
    @S4Boolean(defaultValue=false)
    public static final String PROP_SHOW_GRAMMAR = "showGrammar";
    @S4Boolean(defaultValue=true)
    public static final String PROP_OPTIMIZE_GRAMMAR = "optimizeGrammar";
    @S4Boolean(defaultValue=false)
    public static final String PROP_ADD_SIL_WORDS = "addSilenceWords";
    @S4Boolean(defaultValue=false)
    public static final String PROP_ADD_FILLER_WORDS = "addFillerWords";
    @S4Component(type=Dictionary.class)
    public static final String PROP_DICTIONARY = "dictionary";
    protected Logger logger;
    private boolean optimizeGrammar = true;
    private boolean addSilenceWords;
    private boolean addFillerWords;
    protected Dictionary dictionary;
    protected GrammarNode initialNode;
    private Set<GrammarNode> grammarNodes;
    private static final Word[][] EMPTY_ALTERNATIVE = new Word[0][0];
    private final Random randomizer = new Random(56L);
    private int maxIdentity;
    private boolean idCheck;

    public Grammar(boolean showGrammar, boolean optimizeGrammar, boolean addSilenceWords, boolean addFillerWords, Dictionary dictionary) {
        this.logger = Logger.getLogger(this.getClass().getName());
        this.optimizeGrammar = optimizeGrammar;
        this.addSilenceWords = addSilenceWords;
        this.addFillerWords = addFillerWords;
        this.dictionary = dictionary;
    }

    public Grammar() {
    }

    @Override
    public void newProperties(PropertySheet ps) throws PropertyException {
        this.logger = ps.getLogger();
        this.optimizeGrammar = ps.getBoolean(PROP_OPTIMIZE_GRAMMAR);
        this.addSilenceWords = ps.getBoolean(PROP_ADD_SIL_WORDS);
        this.addFillerWords = ps.getBoolean(PROP_ADD_FILLER_WORDS);
        this.dictionary = (Dictionary)ps.getComponent(PROP_DICTIONARY);
    }

    public void allocate() throws IOException {
        this.dictionary.allocate();
        this.newGrammar();
        Timer timer = TimerPool.getTimer(this, "grammarLoad");
        timer.start();
        this.initialNode = this.createGrammar();
        timer.stop();
    }

    public void deallocate() {
        this.initialNode = null;
        this.grammarNodes = null;
        this.dictionary.deallocate();
    }

    @Override
    public GrammarNode getInitialNode() {
        return this.initialNode;
    }

    protected void postProcessGrammar() {
        if (this.addFillerWords) {
            this.addFillerWords();
        } else if (this.addSilenceWords) {
            this.addSilenceWords();
        }
        if (this.optimizeGrammar) {
            this.optimizeGrammar();
        }
        this.dumpStatistics();
    }

    public void dumpStatistics() {
        if (this.logger.isLoggable(Level.INFO)) {
            int successorCount = 0;
            this.logger.info("Num nodes : " + this.getNumNodes());
            for (GrammarNode grammarNode : this.grammarNodes) {
                successorCount += grammarNode.getSuccessors().length;
            }
            this.logger.info("Num arcs  : " + successorCount);
            this.logger.info("Avg arcs  : " + (float)successorCount / (float)this.getNumNodes());
        }
    }

    public void dumpRandomSentences(String path, int count) {
        try {
            HashSet<String> set = new HashSet<String>();
            PrintWriter out = new PrintWriter(new FileOutputStream(path));
            int i = 0;
            while (i < count) {
                String s = this.getRandomSentence();
                if (!set.contains(s)) {
                    set.add(s);
                    out.println(s);
                }
                ++i;
            }
            out.close();
        }
        catch (IOException ioe) {
            this.logger.severe("Can't write random sentences to " + path + ' ' + ioe);
        }
    }

    public void dumpRandomSentences(int count) {
        HashSet<String> set = new HashSet<String>();
        int i = 0;
        while (i < count) {
            String s = this.getRandomSentence();
            if (!set.contains(s)) {
                set.add(s);
            }
            ++i;
        }
        ArrayList sampleList = new ArrayList(set);
        Collections.sort(sampleList);
        for (String sentence : sampleList) {
            System.out.println(sentence);
        }
    }

    public String getRandomSentence() {
        StringBuilder sb = new StringBuilder();
        GrammarNode node = this.getInitialNode();
        while (!node.isFinalNode()) {
            Word word;
            if (!node.isEmpty() && !(word = node.getWord()).isFiller()) {
                sb.append(word.getSpelling()).append(' ');
            }
            node = this.selectRandomSuccessor(node);
        }
        return sb.toString().trim();
    }

    private GrammarNode selectRandomSuccessor(GrammarNode node) {
        GrammarArc[] arcs = node.getSuccessors();
        if (arcs.length > 1) {
            double[] linWeights = new double[arcs.length];
            double linWeightsSum = 0.0;
            double EPS = 1.0E-10;
            int i = 0;
            while (i < linWeights.length) {
                linWeights[i] = ((double)arcs[0].getProbability() + 1.0E-10) / ((double)arcs[i].getProbability() + 1.0E-10);
                linWeightsSum += linWeights[i];
                ++i;
            }
            i = 0;
            while (i < linWeights.length) {
                int n = i++;
                linWeights[n] = linWeights[n] / linWeightsSum;
            }
            double selIndex = this.randomizer.nextDouble();
            int index = 0;
            int i2 = 0;
            while (selIndex > 1.0E-10) {
                index = i2;
                selIndex -= linWeights[i2];
                ++i2;
            }
            return arcs[index].getGrammarNode();
        }
        return arcs[0].getGrammarNode();
    }

    public void dumpGrammar(String name) {
        this.getInitialNode().dumpDot(name);
    }

    public int getNumNodes() {
        return this.grammarNodes.size();
    }

    @Override
    public Set<GrammarNode> getGrammarNodes() {
        return this.grammarNodes;
    }

    protected void newGrammar() {
        this.maxIdentity = 0;
        this.grammarNodes = new HashSet<GrammarNode>();
        this.initialNode = null;
    }

    protected abstract GrammarNode createGrammar() throws IOException;

    protected GrammarNode createGrammar(String bogusText) throws NoSuchMethodException {
        throw new NoSuchMethodException("Does not create grammar with reference text");
    }

    public Dictionary getDictionary() {
        return this.dictionary;
    }

    protected GrammarNode createGrammarNode(int identity, String[][] alts) {
        Word[][] alternatives = new Word[alts.length][];
        int i = 0;
        while (i < alternatives.length) {
            alternatives[i] = new Word[alts[i].length];
            int j = 0;
            while (j < alts[i].length) {
                Word word = this.getDictionary().getWord(alts[i][j]);
                if (word == null) {
                    alternatives = EMPTY_ALTERNATIVE;
                    break;
                }
                alternatives[i][j] = word;
                ++j;
            }
            ++i;
        }
        GrammarNode node = new GrammarNode(identity, alternatives);
        this.add(node);
        return node;
    }

    protected GrammarNode createGrammarNode(String word) {
        GrammarNode node = this.createGrammarNode(this.maxIdentity + 1, word);
        return node;
    }

    protected GrammarNode createGrammarNode(boolean isFinal) {
        return this.createGrammarNode(this.maxIdentity + 1, isFinal);
    }

    protected GrammarNode createGrammarNode(int identity, String word) {
        GrammarNode node;
        Word[][] alternatives = EMPTY_ALTERNATIVE;
        Word wordObject = this.getDictionary().getWord(word);
        if (wordObject != null) {
            alternatives = new Word[][]{new Word[1]};
            alternatives[0][0] = wordObject;
            node = new GrammarNode(identity, alternatives);
            this.add(node);
        } else {
            node = this.createGrammarNode(identity, false);
            this.logger.warning("Can't find pronunciation for " + word);
        }
        return node;
    }

    protected GrammarNode createGrammarNode(int identity, boolean isFinal) {
        GrammarNode node = new GrammarNode(identity, isFinal);
        this.add(node);
        return node;
    }

    private void add(GrammarNode node) throws Error {
        if (node.getID() > this.maxIdentity) {
            this.maxIdentity = node.getID();
        }
        if (this.idCheck) {
            for (GrammarNode grammarNode : this.grammarNodes) {
                if (grammarNode.getID() != node.getID()) continue;
                throw new Error("DUP ID " + grammarNode + " and " + node);
            }
        }
        this.grammarNodes.add(node);
    }

    private void optimizeGrammar() {
        Set<GrammarNode> nodes = this.getGrammarNodes();
        for (GrammarNode node : nodes) {
            node.optimize();
        }
    }

    private void addSilenceWords() {
        HashSet<GrammarNode> nodes = new HashSet<GrammarNode>(this.getGrammarNodes());
        for (GrammarNode g : nodes) {
            if (g.isEmpty() || g.getWord().isFiller()) continue;
            GrammarNode silNode = this.createGrammarNode(this.maxIdentity + 1, this.dictionary.getSilenceWord().getSpelling());
            GrammarNode branchNode = g.splitNode(this.maxIdentity + 1);
            this.add(branchNode);
            g.add(silNode, 0.0f);
            silNode.add(branchNode, 0.0f);
            silNode.add(silNode, 0.0f);
        }
    }

    private void addFillerWords() {
        HashSet<GrammarNode> nodes = new HashSet<GrammarNode>(this.getGrammarNodes());
        Word[] fillers = this.getInterWordFillers();
        if (fillers.length == 0) {
            return;
        }
        for (GrammarNode wordNode : nodes) {
            if (wordNode.isEmpty() || wordNode.getWord().isFiller()) continue;
            GrammarNode wordExitNode = wordNode.splitNode(this.maxIdentity + 1);
            this.add(wordExitNode);
            GrammarNode fillerStart = this.createGrammarNode(false);
            GrammarNode fillerEnd = this.createGrammarNode(false);
            fillerEnd.add(fillerStart, 0.0f);
            fillerEnd.add(wordExitNode, 0.0f);
            wordNode.add(fillerStart, 0.0f);
            Word[] wordArray = fillers;
            int n = fillers.length;
            int n2 = 0;
            while (n2 < n) {
                Word filler = wordArray[n2];
                GrammarNode fnode = this.createGrammarNode(this.maxIdentity + 1, filler.getSpelling());
                fillerStart.add(fnode, 0.0f);
                fnode.add(fillerEnd, 0.0f);
                ++n2;
            }
        }
    }

    private Word[] getInterWordFillers() {
        Word[] fillers;
        ArrayList<Word> fillerList = new ArrayList<Word>();
        Word[] wordArray = fillers = this.dictionary.getFillerWords();
        int n = fillers.length;
        int n2 = 0;
        while (n2 < n) {
            Word fillerWord = wordArray[n2];
            if (fillerWord != this.dictionary.getSentenceStartWord() && fillerWord != this.dictionary.getSentenceEndWord()) {
                fillerList.add(fillerWord);
            }
            ++n2;
        }
        return fillerList.toArray(new Word[fillerList.size()]);
    }
}

