/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.linguist.g2p;

import edu.cmu.sphinx.fst.Arc;
import edu.cmu.sphinx.fst.Fst;
import edu.cmu.sphinx.fst.ImmutableFst;
import edu.cmu.sphinx.fst.State;
import edu.cmu.sphinx.fst.operations.ArcSort;
import edu.cmu.sphinx.fst.operations.Compose;
import edu.cmu.sphinx.fst.operations.ILabelCompare;
import edu.cmu.sphinx.fst.operations.NShortestPaths;
import edu.cmu.sphinx.fst.operations.OLabelCompare;
import edu.cmu.sphinx.fst.operations.Project;
import edu.cmu.sphinx.fst.operations.ProjectType;
import edu.cmu.sphinx.fst.operations.RmEpsilon;
import edu.cmu.sphinx.fst.semiring.Semiring;
import edu.cmu.sphinx.fst.semiring.TropicalSemiring;
import edu.cmu.sphinx.fst.utils.Utils;
import edu.cmu.sphinx.linguist.g2p.Path;
import edu.cmu.sphinx.linguist.g2p.PathComparator;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.regex.Pattern;

public class G2PConverter {
    String eps = "<eps>";
    String se = "</s>";
    String sb = "<s>";
    String skip = "_";
    String tie = "|";
    HashSet<String> skipSeqs = new HashSet();
    ArrayList<String>[] clusters = null;
    ImmutableFst g2pmodel;
    Fst epsilonFilter;

    public G2PConverter(URL g2pModelUrl) throws IOException {
        try {
            this.g2pmodel = ImmutableFst.loadModel(g2pModelUrl.openStream());
        }
        catch (ClassNotFoundException e) {
            throw new IOException("Failed to load the model from " + g2pModelUrl, e);
        }
        this.init();
    }

    public G2PConverter(String g2pmodel_file) {
        this.g2pmodel = ImmutableFst.loadModel(g2pmodel_file);
        this.init();
    }

    private void init() {
        this.skipSeqs.add(this.eps);
        this.skipSeqs.add(this.sb);
        this.skipSeqs.add(this.se);
        this.skipSeqs.add(this.skip);
        this.skipSeqs.add("-");
        Compose.augment(0, this.g2pmodel, this.g2pmodel.getSemiring());
        ArcSort.apply(this.g2pmodel, new ILabelCompare());
        String[] isyms = this.g2pmodel.getIsyms();
        this.loadClusters(isyms);
        this.epsilonFilter = Compose.getFilter(this.g2pmodel.getIsyms(), this.g2pmodel.getSemiring());
        ArcSort.apply(this.epsilonFilter, new ILabelCompare());
    }

    public ArrayList<Path> phoneticize(ArrayList<String> entry, int nbest) {
        Fst efst = this.entryToFSA(entry);
        Semiring s = efst.getSemiring();
        Compose.augment(1, efst, s);
        ArcSort.apply(efst, new OLabelCompare());
        Fst result = Compose.compose(efst, this.epsilonFilter, s, true);
        ArcSort.apply(result, new OLabelCompare());
        result = Compose.compose(result, this.g2pmodel, s, true);
        Project.apply(result, ProjectType.OUTPUT);
        result = nbest == 1 ? NShortestPaths.get(result, 1, false) : NShortestPaths.get(result, nbest * 10, false);
        result = RmEpsilon.get(result);
        ArrayList<Path> paths = this.findAllPaths(result, nbest, this.skipSeqs, this.tie);
        return paths;
    }

    public ArrayList<Path> phoneticize(String word, int nbest) {
        ArrayList<String> entry = new ArrayList<String>(word.length());
        int i = 0;
        while (i < word.length()) {
            String ch = word.substring(i, i + 1);
            if (Utils.getIndex(this.g2pmodel.getIsyms(), ch) >= 0) {
                entry.add(ch);
            }
            ++i;
        }
        return this.phoneticize(entry, nbest);
    }

    private Fst entryToFSA(ArrayList<String> entry) {
        TropicalSemiring ts = new TropicalSemiring();
        Fst efst = new Fst(ts);
        State s = new State(ts.zero());
        efst.addState(s);
        efst.setStart(s);
        int i = 0;
        while (i < entry.size() + 1) {
            s = new State(ts.zero());
            efst.addState(s);
            if (i >= 1) {
                int symIndex = Utils.getIndex(this.g2pmodel.getIsyms(), entry.get(i - 1));
                efst.getState(i).addArc(new Arc(symIndex, symIndex, 0.0f, s));
            } else if (i == 0) {
                int symIndex = Utils.getIndex(this.g2pmodel.getIsyms(), this.sb);
                efst.getStart().addArc(new Arc(symIndex, symIndex, 0.0f, s));
            }
            if (i == entry.size()) {
                State s1 = new State(ts.zero());
                efst.addState(s1);
                int symIndex = Utils.getIndex(this.g2pmodel.getIsyms(), this.se);
                s.addArc(new Arc(symIndex, symIndex, 0.0f, s1));
                s1.setFinalWeight(0.0f);
            }
            ++i;
        }
        int value = 0;
        while (value < this.clusters.length) {
            ArrayList<String> cluster = this.clusters[value];
            if (cluster != null) {
                int start = 0;
                int k = 0;
                while (k != -1) {
                    k = Utils.search(entry, cluster, start);
                    if (k == -1) continue;
                    State from = efst.getState(start + k + 1);
                    from.addArc(new Arc(value, value, 0.0f, efst.getState(start + k + cluster.size() + 1)));
                    start = start + k + cluster.size();
                }
            }
            ++value;
        }
        efst.setIsyms(this.g2pmodel.getIsyms());
        efst.setOsyms(this.g2pmodel.getIsyms());
        return efst;
    }

    private ArrayList<Path> findAllPaths(Fst fst, int nbest, HashSet<String> skipSeqs, String tie) {
        Semiring semiring = fst.getSemiring();
        HashMap<String, Path> finalPaths = new HashMap<String, Path>();
        HashMap<State, Path> paths = new HashMap<State, Path>();
        LinkedList<State> queue = new LinkedList<State>();
        Path p = new Path(fst.getSemiring());
        p.setCost(semiring.one());
        paths.put(fst.getStart(), p);
        queue.add(fst.getStart());
        String[] osyms = fst.getOsyms();
        while (!queue.isEmpty()) {
            State s = (State)queue.remove();
            Path currentPath = (Path)paths.get(s);
            if (s.getFinalWeight() != semiring.zero()) {
                String pathString = currentPath.getPath().toString();
                if (finalPaths.containsKey(pathString)) {
                    Path old = (Path)finalPaths.get(pathString);
                    if (old.getCost() > currentPath.getCost()) {
                        finalPaths.put(pathString, currentPath);
                    }
                } else {
                    finalPaths.put(pathString, currentPath);
                }
            }
            int numArcs = s.getNumArcs();
            int j = 0;
            while (j < numArcs) {
                Arc a = s.getArc(j);
                p = new Path(fst.getSemiring());
                Path cur = (Path)paths.get(s);
                p.setCost(cur.getCost());
                p.setPath((ArrayList)cur.getPath().clone());
                String sym = osyms[a.getOlabel()];
                String[] symsArray = sym.split("\\" + tie);
                int i = 0;
                while (i < symsArray.length) {
                    String phone = symsArray[i];
                    if (!skipSeqs.contains(phone)) {
                        p.getPath().add(phone);
                    }
                    ++i;
                }
                p.setCost(semiring.times(p.getCost(), a.getWeight()));
                State nextState = a.getNextState();
                paths.put(nextState, p);
                if (!queue.contains(nextState)) {
                    queue.add(nextState);
                }
                ++j;
            }
        }
        ArrayList<Path> res = new ArrayList<Path>();
        for (Path path : finalPaths.values()) {
            res.add(path);
        }
        Collections.sort(res, new PathComparator());
        int numPaths = res.size();
        int i = nbest;
        while (i < numPaths) {
            res.remove(res.size() - 1);
            ++i;
        }
        return res;
    }

    private void loadClusters(String[] syms) {
        this.clusters = new ArrayList[syms.length];
        int i = 0;
        while (i < syms.length) {
            this.clusters[i] = null;
            ++i;
        }
        i = 2;
        while (i < syms.length) {
            String sym = syms[i];
            if (sym.contains(this.tie)) {
                String[] split = sym.split(Pattern.quote(this.tie));
                ArrayList<String> cluster = new ArrayList<String>(Arrays.asList(split));
                this.clusters[i] = cluster;
            }
            ++i;
        }
    }
}

