/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.linguist.flat;

import edu.cmu.sphinx.linguist.acoustic.LeftRightContext;
import edu.cmu.sphinx.linguist.acoustic.Unit;
import edu.cmu.sphinx.linguist.acoustic.UnitManager;
import edu.cmu.sphinx.util.Cache;

class UnitContext {
    private static final Cache<UnitContext> unitContextCache = new Cache();
    private final Unit[] context;
    private int hashCode = 12;
    public static final UnitContext EMPTY = new UnitContext(Unit.EMPTY_ARRAY);
    public static final UnitContext SILENCE = new UnitContext(new Unit[]{UnitManager.SILENCE});

    static {
        unitContextCache.cache(EMPTY);
        unitContextCache.cache(SILENCE);
    }

    private UnitContext(Unit[] context) {
        this.context = context;
        this.hashCode = 12;
        int i = 0;
        while (i < context.length) {
            this.hashCode += context[i].getName().hashCode() * ((i + 1) * 34);
            ++i;
        }
    }

    static UnitContext get(Unit[] units) {
        UnitContext newUC = new UnitContext(units);
        UnitContext cachedUC = unitContextCache.cache(newUC);
        return cachedUC == null ? newUC : cachedUC;
    }

    public Unit[] getUnits() {
        return this.context;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof UnitContext) {
            UnitContext other = (UnitContext)o;
            if (this.context.length != other.context.length) {
                return false;
            }
            int i = 0;
            while (i < this.context.length) {
                if (this.context[i] != other.context[i]) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public static void dumpInfo() {
        System.out.println("Total number of UnitContexts : " + unitContextCache.getMisses() + " folded: " + unitContextCache.getHits());
    }

    public String toString() {
        return LeftRightContext.getContextName(this.context);
    }
}

