/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.linguist.flat;

import edu.cmu.sphinx.linguist.SearchState;
import edu.cmu.sphinx.linguist.SearchStateArc;
import edu.cmu.sphinx.linguist.WordSequence;
import edu.cmu.sphinx.linguist.dictionary.Word;
import edu.cmu.sphinx.linguist.flat.SentenceHMMStateArc;
import edu.cmu.sphinx.linguist.flat.SentenceHMMStateVisitor;
import edu.cmu.sphinx.linguist.flat.WordState;
import java.io.Serializable;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public abstract class SentenceHMMState
implements Serializable,
SearchState {
    private static final int MASK_IS_FINAL = 1;
    private static final int MASK_COLOR_RED = 2;
    private static final int MASK_PROCESSED = 4;
    private static final int MASK_FAN_IN = 8;
    private static final int MASK_IS_WORD_START = 16;
    private static final int MASK_IS_SHARED_STATE = 32;
    private static final int MASK_WHICH = 65535;
    private static final int SHIFT_WHICH = 8;
    private static int globalStateNumber = -1000;
    private int stateNumber = globalStateNumber--;
    private int fields;
    private String name;
    private final Map<String, SentenceHMMStateArc> arcs = new LinkedHashMap<String, SentenceHMMStateArc>();
    private SentenceHMMState parent;
    private String cachedName;
    private String fullName;
    private SentenceHMMStateArc[] successorArray;

    protected SentenceHMMState(String name, SentenceHMMState parent, int which) {
        this();
        this.name = String.valueOf(name) + which;
        this.parent = parent;
        this.setWhich(which);
        this.setProcessed(false);
        this.setColor(Color.RED);
    }

    protected SentenceHMMState() {
    }

    public boolean isWordStart() {
        return (this.fields & 0x10) == 16;
    }

    public void setWordStart(boolean wordStart) {
        this.fields = wordStart ? (this.fields |= 0x10) : (this.fields &= 0xFFFFFFEF);
    }

    public boolean isSharedState() {
        return (this.fields & 0x20) == 32;
    }

    public void setSharedState(boolean shared) {
        this.fields = shared ? (this.fields |= 0x20) : (this.fields &= 0xFFFFFFDF);
    }

    public Word getAssociatedWord() {
        Word word = null;
        SentenceHMMState state = this;
        while (state != null && !(state instanceof WordState)) {
            state = state.getParent();
        }
        if (state != null) {
            WordState wordState = (WordState)state;
            word = wordState.getWord();
        }
        return word;
    }

    public String getTypeLabel() {
        return "state";
    }

    public boolean isFanIn() {
        return (this.fields & 8) == 8;
    }

    public void setFanIn(boolean fanIn) {
        this.fields = fanIn ? (this.fields |= 8) : (this.fields &= 0xFFFFFFF7);
    }

    public void setProcessed(boolean processed) {
        this.fields = processed ? (this.fields |= 4) : (this.fields &= 0xFFFFFFFB);
    }

    public boolean isProcessed() {
        return (this.fields & 4) == 4;
    }

    public void resetAllProcessed() {
        SentenceHMMState.visitStates(new SentenceHMMStateVisitor(){

            @Override
            public boolean visit(SentenceHMMState state) {
                state.setProcessed(false);
                return false;
            }
        }, this, false);
    }

    @Override
    public WordSequence getWordHistory() {
        return WordSequence.EMPTY;
    }

    public int getNumSuccessors() {
        return this.arcs.size();
    }

    @Override
    public SearchStateArc[] getSuccessors() {
        if (this.successorArray == null) {
            this.successorArray = this.arcs.values().toArray(new SentenceHMMStateArc[this.arcs.size()]);
        }
        return this.successorArray;
    }

    @Override
    public SentenceHMMState getLexState() {
        return this;
    }

    void deleteSuccessor(SentenceHMMStateArc arc) {
        this.arcs.values().remove(arc);
    }

    public void connect(SentenceHMMStateArc arc) {
        if (this.successorArray != null) {
            this.successorArray = null;
        }
        this.rawConnect(arc);
    }

    private void rawConnect(SentenceHMMStateArc arc) {
        SentenceHMMState state = (SentenceHMMState)arc.getState();
        this.arcs.put(String.valueOf(state.getValueSignature()) + state.getStateNumber(), arc);
    }

    @Override
    public boolean isEmitting() {
        return false;
    }

    @Override
    public boolean isFinal() {
        return (this.fields & 1) == 1;
    }

    public void setFinalState(boolean state) {
        this.fields = state ? (this.fields |= 1) : (this.fields &= 0xFFFFFFFE);
    }

    public boolean isUnit() {
        return false;
    }

    public void dumpAll() {
        SentenceHMMState.visitStates(new SentenceHMMStateVisitor(){

            @Override
            public boolean visit(SentenceHMMState state) {
                state.dump();
                return false;
            }
        }, this, true);
    }

    protected String getAnnotation() {
        return "";
    }

    private void dump() {
        System.out.println(" ----- " + this.getTitle() + " ---- ");
        int i = 0;
        while (i < this.getSuccessors().length) {
            SentenceHMMStateArc arc = (SentenceHMMStateArc)this.getSuccessors()[i];
            System.out.println("   -> " + arc.getState().toPrettyString());
            ++i;
        }
    }

    public void validateAll() {
    }

    public String getName() {
        return this.name;
    }

    public String getPrettyName() {
        return this.getName();
    }

    public String toString() {
        if (this.cachedName == null) {
            StringBuilder sb = new StringBuilder();
            if (this.isEmitting()) {
                sb.append('*');
            }
            sb.append(this.getName());
            if (this.parent != null) {
                sb.append('_');
                sb.append(this.parent);
            }
            if (this.isFinal()) {
                sb.append('!');
            }
            this.cachedName = sb.toString();
        }
        return this.cachedName;
    }

    @Override
    public String toPrettyString() {
        return this.toString();
    }

    public String getFullName() {
        if (this.fullName == null) {
            this.fullName = this.parent == null ? this.getName() : String.valueOf(this.getName()) + '.' + this.parent.getFullName();
        }
        return this.fullName;
    }

    @Override
    public String getSignature() {
        return this.getFullName();
    }

    public String getTitle() {
        return String.valueOf(this.getFullName()) + ':' + this.stateNumber;
    }

    public int getWhich() {
        return this.fields >> 8 & 0xFFFF;
    }

    public void setWhich(int which) {
        assert (which >= 0 && which <= 65535);
        this.fields |= (which & 0xFFFF) << 8;
    }

    public SentenceHMMState getParent() {
        return this.parent;
    }

    public SentenceHMMStateArc findArc(SentenceHMMState state) {
        return this.arcs.get(state.getValueSignature());
    }

    public String getValueSignature() {
        return this.getFullName();
    }

    public static boolean visitStates(SentenceHMMStateVisitor visitor, SentenceHMMState start, boolean sorted) {
        Set<SentenceHMMState> states = SentenceHMMState.collectStates(start);
        if (sorted) {
            TreeSet<SentenceHMMState> sortedStates = new TreeSet<SentenceHMMState>(new Comparator<SentenceHMMState>(){

                @Override
                public int compare(SentenceHMMState o1, SentenceHMMState o2) {
                    SentenceHMMState so1 = o1;
                    SentenceHMMState so2 = o2;
                    return so1.stateNumber - so2.stateNumber;
                }
            });
            sortedStates.addAll(states);
            states = sortedStates;
        }
        for (SentenceHMMState state : states) {
            if (!visitor.visit(state)) continue;
            return true;
        }
        return false;
    }

    public void setColor(Color color) {
        this.fields = color == Color.RED ? (this.fields |= 2) : (this.fields &= 0xFFFFFFFD);
    }

    public Color getColor() {
        if ((this.fields & 2) == 2) {
            return Color.RED;
        }
        return Color.GREEN;
    }

    private int getStateNumber() {
        return this.stateNumber;
    }

    public static Set<SentenceHMMState> collectStates(SentenceHMMState start) {
        HashSet<SentenceHMMState> visitedStates = new HashSet<SentenceHMMState>();
        LinkedList<SentenceHMMState> queue = new LinkedList<SentenceHMMState>();
        queue.add(start);
        while (!queue.isEmpty()) {
            SearchStateArc[] successors;
            SentenceHMMState state = (SentenceHMMState)queue.remove(0);
            visitedStates.add(state);
            SearchStateArc[] searchStateArcArray = successors = state.getSuccessors();
            int n = successors.length;
            int n2 = 0;
            while (n2 < n) {
                SearchStateArc arc = searchStateArcArray[n2];
                SentenceHMMState nextState = (SentenceHMMState)arc.getState();
                if (!visitedStates.contains(nextState) && !queue.contains(nextState)) {
                    queue.add(nextState);
                }
                ++n2;
            }
        }
        return visitedStates;
    }

    @Override
    public abstract int getOrder();

    public static enum Color {
        RED,
        GREEN;

    }
}

