/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.linguist.flat;

import edu.cmu.sphinx.linguist.flat.UnitContext;
import edu.cmu.sphinx.util.Cache;

class ContextPair {
    static final Cache<ContextPair> contextPairCache = new Cache();
    private final UnitContext left;
    private final UnitContext right;
    private final int hashCode;

    private ContextPair(UnitContext left, UnitContext right) {
        this.left = left;
        this.right = right;
        this.hashCode = 99 + left.hashCode() * 113 + right.hashCode();
    }

    static ContextPair get(UnitContext left, UnitContext right) {
        ContextPair newCP = new ContextPair(left, right);
        ContextPair cachedCP = contextPairCache.cache(newCP);
        return cachedCP == null ? newCP : cachedCP;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof ContextPair) {
            ContextPair other = (ContextPair)o;
            return this.left.equals(other.left) && this.right.equals(other.right);
        }
        return false;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        return "CP left: " + this.left + " right: " + this.right;
    }

    public UnitContext getLeftContext() {
        return this.left;
    }

    public UnitContext getRightContext() {
        return this.right;
    }
}

