/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.linguist.flat;

import edu.cmu.sphinx.linguist.SearchGraph;
import edu.cmu.sphinx.linguist.SearchState;
import edu.cmu.sphinx.linguist.acoustic.AcousticModel;
import edu.cmu.sphinx.linguist.acoustic.HMM;
import edu.cmu.sphinx.linguist.acoustic.HMMPosition;
import edu.cmu.sphinx.linguist.acoustic.HMMState;
import edu.cmu.sphinx.linguist.acoustic.HMMStateArc;
import edu.cmu.sphinx.linguist.acoustic.Unit;
import edu.cmu.sphinx.linguist.flat.BranchOutState;
import edu.cmu.sphinx.linguist.flat.HMMStateState;
import edu.cmu.sphinx.linguist.flat.LoopBackState;
import edu.cmu.sphinx.linguist.flat.NonEmittingHMMState;
import edu.cmu.sphinx.linguist.flat.SentenceHMMState;
import edu.cmu.sphinx.linguist.flat.SentenceHMMStateArc;
import edu.cmu.sphinx.linguist.flat.UnitState;
import edu.cmu.sphinx.linguist.flat.UnknownWordState;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class CIPhoneLoop {
    public final AcousticModel model;
    private final float logPhoneInsertionProbability;
    public final float logOne = 0.0f;

    public CIPhoneLoop(AcousticModel model, float logPhoneInsertionProbability) {
        this.model = model;
        this.logPhoneInsertionProbability = logPhoneInsertionProbability;
    }

    public SearchGraph getSearchGraph() {
        return new PhoneLoopSearchGraph();
    }

    protected class PhoneLoopSearchGraph
    implements SearchGraph {
        protected final Map<String, SearchState> existingStates = new HashMap<String, SearchState>();
        protected final SentenceHMMState firstState = new UnknownWordState();

        public PhoneLoopSearchGraph() {
            BranchOutState branchState = new BranchOutState(this.firstState);
            this.attachState(this.firstState, branchState, 0.0f, 0.0f);
            LoopBackState lastState = new LoopBackState(this.firstState);
            lastState.setFinalState(true);
            this.attachState(lastState, branchState, 0.0f, 0.0f);
            Iterator<Unit> i = CIPhoneLoop.this.model.getContextIndependentUnitIterator();
            while (i.hasNext()) {
                UnitState unitState = new UnitState(i.next(), HMMPosition.UNDEFINED);
                this.attachState(branchState, unitState, 0.0f, CIPhoneLoop.this.logPhoneInsertionProbability);
                HMM hmm = CIPhoneLoop.this.model.lookupNearestHMM(unitState.getUnit(), unitState.getPosition(), false);
                HMMState initialState = hmm.getInitialState();
                HMMStateState hmmTree = new HMMStateState(unitState, initialState);
                this.addStateToCache(hmmTree);
                this.attachState(unitState, hmmTree, 0.0f, 0.0f);
                HMMStateState finalState = this.expandHMMTree(unitState, hmmTree);
                this.attachState(finalState, lastState, 0.0f, 0.0f);
            }
        }

        @Override
        public SearchState getInitialState() {
            return this.firstState;
        }

        @Override
        public int getNumStateOrder() {
            return 5;
        }

        @Override
        public boolean getWordTokenFirst() {
            return false;
        }

        private SentenceHMMState getExistingState(SentenceHMMState state) {
            return (SentenceHMMState)this.existingStates.get(state.getSignature());
        }

        protected void addStateToCache(SentenceHMMState state) {
            this.existingStates.put(state.getSignature(), state);
        }

        protected HMMStateState expandHMMTree(UnitState parent, HMMStateState tree) {
            HMMStateState retState = tree;
            HMMStateArc[] hMMStateArcArray = tree.getHMMState().getSuccessors();
            int n = hMMStateArcArray.length;
            int n2 = 0;
            while (n2 < n) {
                HMMStateArc arc = hMMStateArcArray[n2];
                HMMStateState newState = arc.getHMMState().isEmitting() ? new HMMStateState(parent, arc.getHMMState()) : new NonEmittingHMMState(parent, arc.getHMMState());
                SentenceHMMState existingState = this.getExistingState(newState);
                float logProb = arc.getLogProbability();
                if (existingState != null) {
                    this.attachState(tree, existingState, 0.0f, logProb);
                } else {
                    this.attachState(tree, newState, 0.0f, logProb);
                    this.addStateToCache(newState);
                    retState = this.expandHMMTree(parent, newState);
                }
                ++n2;
            }
            return retState;
        }

        protected void attachState(SentenceHMMState prevState, SentenceHMMState nextState, float logLanguageProbability, float logInsertionProbability) {
            SentenceHMMStateArc arc = new SentenceHMMStateArc(nextState, logLanguageProbability, logInsertionProbability);
            prevState.connect(arc);
        }
    }
}

