/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.linguist.dictionary;

import edu.cmu.sphinx.linguist.acoustic.Unit;
import edu.cmu.sphinx.linguist.dictionary.Word;
import java.util.List;

public class Pronunciation {
    public static final Pronunciation UNKNOWN = new Pronunciation(Unit.EMPTY_ARRAY, null, 1.0f);
    private Word word;
    private final Unit[] units;
    private final String tag;
    private final float probability;

    public Pronunciation(Unit[] units, String tag, float probability) {
        this.units = units;
        this.tag = tag;
        this.probability = probability;
    }

    protected Pronunciation(List<Unit> units, String tag, float probability) {
        Unit[] unitsArray = units.toArray(new Unit[units.size()]);
        this.units = unitsArray;
        this.tag = tag;
        this.probability = probability;
    }

    protected Pronunciation(List<Unit> units) {
        this(units, null, 1.0f);
    }

    public void setWord(Word word) {
        if (this.word != null) {
            throw new Error("Word of Pronunciation cannot be set twice.");
        }
        this.word = word;
    }

    public Word getWord() {
        return this.word;
    }

    public Unit[] getUnits() {
        return this.units;
    }

    public String getTag() {
        return this.tag;
    }

    public float getProbability() {
        return this.probability;
    }

    public void dump() {
        System.out.println(this.toString());
    }

    public String toString() {
        StringBuilder result = new StringBuilder().append(this.word).append('(');
        Unit[] unitArray = this.units;
        int n = this.units.length;
        int n2 = 0;
        while (n2 < n) {
            Unit unit = unitArray[n2];
            result.append(unit).append(' ');
            ++n2;
        }
        result.append(')');
        return result.toString();
    }

    public String toDetailedString() {
        StringBuilder result = new StringBuilder().append(this.word).append(' ');
        Unit[] unitArray = this.units;
        int n = this.units.length;
        int n2 = 0;
        while (n2 < n) {
            Unit unit = unitArray[n2];
            result.append(unit).append(' ');
            ++n2;
        }
        result.append("\n   class: ").append(" tag: ").append(this.tag).append(" prob: ").append(this.probability);
        return result.toString();
    }
}

