/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.linguist.allphone;

import edu.cmu.sphinx.decoder.scorer.ScoreProvider;
import edu.cmu.sphinx.frontend.Data;
import edu.cmu.sphinx.linguist.SearchState;
import edu.cmu.sphinx.linguist.SearchStateArc;
import edu.cmu.sphinx.linguist.WordSequence;
import edu.cmu.sphinx.linguist.acoustic.HMMState;
import edu.cmu.sphinx.linguist.acoustic.HMMStateArc;
import edu.cmu.sphinx.linguist.acoustic.Unit;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.SenoneHMM;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.SenoneSequence;
import edu.cmu.sphinx.linguist.allphone.AllphoneLinguist;
import edu.cmu.sphinx.linguist.allphone.PhoneNonEmittingSearchState;
import java.util.ArrayList;

public class PhoneHmmSearchState
implements SearchState,
SearchStateArc,
ScoreProvider {
    private HMMState state;
    private AllphoneLinguist linguist;
    private float insertionProb;
    private float languageProb;

    public PhoneHmmSearchState(HMMState hmmState, AllphoneLinguist linguist, float insertionProb, float languageProb) {
        this.state = hmmState;
        this.linguist = linguist;
        this.insertionProb = insertionProb;
        this.languageProb = languageProb;
    }

    @Override
    public SearchState getState() {
        return this;
    }

    public int getBaseId() {
        return ((SenoneHMM)this.state.getHMM()).getBaseUnit().getBaseID();
    }

    @Override
    public float getProbability() {
        return this.getLanguageProbability() + this.getInsertionProbability();
    }

    @Override
    public float getLanguageProbability() {
        return this.languageProb;
    }

    @Override
    public float getInsertionProbability() {
        return this.insertionProb;
    }

    @Override
    public SearchStateArc[] getSuccessors() {
        if (this.state.isExitState()) {
            ArrayList<Unit> units = this.linguist.getUnits(((SenoneHMM)this.state.getHMM()).getSenoneSequence());
            SearchStateArc[] result = new SearchStateArc[units.size()];
            int i = 0;
            while (i < result.length) {
                result[i] = new PhoneNonEmittingSearchState(units.get(i), this.linguist, this.insertionProb, this.languageProb);
                ++i;
            }
            return result;
        }
        HMMStateArc[] successors = this.state.getSuccessors();
        SearchStateArc[] results = new SearchStateArc[successors.length];
        int i = 0;
        while (i < successors.length) {
            results[i] = new PhoneHmmSearchState(successors[i].getHMMState(), this.linguist, this.insertionProb, this.languageProb);
            ++i;
        }
        return results;
    }

    @Override
    public boolean isEmitting() {
        return this.state.isEmitting();
    }

    @Override
    public boolean isFinal() {
        return false;
    }

    @Override
    public String toPrettyString() {
        return "HMM " + this.state.toString();
    }

    @Override
    public String getSignature() {
        return null;
    }

    @Override
    public WordSequence getWordHistory() {
        return null;
    }

    @Override
    public Object getLexState() {
        return null;
    }

    @Override
    public int getOrder() {
        return 2;
    }

    @Override
    public float getScore(Data data) {
        return this.state.getScore(data);
    }

    @Override
    public float[] getComponentScore(Data feature) {
        return this.state.calculateComponentScore(feature);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PhoneHmmSearchState)) {
            return false;
        }
        SenoneSequence otherSenoneSeq = ((SenoneHMM)((PhoneHmmSearchState)obj).state.getHMM()).getSenoneSequence();
        SenoneSequence thisSenoneSeq = ((SenoneHMM)this.state.getHMM()).getSenoneSequence();
        return thisSenoneSeq.equals(otherSenoneSeq);
    }

    public int hashCode() {
        return ((SenoneHMM)this.state.getHMM()).getSenoneSequence().hashCode() + this.state.getState() * 37;
    }
}

