/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.linguist.aflat;

import edu.cmu.sphinx.decoder.scorer.ScoreProvider;
import edu.cmu.sphinx.frontend.Data;
import edu.cmu.sphinx.linguist.HMMSearchState;
import edu.cmu.sphinx.linguist.Linguist;
import edu.cmu.sphinx.linguist.SearchGraph;
import edu.cmu.sphinx.linguist.SearchState;
import edu.cmu.sphinx.linguist.SearchStateArc;
import edu.cmu.sphinx.linguist.UnitSearchState;
import edu.cmu.sphinx.linguist.WordSearchState;
import edu.cmu.sphinx.linguist.WordSequence;
import edu.cmu.sphinx.linguist.acoustic.AcousticModel;
import edu.cmu.sphinx.linguist.acoustic.HMM;
import edu.cmu.sphinx.linguist.acoustic.HMMPool;
import edu.cmu.sphinx.linguist.acoustic.HMMPosition;
import edu.cmu.sphinx.linguist.acoustic.HMMState;
import edu.cmu.sphinx.linguist.acoustic.HMMStateArc;
import edu.cmu.sphinx.linguist.acoustic.Unit;
import edu.cmu.sphinx.linguist.acoustic.UnitManager;
import edu.cmu.sphinx.linguist.aflat.PhoneLoop;
import edu.cmu.sphinx.linguist.dictionary.Pronunciation;
import edu.cmu.sphinx.linguist.dictionary.Word;
import edu.cmu.sphinx.linguist.language.grammar.Grammar;
import edu.cmu.sphinx.linguist.language.grammar.GrammarArc;
import edu.cmu.sphinx.linguist.language.grammar.GrammarNode;
import edu.cmu.sphinx.util.LogMath;
import edu.cmu.sphinx.util.Timer;
import edu.cmu.sphinx.util.TimerPool;
import edu.cmu.sphinx.util.props.Configurable;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.S4Boolean;
import edu.cmu.sphinx.util.props.S4Component;
import edu.cmu.sphinx.util.props.S4Double;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

public class AFlatLinguist
implements Linguist,
Configurable {
    @S4Component(type=Grammar.class)
    public static final String GRAMMAR = "grammar";
    @S4Component(type=UnitManager.class)
    public static final String UNIT_MANAGER = "unitManager";
    @S4Component(type=AcousticModel.class)
    public static final String ACOUSTIC_MODEL = "acousticModel";
    @S4Boolean(defaultValue=false)
    public static final String ADD_OUT_OF_GRAMMAR_BRANCH = "addOutOfGrammarBranch";
    @S4Double(defaultValue=1.0)
    public static final String OUT_OF_GRAMMAR_PROBABILITY = "outOfGrammarProbability";
    @S4Double(defaultValue=1.0)
    public static final String PHONE_INSERTION_PROBABILITY = "phoneInsertionProbability";
    @S4Component(type=AcousticModel.class)
    public static final String PHONE_LOOP_ACOUSTIC_MODEL = "phoneLoopAcousticModel";
    private Grammar grammar;
    private AcousticModel acousticModel;
    private AcousticModel phoneLoopAcousticModel;
    private UnitManager unitManager;
    private float logWordInsertionProbability;
    private float logSilenceInsertionProbability;
    private float logUnitInsertionProbability;
    private float logFillerInsertionProbability;
    private float languageWeight;
    private float logOutOfGrammarBranchProbability;
    private float logPhoneInsertionProbability;
    private boolean addOutOfGrammarBranch;
    private SearchGraph searchGraph;
    private Logger logger;
    private HMMPool hmmPool;
    SearchStateArc outOfGrammarGraph;
    public Runtime runtime = Runtime.getRuntime();
    private long counterForMemoryLogging = 0L;
    private Map<GrammarNode, int[]> nodeToNextUnitArrayMap;
    private Map<GrammarNode, Set<Unit>> nodeToUnitSetMap;
    private final SearchStateArc[] EMPTY_ARCS = new SearchStateArc[0];
    final Map<SearchState, SearchStateArc[]> successorCache = new HashMap<SearchState, SearchStateArc[]>();

    public AFlatLinguist(AcousticModel acousticModel, Grammar grammar, UnitManager unitManager, double wordInsertionProbability, double silenceInsertionProbability, double unitInsertionProbability, double fillerInsertionProbability, float languageWeight, boolean addOutOfGrammarBranch, double outOfGrammarBranchProbability, double phoneInsertionProbability, AcousticModel phoneLoopAcousticModel) {
        this.logger = Logger.getLogger(this.getClass().getName());
        this.acousticModel = acousticModel;
        this.grammar = grammar;
        this.unitManager = unitManager;
        LogMath logMath = LogMath.getLogMath();
        this.logWordInsertionProbability = logMath.linearToLog(wordInsertionProbability);
        this.logSilenceInsertionProbability = logMath.linearToLog(silenceInsertionProbability);
        this.logUnitInsertionProbability = logMath.linearToLog(unitInsertionProbability);
        this.logFillerInsertionProbability = logMath.linearToLog(fillerInsertionProbability);
        this.languageWeight = languageWeight;
        this.addOutOfGrammarBranch = addOutOfGrammarBranch;
        this.logOutOfGrammarBranchProbability = logMath.linearToLog(outOfGrammarBranchProbability);
        this.logPhoneInsertionProbability = logMath.linearToLog(this.logPhoneInsertionProbability);
        if (addOutOfGrammarBranch) {
            this.phoneLoopAcousticModel = phoneLoopAcousticModel;
        }
    }

    public AFlatLinguist() {
    }

    @Override
    public void newProperties(PropertySheet ps) throws PropertyException {
        this.logger = ps.getLogger();
        this.acousticModel = (AcousticModel)ps.getComponent(ACOUSTIC_MODEL);
        this.grammar = (Grammar)ps.getComponent(GRAMMAR);
        this.unitManager = (UnitManager)ps.getComponent(UNIT_MANAGER);
        LogMath logMath = LogMath.getLogMath();
        this.logWordInsertionProbability = logMath.linearToLog(ps.getDouble("wordInsertionProbability"));
        this.logSilenceInsertionProbability = logMath.linearToLog(ps.getDouble("silenceInsertionProbability"));
        this.logUnitInsertionProbability = logMath.linearToLog(ps.getDouble("unitInsertionProbability"));
        this.logFillerInsertionProbability = logMath.linearToLog(ps.getDouble("fillerInsertionProbability"));
        this.languageWeight = ps.getFloat("languageWeight");
        this.addOutOfGrammarBranch = ps.getBoolean(ADD_OUT_OF_GRAMMAR_BRANCH);
        this.logOutOfGrammarBranchProbability = logMath.linearToLog(ps.getDouble(OUT_OF_GRAMMAR_PROBABILITY));
        this.logPhoneInsertionProbability = logMath.linearToLog(ps.getDouble(PHONE_INSERTION_PROBABILITY));
        if (this.addOutOfGrammarBranch) {
            this.phoneLoopAcousticModel = (AcousticModel)ps.getComponent(PHONE_LOOP_ACOUSTIC_MODEL);
        }
    }

    @Override
    public SearchGraph getSearchGraph() {
        this.logger.info("Generated Search Graph");
        this.logger.info("Total Memory= " + this.runtime.totalMemory() / 0x100000L + " MB");
        this.logger.info("Free Memory = " + this.runtime.freeMemory() / 0x100000L + " MB");
        return this.searchGraph;
    }

    protected void setupAcousticModel(PropertySheet ps) throws PropertyException {
        this.acousticModel = (AcousticModel)ps.getComponent(ACOUSTIC_MODEL);
    }

    @Override
    public void allocate() throws IOException {
        this.logger.info("Allocating DFLAT");
        this.allocateAcousticModel();
        this.grammar.allocate();
        this.hmmPool = new HMMPool(this.acousticModel, this.logger, this.unitManager);
        this.nodeToNextUnitArrayMap = new HashMap<GrammarNode, int[]>();
        this.nodeToUnitSetMap = new HashMap<GrammarNode, Set<Unit>>();
        Timer timer = TimerPool.getTimer(this, "compileGrammar");
        timer.start();
        this.compileGrammar();
        timer.stop();
        this.logger.info("Done allocating  DFLAT");
    }

    protected void allocateAcousticModel() throws IOException {
        this.acousticModel.allocate();
        if (this.addOutOfGrammarBranch) {
            this.phoneLoopAcousticModel.allocate();
        }
    }

    @Override
    public void deallocate() {
        if (this.acousticModel != null) {
            this.acousticModel.deallocate();
        }
        this.grammar.deallocate();
    }

    public float getLogSilenceInsertionProbability() {
        return this.logSilenceInsertionProbability;
    }

    private void compileGrammar() {
        this.logger.info("Compiling Grammar");
        Set<GrammarNode> nodeSet = this.grammar.getGrammarNodes();
        for (GrammarNode node : nodeSet) {
            this.initUnitMaps(node);
        }
        this.logger.info("Free Memory before generating Search Graph= " + this.runtime.freeMemory() / 0x100000L + " MB");
        this.searchGraph = new DynamicFlatSearchGraph();
    }

    private void initUnitMaps(GrammarNode node) {
        HashSet<Unit> unitSet;
        HashSet<GrammarNode> vistedNodes;
        if (this.nodeToNextUnitArrayMap.get(node) == null) {
            vistedNodes = new HashSet<GrammarNode>();
            unitSet = new HashSet<Unit>();
            GrammarArc[] arcs = node.getSuccessors();
            GrammarArc[] grammarArcArray = arcs;
            int n = arcs.length;
            int n2 = 0;
            while (n2 < n) {
                GrammarArc arc = grammarArcArray[n2];
                GrammarNode nextNode = arc.getGrammarNode();
                this.collectNextUnits(nextNode, vistedNodes, unitSet);
                ++n2;
            }
            int[] nextUnits = new int[unitSet.size()];
            int index = 0;
            for (Unit unit : unitSet) {
                nextUnits[index++] = unit.getBaseID();
            }
            this.nodeToNextUnitArrayMap.put(node, nextUnits);
        }
        if (this.nodeToUnitSetMap.get(node) == null) {
            vistedNodes = new HashSet();
            unitSet = new HashSet();
            this.collectNextUnits(node, vistedNodes, unitSet);
            this.nodeToUnitSetMap.put(node, unitSet);
        }
    }

    private void collectNextUnits(GrammarNode thisNode, Set<GrammarNode> vistedNodes, Set<Unit> unitSet) {
        if (vistedNodes.contains(thisNode)) {
            return;
        }
        vistedNodes.add(thisNode);
        if (thisNode.isFinalNode()) {
            unitSet.add(UnitManager.SILENCE);
        } else if (!thisNode.isEmpty()) {
            Pronunciation[] pronunciations;
            Word word = thisNode.getWord();
            Pronunciation[] pronunciationArray = pronunciations = word.getPronunciations();
            int n = pronunciations.length;
            int n2 = 0;
            while (n2 < n) {
                Pronunciation pronunciation = pronunciationArray[n2];
                unitSet.add(pronunciation.getUnits()[0]);
                ++n2;
            }
        } else {
            GrammarArc[] arcs;
            GrammarArc[] grammarArcArray = arcs = thisNode.getSuccessors();
            int n = arcs.length;
            int n3 = 0;
            while (n3 < n) {
                GrammarArc arc = grammarArcArray[n3];
                GrammarNode nextNode = arc.getGrammarNode();
                this.collectNextUnits(nextNode, vistedNodes, unitSet);
                ++n3;
            }
        }
    }

    @Override
    public void startRecognition() {
    }

    @Override
    public void stopRecognition() {
    }

    class DynamicFlatSearchGraph
    implements SearchGraph {
        DynamicFlatSearchGraph() {
        }

        @Override
        public SearchState getInitialState() {
            InitialState initialState = new InitialState();
            initialState.addArc(new GrammarState(AFlatLinguist.this.grammar.getInitialNode()));
            return initialState;
        }

        @Override
        public int getNumStateOrder() {
            return 5;
        }

        @Override
        public boolean getWordTokenFirst() {
            return true;
        }
    }

    abstract class FlatSearchState
    implements SearchState,
    SearchStateArc {
        static final int ANY = 0;

        FlatSearchState() {
        }

        @Override
        public abstract SearchStateArc[] getSuccessors();

        @Override
        public abstract String getSignature();

        @Override
        public abstract int getOrder();

        @Override
        public boolean isEmitting() {
            return false;
        }

        @Override
        public boolean isFinal() {
            return false;
        }

        @Override
        public Object getLexState() {
            return null;
        }

        @Override
        public String toPrettyString() {
            return this.toString();
        }

        public String toString() {
            return this.getSignature();
        }

        @Override
        public WordSequence getWordHistory() {
            return null;
        }

        @Override
        public SearchState getState() {
            return this;
        }

        @Override
        public float getProbability() {
            return this.getLanguageProbability() + this.getInsertionProbability();
        }

        @Override
        public float getLanguageProbability() {
            return 0.0f;
        }

        @Override
        public float getInsertionProbability() {
            return 0.0f;
        }

        SearchStateArc[] getCachedSuccessors() {
            return AFlatLinguist.this.successorCache.get(this);
        }

        void cacheSuccessors(SearchStateArc[] successors) {
            AFlatLinguist.this.successorCache.put(this, successors);
        }
    }

    class FullHMMSearchState
    extends FlatSearchState
    implements UnitSearchState {
        private final PronunciationState pState;
        private final int index;
        private final int lc;
        private final int rc;
        private final HMM hmm;
        private final boolean isLastUnitOfWord;

        FullHMMSearchState(PronunciationState p, int which, int lc) {
            this(p, which, lc, p.getPronunciation().getUnits()[which + 1].getBaseID());
        }

        FullHMMSearchState(PronunciationState p, int which, int lc, int rc) {
            this.pState = p;
            this.index = which;
            this.lc = lc;
            this.rc = rc;
            int base = p.getPronunciation().getUnits()[which].getBaseID();
            int id = AFlatLinguist.this.hmmPool.buildID(base, lc, rc);
            this.hmm = AFlatLinguist.this.hmmPool.getHMM(id, this.getPosition());
            this.isLastUnitOfWord = which == p.getPronunciation().getUnits().length - 1;
        }

        @Override
        public float getInsertionProbability() {
            Unit unit = this.hmm.getBaseUnit();
            if (unit.isSilence()) {
                return AFlatLinguist.this.logSilenceInsertionProbability;
            }
            if (unit.isFiller()) {
                return AFlatLinguist.this.logFillerInsertionProbability;
            }
            return AFlatLinguist.this.logUnitInsertionProbability;
        }

        @Override
        public String toString() {
            return this.hmm.getUnit().toString();
        }

        public int hashCode() {
            return this.pState.getGrammarState().getGrammarNode().hashCode() * 29 + this.pState.getPronunciation().hashCode() * 19 + this.index * 7 + 43 * this.lc + this.rc;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof FullHMMSearchState) {
                FullHMMSearchState other = (FullHMMSearchState)o;
                return this.pState.getGrammarState().getGrammarNode() == other.pState.getGrammarState().getGrammarNode() && this.pState.getPronunciation() == other.pState.getPronunciation() && this.index == other.index && this.lc == other.lc && this.rc == other.rc;
            }
            return false;
        }

        @Override
        public Unit getUnit() {
            return this.hmm.getBaseUnit();
        }

        @Override
        public SearchStateArc[] getSuccessors() {
            SearchStateArc[] arcs = this.getCachedSuccessors();
            if (arcs == null) {
                arcs = new SearchStateArc[]{new HMMStateSearchState(this, this.hmm.getInitialState())};
                this.cacheSuccessors(arcs);
            }
            return arcs;
        }

        boolean isLastUnitOfWord() {
            return this.isLastUnitOfWord;
        }

        HMMPosition getPosition() {
            int len = this.pState.getPronunciation().getUnits().length;
            if (len == 1) {
                return HMMPosition.SINGLE;
            }
            if (this.index == 0) {
                return HMMPosition.BEGIN;
            }
            if (this.index == len - 1) {
                return HMMPosition.END;
            }
            return HMMPosition.INTERNAL;
        }

        HMM getHMM() {
            return this.hmm;
        }

        @Override
        public int getOrder() {
            return 3;
        }

        @Override
        public String getSignature() {
            return "HSS " + this.pState.getGrammarState().getGrammarNode() + this.pState.getPronunciation() + this.index + '-' + this.rc + '-' + this.lc;
        }

        int getRC() {
            return this.rc;
        }

        SearchStateArc[] getNextArcs() {
            SearchStateArc[] arcs;
            int nextLC = this.getHMM().getBaseUnit().getBaseID();
            if (!this.isLastUnitOfWord()) {
                arcs = this.pState.getSuccessors(nextLC, this.index + 1);
            } else {
                GrammarState gs = this.pState.getGrammarState();
                arcs = gs.getNextGrammarStates(nextLC, this.getRC());
            }
            return arcs;
        }
    }

    public class GrammarState
    extends FlatSearchState {
        private final GrammarNode node;
        private final int lc;
        private final int nextBaseID;
        private final float languageProbability;

        GrammarState(GrammarNode node) {
            this(node, 0.0f, UnitManager.SILENCE.getBaseID());
        }

        GrammarState(GrammarNode node, float languageProbability, int lc) {
            this(node, languageProbability, lc, 0);
        }

        GrammarState(GrammarNode node, float languageProbability, int lc, int nextBaseID) {
            this.lc = lc;
            this.nextBaseID = nextBaseID;
            this.node = node;
            this.languageProbability = languageProbability;
        }

        @Override
        public float getLanguageProbability() {
            return this.languageProbability * AFlatLinguist.this.languageWeight;
        }

        public int hashCode() {
            return this.node.hashCode() * 17 + this.lc * 7 + this.nextBaseID;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof GrammarState) {
                GrammarState other = (GrammarState)o;
                return other.node == this.node && this.lc == other.lc && this.nextBaseID == other.nextBaseID;
            }
            return false;
        }

        @Override
        public boolean isFinal() {
            return this.node.isFinalNode();
        }

        @Override
        public SearchStateArc[] getSuccessors() {
            SearchStateArc[] arcs;
            AFlatLinguist aFlatLinguist = AFlatLinguist.this;
            aFlatLinguist.counterForMemoryLogging = aFlatLinguist.counterForMemoryLogging + 1L;
            if (AFlatLinguist.this.counterForMemoryLogging % 500000L == 0L) {
                AFlatLinguist.this.logger.info("Free Memory= " + AFlatLinguist.this.runtime.freeMemory() / 0x100000L + " MB" + "\tMax Memory= " + AFlatLinguist.this.runtime.maxMemory() / 0x100000L + "MB");
            }
            if ((arcs = this.getCachedSuccessors()) == null) {
                if (this.isFinal()) {
                    arcs = AFlatLinguist.this.EMPTY_ARCS;
                } else if (this.node.isEmpty()) {
                    arcs = this.getNextGrammarStates(this.lc, this.nextBaseID);
                } else {
                    Word word = this.node.getWord();
                    Pronunciation[] pronunciations = word.getPronunciations();
                    pronunciations = this.filter(pronunciations, this.nextBaseID);
                    SearchStateArc[] nextArcs = AFlatLinguist.this.addOutOfGrammarBranch ? new SearchStateArc[pronunciations.length + 1] : new SearchStateArc[pronunciations.length];
                    int i = 0;
                    while (i < pronunciations.length) {
                        nextArcs[i] = new PronunciationState(this, pronunciations[i]);
                        ++i;
                    }
                    SearchStateArc[] returnState = new SearchStateArc[]{this};
                    if (AFlatLinguist.this.addOutOfGrammarBranch) {
                        PhoneLoop pl = new PhoneLoop(AFlatLinguist.this.acousticModel, AFlatLinguist.this.logOutOfGrammarBranchProbability, AFlatLinguist.this.logPhoneInsertionProbability, returnState);
                        nextArcs[pronunciations.length] = pl.getPhoneLoop();
                    }
                    arcs = nextArcs;
                }
                this.cacheSuccessors(arcs);
            }
            return arcs;
        }

        SearchStateArc[] getNextGrammarStates(int lc, int nextBaseID) {
            GrammarArc[] nextNodes = this.node.getSuccessors();
            nextNodes = this.filter(nextNodes, nextBaseID);
            SearchStateArc[] nextArcs = new SearchStateArc[nextNodes.length];
            int i = 0;
            while (i < nextNodes.length) {
                GrammarArc arc = nextNodes[i];
                nextArcs[i] = new GrammarState(arc.getGrammarNode(), arc.getProbability(), lc, nextBaseID);
                ++i;
            }
            return nextArcs;
        }

        @Override
        public String getSignature() {
            return "GS " + this.node + "-lc-" + AFlatLinguist.this.hmmPool.getUnit(this.lc) + "-rc-" + AFlatLinguist.this.hmmPool.getUnit(this.nextBaseID);
        }

        @Override
        public int getOrder() {
            return 1;
        }

        GrammarArc[] filter(GrammarArc[] arcs, int nextBase) {
            if (nextBase != 0) {
                ArrayList<GrammarArc> list = new ArrayList<GrammarArc>();
                GrammarArc[] grammarArcArray = arcs;
                int n = arcs.length;
                int n2 = 0;
                while (n2 < n) {
                    GrammarArc arc = grammarArcArray[n2];
                    GrammarNode node = arc.getGrammarNode();
                    if (this.hasEntryContext(node, nextBase)) {
                        list.add(arc);
                    }
                    ++n2;
                }
                arcs = list.toArray(new GrammarArc[list.size()]);
            }
            return arcs;
        }

        private boolean hasEntryContext(GrammarNode node, int unitID) {
            Set unitSet = (Set)AFlatLinguist.this.nodeToUnitSetMap.get(node);
            return unitSet.contains(AFlatLinguist.this.hmmPool.getUnit(unitID));
        }

        Pronunciation[] filter(Pronunciation[] p, int nextBase) {
            return p;
        }

        int getLC() {
            return this.lc;
        }

        int getNextBaseID() {
            return this.nextBaseID;
        }

        int[] getNextUnits() {
            return (int[])AFlatLinguist.this.nodeToNextUnitArrayMap.get(this.node);
        }

        @Override
        public String toString() {
            return this.node + "[" + AFlatLinguist.this.hmmPool.getUnit(this.lc) + ',' + AFlatLinguist.this.hmmPool.getUnit(this.nextBaseID) + ']';
        }

        GrammarNode getGrammarNode() {
            return this.node;
        }
    }

    class HMMStateSearchState
    extends FlatSearchState
    implements HMMSearchState,
    ScoreProvider {
        private final FullHMMSearchState fullHMMSearchState;
        private final HMMState hmmState;
        private final float probability;

        HMMStateSearchState(FullHMMSearchState hss, HMMState hmmState) {
            this(hss, hmmState, 0.0f);
        }

        HMMStateSearchState(FullHMMSearchState hss, HMMState hmmState, float prob) {
            this.probability = prob;
            this.fullHMMSearchState = hss;
            this.hmmState = hmmState;
        }

        @Override
        public float getInsertionProbability() {
            return this.probability;
        }

        public int hashCode() {
            return 7 * this.fullHMMSearchState.hashCode() + this.hmmState.hashCode();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof HMMStateSearchState) {
                HMMStateSearchState other = (HMMStateSearchState)o;
                return other.fullHMMSearchState.equals(this.fullHMMSearchState) && other.hmmState.equals(this.hmmState);
            }
            return false;
        }

        @Override
        public boolean isEmitting() {
            return this.hmmState.isEmitting();
        }

        @Override
        public SearchStateArc[] getSuccessors() {
            SearchStateArc[] arcs = this.getCachedSuccessors();
            if (arcs == null) {
                if (this.hmmState.isExitState()) {
                    arcs = this.fullHMMSearchState.getNextArcs();
                } else {
                    HMMStateArc[] next = this.hmmState.getSuccessors();
                    arcs = new SearchStateArc[next.length];
                    int i = 0;
                    while (i < arcs.length) {
                        arcs[i] = new HMMStateSearchState(this.fullHMMSearchState, next[i].getHMMState(), next[i].getLogProbability());
                        ++i;
                    }
                }
                this.cacheSuccessors(arcs);
            }
            return arcs;
        }

        @Override
        public int getOrder() {
            return this.isEmitting() ? 4 : 0;
        }

        @Override
        public String getSignature() {
            return "HSSS " + this.fullHMMSearchState.getSignature() + '-' + this.hmmState;
        }

        @Override
        public HMMState getHMMState() {
            return this.hmmState;
        }

        @Override
        public float getScore(Data data) {
            return this.hmmState.getScore(data);
        }

        @Override
        public float[] getComponentScore(Data data) {
            return this.hmmState.calculateComponentScore(data);
        }
    }

    class InitialState
    extends FlatSearchState {
        private final List<SearchStateArc> nextArcs = new ArrayList<SearchStateArc>();

        InitialState() {
        }

        @Override
        public SearchStateArc[] getSuccessors() {
            return this.nextArcs.toArray(new SearchStateArc[this.nextArcs.size()]);
        }

        public void addArc(SearchStateArc arc) {
            this.nextArcs.add(arc);
        }

        @Override
        public String getSignature() {
            return "initialState";
        }

        @Override
        public int getOrder() {
            return 1;
        }

        @Override
        public String toString() {
            return this.getSignature();
        }
    }

    class PronunciationState
    extends FlatSearchState
    implements WordSearchState {
        private final GrammarState gs;
        private final Pronunciation pronunciation;

        PronunciationState(GrammarState gs, Pronunciation p) {
            this.gs = gs;
            this.pronunciation = p;
        }

        @Override
        public float getInsertionProbability() {
            if (this.pronunciation.getWord().isFiller()) {
                return 0.0f;
            }
            return AFlatLinguist.this.logWordInsertionProbability;
        }

        public int hashCode() {
            return 13 * this.gs.hashCode() + this.pronunciation.hashCode();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof PronunciationState) {
                PronunciationState other = (PronunciationState)o;
                return other.gs.equals(this.gs) && other.pronunciation.equals(this.pronunciation);
            }
            return false;
        }

        @Override
        public SearchStateArc[] getSuccessors() {
            SearchStateArc[] arcs = this.getCachedSuccessors();
            if (arcs == null) {
                arcs = this.getSuccessors(this.gs.getLC(), 0);
                this.cacheSuccessors(arcs);
            }
            return arcs;
        }

        SearchStateArc[] getSuccessors(int lc, int index) {
            SearchStateArc[] arcs;
            if (index == this.pronunciation.getUnits().length - 1) {
                if (this.isContextIndependentUnit(this.pronunciation.getUnits()[index])) {
                    arcs = new SearchStateArc[]{new FullHMMSearchState(this, index, lc, 0)};
                } else {
                    int[] nextUnits = this.gs.getNextUnits();
                    arcs = new SearchStateArc[nextUnits.length];
                    int i = 0;
                    while (i < arcs.length) {
                        arcs[i] = new FullHMMSearchState(this, index, lc, nextUnits[i]);
                        ++i;
                    }
                }
            } else {
                arcs = new SearchStateArc[]{new FullHMMSearchState(this, index, lc)};
            }
            return arcs;
        }

        @Override
        public Pronunciation getPronunciation() {
            return this.pronunciation;
        }

        private boolean isContextIndependentUnit(Unit unit) {
            return unit.isFiller();
        }

        @Override
        public String getSignature() {
            return "PS " + this.gs.getSignature() + '-' + this.pronunciation;
        }

        @Override
        public String toString() {
            return this.pronunciation.getWord().getSpelling();
        }

        @Override
        public int getOrder() {
            return 2;
        }

        GrammarState getGrammarState() {
            return this.gs;
        }

        @Override
        public boolean isWordStart() {
            return true;
        }
    }
}

