/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.linguist.acoustic.trivial;

import edu.cmu.sphinx.linguist.acoustic.HMM;
import edu.cmu.sphinx.linguist.acoustic.HMMPosition;
import edu.cmu.sphinx.linguist.acoustic.HMMState;
import edu.cmu.sphinx.linguist.acoustic.Unit;
import edu.cmu.sphinx.linguist.acoustic.trivial.TrivialHMMState;

class TrivialHMM
implements HMM {
    private static final int NUM_STATES = 4;
    final Unit unit;
    final HMMPosition position;
    final HMMState[] hmmStates;
    private final Unit baseUnit;

    TrivialHMM(Unit unit, HMMPosition position) {
        this.unit = unit;
        this.position = position;
        this.hmmStates = new HMMState[4];
        this.baseUnit = unit.getBaseUnit();
        int i = 0;
        while (i < this.hmmStates.length) {
            boolean finalState = i == this.hmmStates.length - 1;
            this.hmmStates[i] = new TrivialHMMState(this, i, finalState);
            ++i;
        }
    }

    @Override
    public Unit getUnit() {
        return this.unit;
    }

    @Override
    public Unit getBaseUnit() {
        return this.baseUnit;
    }

    @Override
    public HMMState getState(int which) {
        return this.hmmStates[which];
    }

    @Override
    public int getOrder() {
        return this.hmmStates.length;
    }

    @Override
    public HMMPosition getPosition() {
        return this.position;
    }

    @Override
    public HMMState getInitialState() {
        return this.hmmStates[0];
    }
}

