/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.linguist.acoustic.trivial;

import edu.cmu.sphinx.linguist.acoustic.AcousticModel;
import edu.cmu.sphinx.linguist.acoustic.HMM;
import edu.cmu.sphinx.linguist.acoustic.HMMPosition;
import edu.cmu.sphinx.linguist.acoustic.Unit;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.S4Integer;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

public class TrivialAcousticModel
implements AcousticModel {
    @S4Integer(defaultValue=1)
    public static final String LEFT_CONTEXT_SIZE = "leftContextSize";
    @S4Integer(defaultValue=1)
    public static final String RIGHT_CONTEXT_SIZE = "leftContextSize";
    private String name;
    private final Map<Unit, HMM> hmmMap = new HashMap<Unit, HMM>();
    private int leftContextSize;
    private int rightContextSize;

    public TrivialAcousticModel(int leftContextSize, int rightContextSize) {
        this.init(leftContextSize, rightContextSize);
    }

    public TrivialAcousticModel() {
    }

    @Override
    public void newProperties(PropertySheet ps) throws PropertyException {
        this.init(ps.getInt("leftContextSize"), ps.getInt("leftContextSize"));
    }

    private void init(int leftContextSize, int rightContextSize) {
        String[] unitNames;
        this.leftContextSize = leftContextSize;
        this.rightContextSize = rightContextSize;
        String[] stringArray = unitNames = new String[]{"AX_one", "AY_five", "AY_nine", "EH_seven", "EY_eight", "E_seven", "F_five", "F_four", "II_three", "II_zero", "I_six", "K_six", "N_nine", "N_nine_2", "N_one", "N_seven", "OO_two", "OW_four", "OW_oh", "OW_zero", "R_four", "R_three", "R_zero", "S_seven", "S_six", "S_six_2", "TH_three", "T_eight", "T_two", "V_five", "V_seven", "W_one", "Z_zero", "AX_one", "SIL"};
        int n = unitNames.length;
        int n2 = 0;
        while (n2 < n) {
            String unitName = stringArray[n2];
            this.createTrivialHMM(unitName);
            ++n2;
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Properties getProperties() {
        return new Properties();
    }

    @Override
    public HMM lookupNearestHMM(Unit unit, HMMPosition position, boolean exactMatch) {
        HMM hmm = null;
        if (!exactMatch || position == HMMPosition.UNDEFINED) {
            unit = unit.getBaseUnit();
            hmm = this.hmmMap.get(unit);
        }
        return hmm;
    }

    @Override
    public Iterator<HMM> getHMMIterator() {
        return this.hmmMap.values().iterator();
    }

    @Override
    public Iterator<Unit> getContextIndependentUnitIterator() {
        return this.hmmMap.keySet().iterator();
    }

    @Override
    public int getLeftContextSize() {
        return this.leftContextSize;
    }

    @Override
    public int getRightContextSize() {
        return this.rightContextSize;
    }

    private void createTrivialHMM(String unitName) {
    }

    @Override
    public void allocate() throws IOException {
    }

    @Override
    public void deallocate() {
    }
}

