/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.linguist.acoustic.tiedstate.trainer;

import edu.cmu.sphinx.linguist.acoustic.HMM;
import edu.cmu.sphinx.linguist.acoustic.LeftRightContext;
import edu.cmu.sphinx.linguist.acoustic.Unit;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.GaussianWeights;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.HMMManager;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.Loader;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.Pool;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.Saver;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.Senone;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.SenoneHMM;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.SenoneSequence;
import edu.cmu.sphinx.util.LogMath;
import edu.cmu.sphinx.util.StreamFactory;
import edu.cmu.sphinx.util.Utilities;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.S4Boolean;
import edu.cmu.sphinx.util.props.S4Component;
import edu.cmu.sphinx.util.props.S4Double;
import edu.cmu.sphinx.util.props.S4Integer;
import edu.cmu.sphinx.util.props.S4String;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Sphinx3Saver
implements Saver {
    @S4Boolean(defaultValue=true)
    public static final String PROP_SPARSE_FORM = "sparseForm";
    protected boolean sparseForm;
    @S4Boolean(defaultValue=true)
    public static final String PROP_USE_CD_UNITS = "useCDUnits";
    @S4Double(defaultValue=0.0)
    public static final String PROP_MC_FLOOR = "MixtureComponentScoreFloor";
    @S4Component(type=Loader.class)
    public static final String LOADER = "loader";
    @S4Integer(defaultValue=39)
    public static final String PROP_VECTOR_LENGTH = "vectorLength";
    protected Logger logger;
    protected static final String FILLER = "filler";
    protected static final String SILENCE_CIPHONE = "SIL";
    protected static final int BYTE_ORDER_MAGIC = 287454020;
    public static final String MODEL_VERSION = "0.3";
    protected static final int CONTEXT_SIZE = 1;
    private String checksum;
    private boolean doCheckSum;
    private Pool<float[]> meansPool;
    private Pool<float[]> variancePool;
    private Pool<float[][]> matrixPool;
    private Pool<float[][]> meanTransformationMatrixPool;
    private Pool<float[]> meanTransformationVectorPool;
    private Pool<float[][]> varianceTransformationMatrixPool;
    private Pool<float[]> varianceTransformationVectorPool;
    private GaussianWeights mixtureWeights;
    private Pool<Senone> senonePool;
    private int vectorLength;
    private Map<String, Unit> contextIndependentUnits;
    private HMMManager hmmManager;
    protected LogMath logMath;
    private boolean binary;
    private String location;
    private boolean swap;
    protected static final String DENSITY_FILE_VERSION = "1.0";
    protected static final String MIXW_FILE_VERSION = "1.0";
    protected static final String TMAT_FILE_VERSION = "1.0";
    @S4String(defaultValue=".")
    public static final String SAVE_LOCATION = "saveLocation";
    @S4String(mandatory=false, defaultValue="")
    public static final String DATA_LOCATION = "dataLocation";
    private String dataDir;
    @S4String(mandatory=false, defaultValue="")
    public static final String DEF_FILE = "definitionFile";
    public boolean useCDUnits;

    @Override
    public void newProperties(PropertySheet ps) throws PropertyException {
        this.logger = ps.getLogger();
        this.location = ps.getString(SAVE_LOCATION);
        this.dataDir = ps.getString(DATA_LOCATION);
        this.sparseForm = ps.getBoolean(PROP_SPARSE_FORM);
        this.useCDUnits = ps.getBoolean(PROP_USE_CD_UNITS);
        this.logMath = LogMath.getLogMath();
        this.vectorLength = ps.getInt(PROP_VECTOR_LENGTH);
        Loader loader = (Loader)ps.getComponent(LOADER);
        this.hmmManager = loader.getHMMManager();
        this.meansPool = loader.getMeansPool();
        this.variancePool = loader.getVariancePool();
        this.mixtureWeights = loader.getMixtureWeights();
        this.matrixPool = loader.getTransitionMatrixPool();
        this.senonePool = loader.getSenonePool();
        this.contextIndependentUnits = new LinkedHashMap<String, Unit>();
        this.checksum = "no";
        this.doCheckSum = this.checksum != null && this.checksum.equals("yes");
        this.swap = false;
    }

    protected String getCheckSum() {
        return this.checksum;
    }

    protected boolean getDoCheckSum() {
        return this.doCheckSum;
    }

    protected String getLocation() {
        return this.location;
    }

    @Override
    public void save(String modelName, boolean b) throws IOException {
        this.logger.info("Saving acoustic model: " + modelName);
        this.logger.info("    Path      : " + this.location);
        this.logger.info("    modellName: " + modelName);
        this.logger.info("    dataDir   : " + this.dataDir);
        if (this.binary) {
            this.saveDensityFileBinary(this.meansPool, String.valueOf(this.dataDir) + "means", true);
            this.saveDensityFileBinary(this.variancePool, String.valueOf(this.dataDir) + "variances", true);
            this.saveMixtureWeightsBinary(this.mixtureWeights, String.valueOf(this.dataDir) + "mixture_weights", true);
            this.saveTransitionMatricesBinary(this.matrixPool, String.valueOf(this.dataDir) + "transition_matrices", true);
        } else {
            this.saveDensityFileAscii(this.meansPool, String.valueOf(this.dataDir) + "means.ascii", true);
            this.saveDensityFileAscii(this.variancePool, String.valueOf(this.dataDir) + "variances.ascii", true);
            this.saveMixtureWeightsAscii(this.mixtureWeights, String.valueOf(this.dataDir) + "mixture_weights.ascii", true);
            this.saveTransitionMatricesAscii(this.matrixPool, String.valueOf(this.dataDir) + "transition_matrices.ascii", true);
        }
        this.saveHMMPool(this.useCDUnits, StreamFactory.getOutputStream(this.location, "mdef", true), String.valueOf(this.location) + File.separator + "mdef");
    }

    @Override
    public Map<String, Unit> getContextIndependentUnits() {
        return this.contextIndependentUnits;
    }

    private void saveDensityFileAscii(Pool<float[]> pool, String path, boolean append) throws FileNotFoundException, IOException {
        this.logger.info("Saving density file to: ");
        this.logger.info(path);
        OutputStream outputStream = StreamFactory.getOutputStream(this.location, path, append);
        if (outputStream == null) {
            throw new IOException("Error trying to write file " + this.location + path);
        }
        PrintWriter pw = new PrintWriter(outputStream, true);
        pw.print("param ");
        int numStates = pool.getFeature(Pool.Feature.NUM_SENONES, -1);
        pw.print(String.valueOf(numStates) + " ");
        int numStreams = pool.getFeature(Pool.Feature.NUM_STREAMS, -1);
        pw.print(String.valueOf(numStreams) + " ");
        int numGaussiansPerState = pool.getFeature(Pool.Feature.NUM_GAUSSIANS_PER_STATE, -1);
        pw.println(numGaussiansPerState);
        int i = 0;
        while (i < numStates) {
            pw.println("mgau " + i);
            pw.println("feat 0");
            int j = 0;
            while (j < numGaussiansPerState) {
                pw.print("density \t" + j);
                int id = i * numGaussiansPerState + j;
                float[] density = pool.get(id);
                int k = 0;
                while (k < this.vectorLength) {
                    pw.print(" " + density[k]);
                    ++k;
                }
                pw.println();
                ++j;
            }
            ++i;
        }
        outputStream.close();
    }

    private void saveDensityFileBinary(Pool<float[]> pool, String path, boolean append) throws FileNotFoundException, IOException {
        Properties props = new Properties();
        int checkSum = 0;
        this.logger.info("Saving density file to: ");
        this.logger.info(path);
        props.setProperty("version", "1.0");
        props.setProperty("chksum0", this.checksum);
        DataOutputStream dos = this.writeS3BinaryHeader(this.location, path, props, append);
        int numStates = pool.getFeature(Pool.Feature.NUM_SENONES, -1);
        int numStreams = pool.getFeature(Pool.Feature.NUM_STREAMS, -1);
        int numGaussiansPerState = pool.getFeature(Pool.Feature.NUM_GAUSSIANS_PER_STATE, -1);
        this.writeInt(dos, numStates);
        this.writeInt(dos, numStreams);
        this.writeInt(dos, numGaussiansPerState);
        int rawLength = 0;
        int[] vectorLength = new int[numStreams];
        int i = 0;
        while (i < numStreams) {
            vectorLength[i] = this.vectorLength;
            this.writeInt(dos, vectorLength[i]);
            rawLength += numGaussiansPerState * numStates * vectorLength[i];
            ++i;
        }
        assert (numStreams == 1);
        assert (rawLength == numGaussiansPerState * numStates * this.vectorLength);
        this.writeInt(dos, rawLength);
        i = 0;
        while (i < numStates) {
            int j = 0;
            while (j < numStreams) {
                int k = 0;
                while (k < numGaussiansPerState) {
                    int id = i * numStreams * numGaussiansPerState + j * numGaussiansPerState + k;
                    float[] density = pool.get(id);
                    this.writeFloatArray(dos, density);
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        if (this.doCheckSum) if (!$assertionsDisabled) {
            this.doCheckSum = false;
            if (!false) {
                throw new AssertionError((Object)"Checksum not supported");
            }
        }
        this.writeInt(dos, checkSum);
        dos.close();
    }

    protected DataOutputStream writeS3BinaryHeader(String location, String path, Properties props, boolean append) throws IOException {
        OutputStream outputStream = StreamFactory.getOutputStream(location, path, append);
        if (this.doCheckSum) assert (false) : "Checksum not supported";
        DataOutputStream dos = new DataOutputStream(new BufferedOutputStream(outputStream));
        this.writeWord(dos, "s3\n");
        Enumeration<Object> e = props.keys();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            String value = props.getProperty(name);
            this.writeWord(dos, String.valueOf(name) + ' ' + value + '\n');
        }
        this.writeWord(dos, "endhdr\n");
        this.writeInt(dos, 287454020);
        return dos;
    }

    void writeWord(DataOutputStream dos, String word) throws IOException {
        dos.writeBytes(word);
    }

    protected void writeInt(DataOutputStream dos, int val) throws IOException {
        if (this.swap) {
            dos.writeInt(Utilities.swapInteger(val));
        } else {
            dos.writeInt(val);
        }
    }

    protected void writeFloat(DataOutputStream dos, float val) throws IOException {
        if (this.swap) {
            dos.writeFloat(Utilities.swapFloat(val));
        } else {
            dos.writeFloat(val);
        }
    }

    protected void writeFloatArray(DataOutputStream dos, float[] data) throws IOException {
        float[] fArray = data;
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            float val = fArray[n2];
            this.writeFloat(dos, val);
            ++n2;
        }
    }

    private void saveHMMPool(boolean useCDUnits, OutputStream outputStream, String path) throws FileNotFoundException, IOException {
        Unit unit;
        SenoneHMM hmm;
        this.logger.info("Saving HMM file to: ");
        this.logger.info(path);
        if (outputStream == null) {
            throw new IOException("Error trying to write file " + this.location + path);
        }
        PrintWriter pw = new PrintWriter(outputStream, true);
        int numBase = 0;
        int numTri = 0;
        int numContextIndependentTiedState = 0;
        int numStateMap = 0;
        for (HMM hmm2 : this.hmmManager) {
            numStateMap += hmm2.getOrder() + 1;
            if (((SenoneHMM)hmm2).isContextDependent()) {
                ++numTri;
                continue;
            }
            ++numBase;
            numContextIndependentTiedState += hmm2.getOrder();
        }
        pw.println(MODEL_VERSION);
        pw.println(String.valueOf(numBase) + " n_base");
        pw.println(String.valueOf(numTri) + " n_tri");
        pw.println(String.valueOf(numStateMap) + " n_state_map");
        int numTiedState = this.mixtureWeights.getStatesNum();
        pw.println(String.valueOf(numTiedState) + " n_tied_state");
        pw.println(String.valueOf(numContextIndependentTiedState) + " n_tied_ci_state");
        int numTiedTransitionMatrices = numBase;
        assert (numTiedTransitionMatrices == this.matrixPool.size());
        pw.println(String.valueOf(numTiedTransitionMatrices) + " n_tied_tmat");
        pw.println("#");
        pw.println("# Columns definitions");
        pw.println("#base lft  rt p attrib tmat      ... state id's ...");
        for (HMM hmm0 : this.hmmManager) {
            Senone[] senones;
            hmm = (SenoneHMM)hmm0;
            if (hmm.isContextDependent()) continue;
            unit = hmm.getUnit();
            String name = unit.getName();
            pw.print(String.valueOf(name) + '\t');
            String left = "-";
            pw.print(String.valueOf(left) + "   ");
            String right = "-";
            pw.print(String.valueOf(right) + ' ');
            String position = hmm.getPosition().toString();
            pw.print(String.valueOf(position) + '\t');
            String attribute = unit.isFiller() ? FILLER : "n/a";
            pw.print(String.valueOf(attribute) + '\t');
            int tmat = this.matrixPool.indexOf(hmm.getTransitionMatrix());
            assert (tmat < numTiedTransitionMatrices);
            pw.print(String.valueOf(tmat) + "\t");
            SenoneSequence ss = hmm.getSenoneSequence();
            Senone[] senoneArray = senones = ss.getSenones();
            int n = senones.length;
            int n2 = 0;
            while (n2 < n) {
                Senone senone = senoneArray[n2];
                int index = this.senonePool.indexOf(senone);
                assert (index >= 0 && index < numContextIndependentTiedState);
                pw.print(String.valueOf(index) + "\t");
                ++n2;
            }
            pw.println("N");
            if (!this.logger.isLoggable(Level.FINE)) continue;
            this.logger.fine("Saved " + unit);
        }
        for (HMM hmm0 : this.hmmManager) {
            Senone[] senones;
            String attribute;
            hmm = (SenoneHMM)hmm0;
            if (!hmm.isContextDependent()) continue;
            unit = hmm.getUnit();
            LeftRightContext context = (LeftRightContext)unit.getContext();
            Unit[] leftContext = context.getLeftContext();
            Unit[] rightContext = context.getRightContext();
            assert (leftContext.length == 1 && rightContext.length == 1);
            String name = unit.getName();
            pw.print(String.valueOf(name) + '\t');
            String left = leftContext[0].getName();
            pw.print(String.valueOf(left) + "   ");
            String right = rightContext[0].getName();
            pw.print(String.valueOf(right) + ' ');
            String position = hmm.getPosition().toString();
            pw.print(String.valueOf(position) + '\t');
            String string = attribute = unit.isFiller() ? FILLER : "n/a";
            assert (attribute.equals("n/a"));
            pw.print(String.valueOf(attribute) + '\t');
            int tmat = this.matrixPool.indexOf(hmm.getTransitionMatrix());
            assert (tmat < numTiedTransitionMatrices);
            pw.print(String.valueOf(tmat) + "\t");
            SenoneSequence ss = hmm.getSenoneSequence();
            Senone[] senoneArray = senones = ss.getSenones();
            int n = senones.length;
            int n3 = 0;
            while (n3 < n) {
                Senone senone = senoneArray[n3];
                int index = this.senonePool.indexOf(senone);
                assert (index >= 0 && index < numTiedState);
                pw.print(String.valueOf(index) + "\t");
                ++n3;
            }
            pw.println("N");
            if (!this.logger.isLoggable(Level.FINE)) continue;
            this.logger.fine("Saved " + unit);
        }
        outputStream.close();
    }

    private void saveMixtureWeightsAscii(GaussianWeights mixtureWeights, String path, boolean append) throws FileNotFoundException, IOException {
        this.logger.info("Saving mixture weights to: ");
        this.logger.info(path);
        OutputStream outputStream = StreamFactory.getOutputStream(this.location, path, append);
        if (outputStream == null) {
            throw new IOException("Error trying to write file " + this.location + path);
        }
        PrintWriter pw = new PrintWriter(outputStream, true);
        pw.print("mixw ");
        int numStates = mixtureWeights.getStatesNum();
        pw.print(String.valueOf(numStates) + " ");
        int numStreams = mixtureWeights.getStreamsNum();
        pw.print(String.valueOf(numStreams) + " ");
        int numGaussiansPerState = mixtureWeights.getGauPerState();
        pw.println(numGaussiansPerState);
        int i = 0;
        while (i < numStates) {
            int j = 0;
            while (j < numStreams) {
                pw.print("mixw [" + i + " " + j + "] ");
                float[] mixtureWeight = new float[numGaussiansPerState];
                float[] logMixtureWeight = new float[numGaussiansPerState];
                int k = 0;
                while (k < numGaussiansPerState) {
                    logMixtureWeight[k] = mixtureWeights.get(i, j, k);
                    ++k;
                }
                this.logMath.logToLinear(logMixtureWeight, mixtureWeight);
                float sum = 0.0f;
                int k2 = 0;
                while (k2 < numGaussiansPerState) {
                    sum += mixtureWeight[k2];
                    ++k2;
                }
                pw.println(sum);
                pw.print("\n\t");
                k2 = 0;
                while (k2 < numGaussiansPerState) {
                    pw.print(" " + mixtureWeight[k2]);
                    ++k2;
                }
                pw.println();
                ++j;
            }
            ++i;
        }
        outputStream.close();
    }

    private void saveMixtureWeightsBinary(GaussianWeights mixtureWeights, String path, boolean append) throws FileNotFoundException, IOException {
        this.logger.info("Saving mixture weights to: ");
        this.logger.info(path);
        Properties props = new Properties();
        props.setProperty("version", "1.0");
        if (this.doCheckSum) {
            props.setProperty("chksum0", this.checksum);
        }
        DataOutputStream dos = this.writeS3BinaryHeader(this.location, path, props, append);
        int numStates = mixtureWeights.getStatesNum();
        int numStreams = mixtureWeights.getStreamsNum();
        int numGaussiansPerState = mixtureWeights.getGauPerState();
        this.writeInt(dos, numStates);
        this.writeInt(dos, numStreams);
        this.writeInt(dos, numGaussiansPerState);
        assert (numStreams == 1);
        int rawLength = numGaussiansPerState * numStates * numStreams;
        this.writeInt(dos, rawLength);
        int i = 0;
        while (i < numStates) {
            int j = 0;
            while (j < numStreams) {
                float[] mixtureWeight = new float[numGaussiansPerState];
                float[] logMixtureWeight = new float[numGaussiansPerState];
                int k = 0;
                while (k < numGaussiansPerState) {
                    logMixtureWeight[k] = mixtureWeights.get(i, j, k);
                    ++k;
                }
                this.logMath.logToLinear(logMixtureWeight, mixtureWeight);
                this.writeFloatArray(dos, mixtureWeight);
                ++j;
            }
            ++i;
        }
        if (this.doCheckSum) if (!$assertionsDisabled) {
            this.doCheckSum = false;
            if (!false) {
                throw new AssertionError((Object)"Checksum not supported");
            }
        }
        dos.close();
    }

    protected void saveTransitionMatricesAscii(Pool<float[][]> pool, String path, boolean append) throws FileNotFoundException, IOException {
        OutputStream outputStream = StreamFactory.getOutputStream(this.location, path, append);
        if (outputStream == null) {
            throw new IOException("Error trying to write file " + this.location + path);
        }
        PrintWriter pw = new PrintWriter(outputStream, true);
        this.logger.info("Saving transition matrices to: ");
        this.logger.info(path);
        int numMatrices = pool.size();
        assert (numMatrices > 0);
        float[][] tmat = pool.get(0);
        int numStates = tmat[0].length;
        pw.println("tmat " + numMatrices + ' ' + numStates);
        int i = 0;
        while (i < numMatrices) {
            pw.println("tmat [" + i + ']');
            tmat = pool.get(i);
            int j = 0;
            while (j < numStates) {
                int k = 0;
                while (k < numStates) {
                    if (j < numStates - 1) {
                        if (this.sparseForm) {
                            if (k < j) {
                                pw.print("\t");
                            }
                            if (k == j || k == j + 1) {
                                pw.print((float)this.logMath.logToLinear(tmat[j][k]));
                            }
                        } else {
                            pw.print((float)this.logMath.logToLinear(tmat[j][k]));
                        }
                        if (numStates - 1 == k) {
                            pw.println();
                        } else {
                            pw.print(" ");
                        }
                    }
                    if (this.logger.isLoggable(Level.FINE)) {
                        this.logger.fine("tmat j " + j + " k " + k + " tm " + tmat[j][k]);
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        outputStream.close();
    }

    protected void saveTransitionMatricesBinary(Pool<float[][]> pool, String path, boolean append) throws IOException {
        this.logger.info("Saving transition matrices to: ");
        this.logger.info(path);
        Properties props = new Properties();
        props.setProperty("version", "1.0");
        if (this.doCheckSum) {
            props.setProperty("chksum0", this.checksum);
        }
        DataOutputStream dos = this.writeS3BinaryHeader(this.location, path, props, append);
        int numMatrices = pool.size();
        assert (numMatrices > 0);
        this.writeInt(dos, numMatrices);
        float[][] tmat = pool.get(0);
        int numStates = tmat[0].length;
        int numRows = numStates - 1;
        this.writeInt(dos, numRows);
        this.writeInt(dos, numStates);
        int numValues = numStates * numRows * numMatrices;
        this.writeInt(dos, numValues);
        int i = 0;
        while (i < numMatrices) {
            tmat = pool.get(i);
            float[] logTmatRow = tmat[numStates - 1];
            float[] tmatRow = new float[logTmatRow.length];
            int j = 0;
            while (j < numStates) {
                assert (tmatRow[j] == 0.0f);
                ++j;
            }
            j = 0;
            while (j < numRows) {
                logTmatRow = tmat[j];
                tmatRow = new float[logTmatRow.length];
                this.logMath.logToLinear(logTmatRow, tmatRow);
                this.writeFloatArray(dos, tmatRow);
                ++j;
            }
            ++i;
        }
        if (this.doCheckSum) if (!$assertionsDisabled) {
            this.doCheckSum = false;
            if (!false) {
                throw new AssertionError((Object)"Checksum not supported");
            }
        }
        dos.close();
    }

    @Override
    public Pool<float[]> getMeansPool() {
        return this.meansPool;
    }

    @Override
    public Pool<float[][]> getMeansTransformationMatrixPool() {
        return this.meanTransformationMatrixPool;
    }

    @Override
    public Pool<float[]> getMeansTransformationVectorPool() {
        return this.meanTransformationVectorPool;
    }

    @Override
    public Pool<float[]> getVariancePool() {
        return this.variancePool;
    }

    @Override
    public Pool<float[][]> getVarianceTransformationMatrixPool() {
        return this.varianceTransformationMatrixPool;
    }

    @Override
    public Pool<float[]> getVarianceTransformationVectorPool() {
        return this.varianceTransformationVectorPool;
    }

    @Override
    public Pool<Senone> getSenonePool() {
        return this.senonePool;
    }

    @Override
    public int getLeftContextSize() {
        return 1;
    }

    @Override
    public int getRightContextSize() {
        return 1;
    }

    @Override
    public HMMManager getHMMManager() {
        return this.hmmManager;
    }

    @Override
    public void logInfo() {
        this.logger.info("Sphinx3Saver");
        this.meansPool.logInfo(this.logger);
        this.variancePool.logInfo(this.logger);
        this.matrixPool.logInfo(this.logger);
        this.senonePool.logInfo(this.logger);
        this.meanTransformationMatrixPool.logInfo(this.logger);
        this.meanTransformationVectorPool.logInfo(this.logger);
        this.varianceTransformationMatrixPool.logInfo(this.logger);
        this.varianceTransformationVectorPool.logInfo(this.logger);
        this.mixtureWeights.logInfo(this.logger);
        this.senonePool.logInfo(this.logger);
        this.logger.info("Context Independent Unit Entries: " + this.contextIndependentUnits.size());
        this.hmmManager.logInfo(this.logger);
    }
}

