/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.linguist.acoustic.tiedstate.trainer;

import edu.cmu.sphinx.decoder.adaptation.ClusteredDensityFileData;
import edu.cmu.sphinx.decoder.adaptation.Transform;
import edu.cmu.sphinx.linguist.acoustic.HMMPosition;
import edu.cmu.sphinx.linguist.acoustic.Unit;
import edu.cmu.sphinx.linguist.acoustic.UnitManager;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.GaussianMixture;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.GaussianWeights;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.HMMManager;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.Loader;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.MixtureComponent;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.Pool;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.Senone;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.SenoneHMM;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.SenoneSequence;
import edu.cmu.sphinx.util.ExtendedStreamTokenizer;
import edu.cmu.sphinx.util.LogMath;
import edu.cmu.sphinx.util.StreamFactory;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.S4Boolean;
import edu.cmu.sphinx.util.props.S4Component;
import edu.cmu.sphinx.util.props.S4Double;
import edu.cmu.sphinx.util.props.S4String;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StreamCorruptedException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ModelInitializerLoader
implements Loader {
    private static final String SILENCE_CIPHONE = "SIL";
    public static final String MODEL_VERSION = "0.3";
    private static final int CONTEXT_SIZE = 1;
    private Pool<float[]> meansPool;
    private Pool<float[]> variancePool;
    private Pool<float[][]> matrixPool;
    private Pool<float[][]> meanTransformationMatrixPool;
    private Pool<float[]> meanTransformationVectorPool;
    private Pool<float[][]> varianceTransformationMatrixPool;
    private Pool<float[]> varianceTransformationVectorPool;
    private GaussianWeights mixtureWeights;
    private Pool<Senone> senonePool;
    private int vectorLength = 39;
    private Map<String, Unit> contextIndependentUnits;
    private Map<String, Integer> phoneList;
    private HMMManager hmmManager;
    @S4String(defaultValue="model")
    public static final String MODEL_NAME = "modelName";
    @S4String(defaultValue=".")
    public static final String LOCATION = "location";
    @S4String(defaultValue="phonelist")
    public static final String PHONE_LIST = "phones";
    @S4String(defaultValue="data")
    public static final String DATA_DIR = "dataDir";
    @S4String(defaultValue="model.props")
    public static final String PROP_FILE = "propsFile";
    @S4Component(type=UnitManager.class)
    public static final String PROP_UNIT_MANAGER = "unitManager";
    private UnitManager unitManager;
    @S4Boolean(defaultValue=false)
    public static final String PROP_USE_CD_UNITS = "useCDUnits";
    @S4Double(defaultValue=9.999999747378752E-5)
    public static final String PROP_VARIANCE_FLOOR = "varianceFloor";
    @S4Double(defaultValue=0.0)
    public static final String PROP_MC_FLOOR = "MixtureComponentScoreFloor";
    @S4Double(defaultValue=1.0000000116860974E-7)
    public static final String PROP_MW_FLOOR = "mixtureWeightFloor";
    private LogMath logMath;
    private Logger logger;

    @Override
    public void newProperties(PropertySheet ps) throws PropertyException {
        this.logMath = LogMath.getLogMath();
        this.logger = ps.getLogger();
        this.unitManager = (UnitManager)ps.getComponent(PROP_UNIT_MANAGER);
        this.hmmManager = new HMMManager();
        this.contextIndependentUnits = new LinkedHashMap<String, Unit>();
        this.phoneList = new LinkedHashMap<String, Integer>();
        this.meanTransformationMatrixPool = this.createDummyMatrixPool("meanTransformationMatrix");
        this.meanTransformationVectorPool = this.createDummyVectorPool("meanTransformationMatrix");
        this.varianceTransformationMatrixPool = this.createDummyMatrixPool("varianceTransformationMatrix");
        this.varianceTransformationVectorPool = this.createDummyVectorPool("varianceTransformationMatrix");
        String modelName = ps.getString(MODEL_NAME);
        String location = ps.getString(LOCATION);
        String phone = ps.getString(PHONE_LIST);
        String dataDir = ps.getString(DATA_DIR);
        this.logger.info("Creating Sphinx3 acoustic model: " + modelName);
        this.logger.info("    Path      : " + location);
        this.logger.info("    phonelist : " + phone);
        this.logger.info("    dataDir   : " + dataDir);
        boolean useCDUnits = ps.getBoolean(PROP_USE_CD_UNITS);
        assert (!useCDUnits);
        try {
            this.loadPhoneList(ps, useCDUnits, StreamFactory.getInputStream(location, phone), String.valueOf(location) + File.separator + phone);
        }
        catch (StreamCorruptedException sce) {
            this.printPhoneListHelp();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void printPhoneListHelp() {
        System.out.println("The format for the phone list file is:");
        System.out.println("\tversion 0.1");
        System.out.println("\tsame_sized_models yes");
        System.out.println("\tn_state 3");
        System.out.println("\ttmat_skip (no|yes)");
        System.out.println("\tAA");
        System.out.println("\tAE");
        System.out.println("\tAH");
        System.out.println("\t...");
        System.out.println("Or:");
        System.out.println("\tversion 0.1");
        System.out.println("\tsame_sized_models no");
        System.out.println("\ttmat_skip (no|yes)");
        System.out.println("\tAA 5");
        System.out.println("\tAE 3");
        System.out.println("\tAH 4");
        System.out.println("\t...");
    }

    @Override
    public Map<String, Unit> getContextIndependentUnits() {
        return this.contextIndependentUnits;
    }

    private void addModelToSenonePool(Pool<Senone> pool, int[] stateID, float distFloor, float varianceFloor) {
        assert (pool != null);
        int numGaussiansPerSenone = this.mixtureWeights.getGauPerState();
        assert (numGaussiansPerSenone > 0);
        int[] nArray = stateID;
        int n = stateID.length;
        int n2 = 0;
        while (n2 < n) {
            int state = nArray[n2];
            MixtureComponent[] mixtureComponents = new MixtureComponent[numGaussiansPerSenone];
            int j = 0;
            while (j < numGaussiansPerSenone) {
                int whichGaussian = state * numGaussiansPerSenone + j;
                mixtureComponents[j] = new MixtureComponent(this.meansPool.get(whichGaussian), this.meanTransformationMatrixPool.get(0), this.meanTransformationVectorPool.get(0), this.variancePool.get(whichGaussian), this.varianceTransformationMatrixPool.get(0), this.varianceTransformationVectorPool.get(0), distFloor, varianceFloor);
                ++j;
            }
            GaussianMixture senone = new GaussianMixture(this.mixtureWeights, mixtureComponents, state);
            pool.put(state, senone);
            ++n2;
        }
    }

    private void addModelToDensityPool(Pool<float[]> pool, int[] stateID, int numStreams, int numGaussiansPerState) throws IOException {
        assert (pool != null);
        assert (stateID != null);
        int numStates = stateID.length;
        int numInPool = pool.getFeature(Pool.Feature.NUM_SENONES, 0);
        pool.setFeature(Pool.Feature.NUM_SENONES, numStates + numInPool);
        numInPool = pool.getFeature(Pool.Feature.NUM_STREAMS, -1);
        if (numInPool == -1) {
            pool.setFeature(Pool.Feature.NUM_STREAMS, numStreams);
        } else assert (numInPool == numStreams);
        numInPool = pool.getFeature(Pool.Feature.NUM_GAUSSIANS_PER_STATE, -1);
        if (numInPool == -1) {
            pool.setFeature(Pool.Feature.NUM_GAUSSIANS_PER_STATE, numGaussiansPerState);
        } else assert (numInPool == numGaussiansPerState);
        assert (numStreams == 1);
        int i = 0;
        while (i < numStates) {
            int state = stateID[i];
            int j = 0;
            while (j < numGaussiansPerState) {
                float[] density = new float[this.vectorLength];
                int id = state * numGaussiansPerState + j;
                pool.put(id, density);
                ++j;
            }
            ++i;
        }
    }

    private void floorData(float[] data, float floor) {
        int i = 0;
        while (i < data.length) {
            if (data[i] < floor) {
                data[i] = floor;
            }
            ++i;
        }
    }

    private void normalize(float[] data) {
        float sum = 0.0f;
        float[] fArray = data;
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            float val = fArray[n2];
            sum += val;
            ++n2;
        }
        if (sum != 0.0f) {
            sum = 1.0f / sum;
            int i = 0;
            while (i < data.length) {
                data[i] = data[i] * sum;
                ++i;
            }
        }
    }

    private void loadPhoneList(PropertySheet ps, boolean useCDUnits, InputStream inputStream, String path) throws IOException {
        int numState = 0;
        int numStreams = 1;
        int numGaussiansPerState = 1;
        ExtendedStreamTokenizer est = new ExtendedStreamTokenizer(inputStream, 35, false);
        this.meansPool = new Pool("means");
        this.variancePool = new Pool("variances");
        this.matrixPool = new Pool("transitionmatrices");
        this.senonePool = new Pool("senones");
        float distFloor = ps.getFloat(PROP_MC_FLOOR);
        float mixtureWeightFloor = ps.getFloat(PROP_MW_FLOOR);
        float transitionProbabilityFloor = 0.0f;
        float varianceFloor = ps.getFloat(PROP_VARIANCE_FLOOR);
        this.logger.info("Loading phone list file from: ");
        this.logger.info(path);
        String version = "0.1";
        est.expectString("version");
        est.expectString(version);
        est.expectString("same_sized_models");
        boolean sameSizedModels = est.getString().equals("yes");
        if (sameSizedModels) {
            est.expectString("n_state");
            numState = est.getInt("numBase");
        }
        est.expectString("tmat_skip");
        boolean tmatSkip = est.getString().equals("yes");
        int stateIndex = 0;
        int unitCount = 0;
        while (true) {
            String phone = est.getString();
            if (est.isEOF()) break;
            int size = numState;
            if (!sameSizedModels) {
                size = est.getInt("ModelSize");
            }
            this.phoneList.put(phone, size);
            this.logger.fine("Phone: " + phone + " size: " + size);
            int[] stid = new int[size];
            String position = "-";
            int j = 0;
            while (j < size) {
                stid[j] = stateIndex++;
                ++j;
            }
            Unit unit = this.unitManager.getUnit(phone, phone.equals(SILENCE_CIPHONE));
            this.contextIndependentUnits.put(unit.getName(), unit);
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("Loaded " + unit + " with " + size + " states");
            }
            this.addModelToDensityPool(this.meansPool, stid, numStreams, numGaussiansPerState);
            this.addModelToDensityPool(this.variancePool, stid, numStreams, numGaussiansPerState);
            this.addModelToTransitionMatrixPool(this.matrixPool, unitCount, stid.length, transitionProbabilityFloor, tmatSkip);
            this.addModelToSenonePool(this.senonePool, stid, distFloor, varianceFloor);
            float[][] transitionMatrix = this.matrixPool.get(unitCount);
            SenoneSequence ss = this.getSenoneSequence(stid);
            SenoneHMM hmm = new SenoneHMM(unit, ss, transitionMatrix, HMMPosition.lookup(position));
            this.hmmManager.put(hmm);
            ++unitCount;
        }
        this.mixtureWeights = this.initMixtureWeights(stateIndex, numStreams, numGaussiansPerState, mixtureWeightFloor);
        est.close();
    }

    private SenoneSequence getSenoneSequence(int[] stateid) {
        Senone[] senones = new Senone[stateid.length];
        int i = 0;
        while (i < stateid.length) {
            senones[i] = this.senonePool.get(stateid[i]);
            ++i;
        }
        return new SenoneSequence(senones);
    }

    private GaussianWeights initMixtureWeights(int numStates, int numStreams, int numGaussiansPerState, float floor) {
        assert (numStreams == 1);
        GaussianWeights mixtureWeights = new GaussianWeights("mixtureweights", numStates, numGaussiansPerState, numStreams);
        int i = 0;
        while (i < numStates) {
            float[] logMixtureWeight = new float[numGaussiansPerState];
            this.floorData(logMixtureWeight, floor);
            this.normalize(logMixtureWeight);
            this.logMath.linearToLog(logMixtureWeight);
            mixtureWeights.put(i, 0, logMixtureWeight);
            ++i;
        }
        return mixtureWeights;
    }

    private void addModelToTransitionMatrixPool(Pool<float[][]> pool, int hmmId, int numEmittingStates, float floor, boolean skip) throws IOException {
        assert (pool != null);
        int numStates = numEmittingStates + 1;
        float[][] tmat = new float[numStates][numStates];
        int j = 0;
        while (j < numStates) {
            int k = 0;
            while (k < numStates) {
                tmat[j][k] = 0.0f;
                if (j < numStates - 1) {
                    if (k == j || k == j + 1) {
                        tmat[j][k] = floor;
                    }
                    if (skip && k == j + 2) {
                        tmat[j][k] = floor;
                    }
                }
                ++k;
            }
            this.normalize(tmat[j]);
            this.logMath.linearToLog(tmat[j]);
            ++j;
        }
        pool.put(hmmId, tmat);
    }

    private Pool<float[][]> createDummyMatrixPool(String name) {
        Pool<float[][]> pool = new Pool<float[][]>(name);
        float[][] matrix = new float[this.vectorLength][this.vectorLength];
        this.logger.info("creating dummy matrix pool " + name);
        int i = 0;
        while (i < this.vectorLength) {
            int j = 0;
            while (j < this.vectorLength) {
                matrix[i][j] = i == j ? 1.0f : 0.0f;
                ++j;
            }
            ++i;
        }
        pool.put(0, matrix);
        return pool;
    }

    private Pool<float[]> createDummyVectorPool(String name) {
        this.logger.info("creating dummy vector pool " + name);
        Pool<float[]> pool = new Pool<float[]>(name);
        float[] vector = new float[this.vectorLength];
        int i = 0;
        while (i < this.vectorLength) {
            vector[i] = 0.0f;
            ++i;
        }
        pool.put(0, vector);
        return pool;
    }

    @Override
    public void load() throws IOException {
    }

    @Override
    public Pool<float[]> getMeansPool() {
        return this.meansPool;
    }

    @Override
    public Pool<float[][]> getMeansTransformationMatrixPool() {
        return this.meanTransformationMatrixPool;
    }

    @Override
    public Pool<float[]> getMeansTransformationVectorPool() {
        return this.meanTransformationVectorPool;
    }

    @Override
    public Pool<float[]> getVariancePool() {
        return this.variancePool;
    }

    @Override
    public Pool<float[][]> getVarianceTransformationMatrixPool() {
        return this.varianceTransformationMatrixPool;
    }

    @Override
    public Pool<float[]> getVarianceTransformationVectorPool() {
        return this.varianceTransformationVectorPool;
    }

    @Override
    public GaussianWeights getMixtureWeights() {
        return this.mixtureWeights;
    }

    @Override
    public Pool<float[][]> getTransitionMatrixPool() {
        return this.matrixPool;
    }

    @Override
    public float[][] getTransformMatrix() {
        return null;
    }

    @Override
    public Pool<Senone> getSenonePool() {
        return this.senonePool;
    }

    @Override
    public int getLeftContextSize() {
        return 1;
    }

    @Override
    public int getRightContextSize() {
        return 1;
    }

    @Override
    public HMMManager getHMMManager() {
        return this.hmmManager;
    }

    @Override
    public void logInfo() {
        this.logger.info("Sphinx3Loader");
        this.meansPool.logInfo(this.logger);
        this.variancePool.logInfo(this.logger);
        this.matrixPool.logInfo(this.logger);
        this.senonePool.logInfo(this.logger);
        this.meanTransformationMatrixPool.logInfo(this.logger);
        this.meanTransformationVectorPool.logInfo(this.logger);
        this.varianceTransformationMatrixPool.logInfo(this.logger);
        this.varianceTransformationVectorPool.logInfo(this.logger);
        this.mixtureWeights.logInfo(this.logger);
        this.senonePool.logInfo(this.logger);
        this.logger.info("Context Independent Unit Entries: " + this.contextIndependentUnits.size());
        this.hmmManager.logInfo(this.logger);
    }

    @Override
    public Properties getProperties() {
        return new Properties();
    }

    @Override
    public void update(Transform transform, ClusteredDensityFileData clusters) {
    }
}

