/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.linguist.acoustic.tiedstate.trainer;

import edu.cmu.sphinx.frontend.FloatData;
import edu.cmu.sphinx.linguist.acoustic.HMM;
import edu.cmu.sphinx.linguist.acoustic.HMMState;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.GaussianMixture;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.GaussianWeights;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.HMMManager;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.Loader;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.MixtureComponent;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.Pool;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.Senone;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.SenoneHMM;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.SenoneHMMState;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.trainer.Buffer;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.trainer.TrainerScore;
import edu.cmu.sphinx.util.LogMath;
import java.io.IOException;
import java.util.HashMap;
import java.util.logging.Logger;

class HMMPoolManager {
    private HMMManager hmmManager;
    private HashMap<Object, Integer> indexMap;
    private Pool<float[]> meansPool;
    private Pool<float[]> variancePool;
    private Pool<float[][]> matrixPool;
    private GaussianWeights mixtureWeights;
    private Pool<Buffer> meansBufferPool;
    private Pool<Buffer> varianceBufferPool;
    private Pool<Buffer[]> matrixBufferPool;
    private Pool<Buffer> mixtureWeightsBufferPool;
    private Pool<Senone> senonePool;
    private LogMath logMath;
    private float logMixtureWeightFloor;
    private float logTransitionProbabilityFloor;
    private float varianceFloor;
    private float logLikelihood;
    private float currentLogLikelihood;
    private static Logger logger = Logger.getLogger("edu.cmu.sphinx.linguist.acoustic.HMMPoolManager");

    protected HMMPoolManager(Loader loader) throws IOException {
        loader.load();
        this.hmmManager = loader.getHMMManager();
        this.indexMap = new HashMap();
        this.meansPool = loader.getMeansPool();
        this.variancePool = loader.getVariancePool();
        this.mixtureWeights = loader.getMixtureWeights();
        this.matrixPool = loader.getTransitionMatrixPool();
        this.senonePool = loader.getSenonePool();
        this.createBuffers();
        this.logLikelihood = 0.0f;
        this.logMath = LogMath.getLogMath();
    }

    protected void resetBuffers() {
        this.createBuffers();
        this.logLikelihood = 0.0f;
    }

    protected void createBuffers() {
        this.meansBufferPool = this.create1DPoolBuffer(this.meansPool, false);
        this.varianceBufferPool = this.create1DPoolBuffer(this.variancePool, false);
        this.matrixBufferPool = this.create2DPoolBuffer(this.matrixPool, true);
        this.mixtureWeightsBufferPool = this.createWeightsPoolBuffer(this.mixtureWeights);
    }

    private Pool<Buffer> create1DPoolBuffer(Pool<float[]> pool, boolean isLog) {
        Pool<Buffer> bufferPool = new Pool<Buffer>(pool.getName());
        int i = 0;
        while (i < pool.size()) {
            float[] element = pool.get(i);
            this.indexMap.put(element, i);
            Buffer buffer = new Buffer(element.length, isLog, i);
            bufferPool.put(i, buffer);
            ++i;
        }
        return bufferPool;
    }

    private Pool<Buffer> createWeightsPoolBuffer(GaussianWeights mixtureWeights) {
        Pool<Buffer> bufferPool = new Pool<Buffer>(mixtureWeights.getName());
        int statesNum = mixtureWeights.getStatesNum();
        int streamsNum = mixtureWeights.getStreamsNum();
        int gauPerState = mixtureWeights.getGauPerState();
        int i = 0;
        while (i < streamsNum) {
            int j = 0;
            while (j < statesNum) {
                int id = i * statesNum + j;
                Buffer buffer = new Buffer(gauPerState, true, id);
                bufferPool.put(id, buffer);
                ++j;
            }
            ++i;
        }
        return bufferPool;
    }

    private Pool<Buffer[]> create2DPoolBuffer(Pool<float[][]> pool, boolean isLog) {
        Pool<Buffer[]> bufferPool = new Pool<Buffer[]>(pool.getName());
        int i = 0;
        while (i < pool.size()) {
            float[][] element = pool.get(i);
            this.indexMap.put(element, i);
            int poolSize = element.length;
            Buffer[] bufferArray = new Buffer[poolSize];
            int j = 0;
            while (j < poolSize) {
                bufferArray[j] = new Buffer(element[j].length, isLog, j);
                ++j;
            }
            bufferPool.put(i, bufferArray);
            ++i;
        }
        return bufferPool;
    }

    protected void accumulate(int index, TrainerScore[] score) {
        this.accumulate(index, score, null);
    }

    protected void accumulate(int index, TrainerScore[] score, TrainerScore[] nextScore) {
        TrainerScore thisScore = score[index];
        this.currentLogLikelihood = 0.0f;
        this.logLikelihood -= score[0].getScalingFactor();
        SenoneHMMState state = (SenoneHMMState)thisScore.getState();
        if (state == null) {
            int senoneID = thisScore.getSenoneID();
            if (senoneID == -1) {
                this.accumulateMean(senoneID, score[index]);
                this.accumulateVariance(senoneID, score[index]);
                this.accumulateMixture(senoneID, score[index]);
                this.accumulateTransition(senoneID, index, score, nextScore);
            }
        } else if (state.isEmitting()) {
            int senoneID = this.senonePool.indexOf(state.getSenone());
            this.accumulateMixture(senoneID, score[index]);
            this.accumulateTransition(senoneID, index, score, nextScore);
        }
    }

    private void accumulateMean(int senone, TrainerScore score) {
        if (senone == -1) {
            int i = 0;
            while (i < this.senonePool.size()) {
                this.accumulateMean(i, score);
                ++i;
            }
        } else {
            GaussianMixture gaussian = (GaussianMixture)this.senonePool.get(senone);
            MixtureComponent[] mix = gaussian.getMixtureComponents();
            int i = 0;
            while (i < mix.length) {
                float[] mean = mix[i].getMean();
                int indexMean = this.indexMap.get(mean);
                assert (indexMean >= 0);
                assert (indexMean == senone);
                Buffer buffer = this.meansBufferPool.get(indexMean);
                float[] feature = ((FloatData)score.getData()).getValues();
                double[] data = new double[feature.length];
                float prob = score.getComponentGamma()[i];
                double dprob = this.logMath.logToLinear(prob -= this.currentLogLikelihood);
                int j = 0;
                while (j < data.length) {
                    data[j] = (double)feature[j] * dprob;
                    ++j;
                }
                buffer.accumulate(data, dprob);
                ++i;
            }
        }
    }

    private void accumulateVariance(int senone, TrainerScore score) {
        if (senone == -1) {
            int i = 0;
            while (i < this.senonePool.size()) {
                this.accumulateVariance(i, score);
                ++i;
            }
        } else {
            GaussianMixture gaussian = (GaussianMixture)this.senonePool.get(senone);
            MixtureComponent[] mix = gaussian.getMixtureComponents();
            int i = 0;
            while (i < mix.length) {
                float[] mean = mix[i].getMean();
                float[] variance = mix[i].getVariance();
                int indexVariance = this.indexMap.get(variance);
                Buffer buffer = this.varianceBufferPool.get(indexVariance);
                float[] feature = ((FloatData)score.getData()).getValues();
                double[] data = new double[feature.length];
                float prob = score.getComponentGamma()[i];
                double dprob = this.logMath.logToLinear(prob -= this.currentLogLikelihood);
                int j = 0;
                while (j < data.length) {
                    data[j] = feature[j] - mean[j];
                    int n = j;
                    data[n] = data[n] * (data[j] * dprob);
                    ++j;
                }
                buffer.accumulate(data, dprob);
                ++i;
            }
        }
    }

    private void accumulateMixture(int senone, TrainerScore score) {
        if (senone == -1) {
            int i = 0;
            while (i < this.senonePool.size()) {
                this.accumulateMixture(i, score);
                ++i;
            }
        } else {
            Buffer buffer = this.mixtureWeightsBufferPool.get(senone);
            int i = 0;
            while (i < this.mixtureWeights.getGauPerState()) {
                float prob = score.getComponentGamma()[i];
                buffer.logAccumulate(prob -= this.currentLogLikelihood, i, this.logMath);
                ++i;
            }
        }
    }

    private void accumulateStateTransition(int indexScore, TrainerScore[] score, TrainerScore[] nextScore) {
        HMMState state = score[indexScore].getState();
        if (state == null) {
            return;
        }
        int indexState = state.getState();
        SenoneHMM hmm = (SenoneHMM)state.getHMM();
        float[][] matrix = hmm.getTransitionMatrix();
        int indexMatrix = this.indexMap.get(matrix);
        Buffer[] bufferArray = this.matrixBufferPool.get(indexMatrix);
        float[] vector = matrix[indexState];
        int i = 0;
        while (i < vector.length) {
            if (vector[i] != -3.4028235E38f) {
                int dist = i - indexState;
                int indexNextScore = indexScore + dist;
                assert (nextScore[indexNextScore].getState() == null || nextScore[indexNextScore].getState().getHMM() == hmm);
                float alpha = score[indexScore].getAlpha();
                float beta = nextScore[indexNextScore].getBeta();
                float transitionProb = vector[i];
                float outputProb = nextScore[indexNextScore].getScore();
                float prob = alpha + beta + transitionProb + outputProb;
                bufferArray[indexState].logAccumulate(prob -= this.currentLogLikelihood, i, this.logMath);
            }
            ++i;
        }
    }

    private void accumulateStateTransition(int indexState, SenoneHMM hmm, float value) {
        float[][] matrix = hmm.getTransitionMatrix();
        float[] stateVector = matrix[indexState];
        int indexMatrix = this.indexMap.get(matrix);
        Buffer[] bufferArray = this.matrixBufferPool.get(indexMatrix);
        int i = 0;
        while (i < stateVector.length) {
            if (stateVector[i] != -3.4028235E38f) {
                bufferArray[indexState].logAccumulate(value, i, this.logMath);
            }
            ++i;
        }
    }

    private void accumulateTransition(int indexHmm, int indexScore, TrainerScore[] score, TrainerScore[] nextScore) {
        if (indexHmm == -1) {
            for (HMM hmm : this.hmmManager) {
                int j = 0;
                while (j < hmm.getOrder()) {
                    this.accumulateStateTransition(j, (SenoneHMM)hmm, score[indexScore].getScore());
                    ++j;
                }
            }
        } else if (nextScore != null) {
            this.accumulateStateTransition(indexScore, score, nextScore);
        }
    }

    protected void updateLogLikelihood() {
    }

    protected float normalize() {
        this.normalizePool(this.meansBufferPool);
        this.normalizePool(this.varianceBufferPool);
        this.logNormalizePool(this.mixtureWeightsBufferPool);
        this.logNormalize2DPool(this.matrixBufferPool, this.matrixPool);
        return this.logLikelihood;
    }

    private void normalizePool(Pool<Buffer> pool) {
        assert (pool != null);
        int i = 0;
        while (i < pool.size()) {
            Buffer buffer = pool.get(i);
            if (buffer.wasUsed()) {
                buffer.normalize();
            }
            ++i;
        }
    }

    private void logNormalizePool(Pool<Buffer> pool) {
        assert (pool != null);
        int i = 0;
        while (i < pool.size()) {
            Buffer buffer = pool.get(i);
            if (buffer.wasUsed()) {
                buffer.logNormalize();
            }
            ++i;
        }
    }

    private void logNormalize2DPool(Pool<Buffer[]> pool, Pool<float[][]> maskPool) {
        assert (pool != null);
        int i = 0;
        while (i < pool.size()) {
            Buffer[] bufferArray = pool.get(i);
            float[][] mask = maskPool.get(i);
            int j = 0;
            while (j < bufferArray.length) {
                if (bufferArray[j].wasUsed()) {
                    bufferArray[j].logNormalizeNonZero(mask[j]);
                }
                ++j;
            }
            ++i;
        }
    }

    protected void update() {
        this.updateMeans();
        this.updateVariances();
        this.recomputeMixtureComponents();
        this.updateMixtureWeights();
        this.updateTransitionMatrices();
    }

    private void copyVector(float[] in, float[] out) {
        assert (in.length == out.length);
        System.arraycopy(in, 0, out, 0, in.length);
    }

    private void updateMeans() {
        assert (this.meansPool.size() == this.meansBufferPool.size());
        int i = 0;
        while (i < this.meansPool.size()) {
            float[] means = this.meansPool.get(i);
            Buffer buffer = this.meansBufferPool.get(i);
            if (buffer.wasUsed()) {
                float[] meansBuffer = buffer.getValues();
                this.copyVector(meansBuffer, means);
            } else {
                logger.info("Senone " + i + " not used.");
            }
            ++i;
        }
    }

    private void updateVariances() {
        assert (this.variancePool.size() == this.varianceBufferPool.size());
        int i = 0;
        while (i < this.variancePool.size()) {
            float[] means = this.meansPool.get(i);
            float[] variance = this.variancePool.get(i);
            Buffer buffer = this.varianceBufferPool.get(i);
            if (buffer.wasUsed()) {
                float[] varianceBuffer = buffer.getValues();
                assert (means.length == varianceBuffer.length);
                int j = 0;
                while (j < means.length) {
                    int n = j;
                    varianceBuffer[n] = varianceBuffer[n] - means[j] * means[j];
                    if (varianceBuffer[j] < this.varianceFloor) {
                        varianceBuffer[j] = this.varianceFloor;
                    }
                    ++j;
                }
                this.copyVector(varianceBuffer, variance);
            }
            ++i;
        }
    }

    private void recomputeMixtureComponents() {
        int i = 0;
        while (i < this.senonePool.size()) {
            MixtureComponent[] mixComponent;
            GaussianMixture gMix = (GaussianMixture)this.senonePool.get(i);
            MixtureComponent[] mixtureComponentArray = mixComponent = gMix.getMixtureComponents();
            int n = mixComponent.length;
            int n2 = 0;
            while (n2 < n) {
                MixtureComponent component = mixtureComponentArray[n2];
                component.precomputeDistance();
                ++n2;
            }
            ++i;
        }
    }

    private void updateMixtureWeights() {
        int statesNum = this.mixtureWeights.getStatesNum();
        int streamsNum = this.mixtureWeights.getStreamsNum();
        assert (statesNum * streamsNum == this.mixtureWeightsBufferPool.size());
        int i = 0;
        while (i < streamsNum) {
            int j = 0;
            while (j < statesNum) {
                int id = i * statesNum + j;
                Buffer buffer = this.mixtureWeightsBufferPool.get(id);
                if (buffer.wasUsed()) {
                    if (buffer.logFloor(this.logMixtureWeightFloor)) {
                        buffer.logNormalizeToSum(this.logMath);
                    }
                    float[] mixtureWeightsBuffer = buffer.getValues();
                    this.mixtureWeights.put(j, i, mixtureWeightsBuffer);
                }
                ++j;
            }
            ++i;
        }
    }

    private void updateTransitionMatrices() {
        assert (this.matrixPool.size() == this.matrixBufferPool.size());
        int i = 0;
        while (i < this.matrixPool.size()) {
            float[][] matrix = this.matrixPool.get(i);
            Buffer[] bufferArray = this.matrixBufferPool.get(i);
            int j = 0;
            while (j < matrix.length) {
                Buffer buffer = bufferArray[j];
                if (buffer.wasUsed()) {
                    int k = 0;
                    while (k < matrix[j].length) {
                        float bufferValue = buffer.getValue(k);
                        if (bufferValue != -3.4028235E38f) {
                            assert (matrix[j][k] != -3.4028235E38f);
                            if (bufferValue < this.logTransitionProbabilityFloor) {
                                buffer.setValue(k, this.logTransitionProbabilityFloor);
                            }
                        }
                        ++k;
                    }
                    buffer.logNormalizeToSum(this.logMath);
                    this.copyVector(buffer.getValues(), matrix[j]);
                }
                ++j;
            }
            ++i;
        }
    }
}

