/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.linguist.acoustic.tiedstate.tiedmixture;

import edu.cmu.sphinx.frontend.Data;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.GaussianMixture;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.GaussianWeights;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.MixtureComponent;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.tiedmixture.MixtureComponentSet;

public class SetBasedGaussianMixture
extends GaussianMixture {
    private MixtureComponentSet mixtureComponentSet;

    public SetBasedGaussianMixture(GaussianWeights mixtureWeights, MixtureComponentSet mixtureComponentSet, int id) {
        super(mixtureWeights, null, id);
        this.mixtureComponentSet = mixtureComponentSet;
    }

    @Override
    public float calculateScore(Data feature) {
        this.mixtureComponentSet.updateTopScores(feature);
        float ascore = 0.0f;
        int i = 0;
        while (i < this.mixtureWeights.getStreamsNum()) {
            float logTotal = -3.4028235E38f;
            int j = 0;
            while (j < this.mixtureComponentSet.getTopGauNum()) {
                float gauScore = this.mixtureComponentSet.getTopGauScore(i, j);
                int gauId = this.mixtureComponentSet.getTopGauId(i, j);
                logTotal = this.logMath.addAsLinear(logTotal, gauScore + this.mixtureWeights.get(this.id, i, gauId));
                ++j;
            }
            ascore += logTotal;
            ++i;
        }
        return ascore;
    }

    @Override
    public float[] calculateComponentScore(Data feature) {
        this.mixtureComponentSet.updateScores(feature);
        float[] scores = new float[this.mixtureComponentSet.size()];
        int scoreIdx = 0;
        int i = 0;
        while (i < this.mixtureWeights.getStreamsNum()) {
            int j = 0;
            while (j < this.mixtureComponentSet.getGauNum()) {
                scores[scoreIdx++] = this.mixtureComponentSet.getGauScore(i, j) + this.mixtureWeights.get(this.id, i, this.mixtureComponentSet.getGauId(i, j));
                ++j;
            }
            ++i;
        }
        return scores;
    }

    @Override
    public MixtureComponent[] getMixtureComponents() {
        return this.mixtureComponentSet.toArray();
    }

    @Override
    public int dimension() {
        return this.mixtureComponentSet.dimension();
    }

    @Override
    public int numComponents() {
        return this.mixtureComponentSet.size();
    }
}

