/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.linguist.acoustic.tiedstate.kaldi;

import edu.cmu.sphinx.linguist.acoustic.tiedstate.kaldi.HmmState;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.kaldi.KaldiTextParser;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.kaldi.Triple;
import edu.cmu.sphinx.util.LogMath;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TransitionModel {
    private Map<Integer, List<HmmState>> phoneStates;
    private Map<Triple, Integer> transitionStates;
    private float[] logProbabilities;

    public TransitionModel(KaldiTextParser parser) {
        parser.expectToken("<TransitionModel>");
        this.parseTopology(parser);
        parser.expectToken("<Triples>");
        this.transitionStates = new HashMap<Triple, Integer>();
        int numTriples = parser.getInt();
        int transitionId = 1;
        int i = 0;
        while (i < numTriples) {
            int phone = parser.getInt();
            int hmmState = parser.getInt();
            int pdf = parser.getInt();
            Triple triple = new Triple(phone, hmmState, pdf);
            this.transitionStates.put(triple, transitionId);
            transitionId += this.phoneStates.get(phone).get(hmmState).getTransitions().size();
            ++i;
        }
        parser.expectToken("</Triples>");
        parser.expectToken("<LogProbs>");
        this.logProbabilities = parser.getFloatArray();
        parser.expectToken("</LogProbs>");
        parser.expectToken("</TransitionModel>");
        LogMath logMath = LogMath.getLogMath();
        int i2 = 0;
        while (i2 < this.logProbabilities.length) {
            this.logProbabilities[i2] = logMath.lnToLog(this.logProbabilities[i2]);
            ++i2;
        }
    }

    private void parseTopology(KaldiTextParser parser) {
        String token;
        parser.expectToken("<Topology>");
        this.phoneStates = new HashMap<Integer, List<HmmState>>();
        while ("<TopologyEntry>".equals(token = parser.getToken())) {
            parser.assertToken("<TopologyEntry>", token);
            parser.expectToken("<ForPhones>");
            ArrayList<Integer> phones = new ArrayList<Integer>();
            while (!"</ForPhones>".equals(token = parser.getToken())) {
                phones.add(Integer.parseInt(token));
            }
            ArrayList<HmmState> states = new ArrayList<HmmState>(3);
            while ("<State>".equals(token = parser.getToken())) {
                int id = parser.getInt();
                token = parser.getToken();
                if (!"<PdfClass>".equals(token)) continue;
                int pdfClass = parser.getInt();
                ArrayList<Integer> transitions = new ArrayList<Integer>();
                while ("<Transition>".equals(token = parser.getToken())) {
                    transitions.add(parser.getInt());
                    parser.getToken();
                }
                parser.assertToken("</State>", token);
                states.add(new HmmState(id, pdfClass, transitions));
            }
            for (Integer id : phones) {
                this.phoneStates.put(id, states);
            }
        }
        parser.assertToken("</Topology>", token);
    }

    public float[][] getTransitionMatrix(int phone, int[] pdfs) {
        float[][] transitionMatrix = new float[4][4];
        Arrays.fill(transitionMatrix[3], -3.4028235E38f);
        for (HmmState state : this.phoneStates.get(phone)) {
            int stateId = state.getId();
            Arrays.fill(transitionMatrix[stateId], -3.4028235E38f);
            Triple triple = new Triple(phone, stateId, pdfs[stateId]);
            int i = this.transitionStates.get(triple);
            for (Integer j : state.getTransitions()) {
                transitionMatrix[stateId][j.intValue()] = this.logProbabilities[i++];
            }
        }
        return transitionMatrix;
    }
}

