/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.linguist.acoustic.tiedstate.kaldi;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.InputMismatchException;
import java.util.List;
import java.util.Scanner;

public class KaldiTextParser {
    private final Scanner scanner;

    public KaldiTextParser(String path) throws IOException, MalformedURLException {
        File modelFile = new File(path, "final.mdl");
        InputStream modelStream = new URL(modelFile.getPath()).openStream();
        File treeFile = new File(path, "tree");
        InputStream treeStream = new URL(treeFile.getPath()).openStream();
        SequenceInputStream stream = new SequenceInputStream(modelStream, treeStream);
        this.scanner = new Scanner(stream);
    }

    public String getToken() {
        return this.scanner.next();
    }

    public int getInt() {
        return this.scanner.nextInt();
    }

    public float parseFloat() {
        return this.scanner.nextFloat();
    }

    public int[] getIntArray() {
        ArrayList<Integer> ints = new ArrayList<Integer>();
        for (String token : this.getTokenList("[", "]")) {
            ints.add(Integer.parseInt(token));
        }
        int[] result = new int[ints.size()];
        int i = 0;
        while (i < result.length) {
            result[i] = (Integer)ints.get(i);
            ++i;
        }
        return result;
    }

    public float[] getFloatArray() {
        ArrayList<Float> floats = new ArrayList<Float>();
        for (String token : this.getTokenList("[", "]")) {
            floats.add(Float.valueOf(Float.parseFloat(token)));
        }
        float[] result = new float[floats.size()];
        int i = 0;
        while (i < result.length) {
            result[i] = ((Float)floats.get(i)).floatValue();
            ++i;
        }
        return result;
    }

    public List<String> getTokenList(String openToken, String closeToken) {
        String token;
        this.expectToken(openToken);
        ArrayList<String> tokens = new ArrayList<String>();
        while (!closeToken.equals(token = this.scanner.next())) {
            tokens.add(token);
        }
        return tokens;
    }

    public void expectToken(String expected) {
        String actual = this.scanner.next();
        this.assertToken(expected, actual);
    }

    public void assertToken(String expected, String actual) {
        if (actual.equals(expected)) {
            return;
        }
        String msg = String.format("'%s' expected, '%s' got", expected, actual);
        throw new InputMismatchException(msg);
    }
}

