/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.linguist.acoustic.tiedstate.kaldi;

import edu.cmu.sphinx.frontend.Data;
import edu.cmu.sphinx.frontend.FloatData;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.MixtureComponent;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.ScoreCachingSenone;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.kaldi.KaldiTextParser;
import edu.cmu.sphinx.util.LogMath;
import java.util.Arrays;

public class DiagGmm
extends ScoreCachingSenone {
    private int id;
    private float[] gconsts;
    private float[] invVars;
    private float[] meansInvVars;

    public DiagGmm(int id, KaldiTextParser parser) {
        this.id = id;
        parser.expectToken("<DiagGMM>");
        parser.expectToken("<GCONSTS>");
        this.gconsts = parser.getFloatArray();
        parser.expectToken("<WEIGHTS>");
        parser.getFloatArray();
        parser.expectToken("<MEANS_INVVARS>");
        this.meansInvVars = parser.getFloatArray();
        parser.expectToken("<INV_VARS>");
        this.invVars = parser.getFloatArray();
        parser.expectToken("</DiagGMM>");
    }

    public int getId() {
        return this.id;
    }

    @Override
    public float calculateScore(Data data) {
        float logTotal = -3.4028235E38f;
        LogMath logMath = LogMath.getLogMath();
        float[] fArray = this.calculateComponentScore(data);
        int n = fArray.length;
        int n2 = 0;
        while (n2 < n) {
            Float mixtureScore = Float.valueOf(fArray[n2]);
            logTotal = logMath.addAsLinear(logTotal, mixtureScore.floatValue());
            ++n2;
        }
        return logTotal;
    }

    @Override
    public float[] calculateComponentScore(Data data) {
        int dim;
        float[] features = FloatData.toFloatData(data).getValues();
        if (features.length != (dim = this.meansInvVars.length / this.gconsts.length)) {
            String fmt = "feature vector must be of length %d, got %d";
            String msg = String.format(fmt, dim, features.length);
            throw new IllegalArgumentException(msg);
        }
        float[] likelihoods = Arrays.copyOf(this.gconsts, this.gconsts.length);
        int i = 0;
        while (i < likelihoods.length) {
            int j = 0;
            while (j < features.length) {
                int k = i * features.length + j;
                int n = i;
                likelihoods[n] = likelihoods[n] + this.meansInvVars[k] * features[j];
                int n2 = i;
                likelihoods[n2] = likelihoods[n2] - 0.5f * this.invVars[k] * features[j] * features[j];
                ++j;
            }
            likelihoods[i] = LogMath.getLogMath().lnToLog(likelihoods[i]);
            ++i;
        }
        return likelihoods;
    }

    @Override
    public long getID() {
        return this.id;
    }

    @Override
    public void dump(String msg) {
        System.out.format("%s DiagGmm: ID %d\n", msg, this.id);
    }

    @Override
    public MixtureComponent[] getMixtureComponents() {
        return null;
    }

    @Override
    public float[] getLogMixtureWeights() {
        return null;
    }
}

