/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.linguist.acoustic.tiedstate;

import edu.cmu.sphinx.decoder.adaptation.ClusteredDensityFileData;
import edu.cmu.sphinx.decoder.adaptation.Transform;
import edu.cmu.sphinx.linguist.acoustic.HMMPosition;
import edu.cmu.sphinx.linguist.acoustic.LeftRightContext;
import edu.cmu.sphinx.linguist.acoustic.Unit;
import edu.cmu.sphinx.linguist.acoustic.UnitManager;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.GaussianMixture;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.GaussianWeights;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.HMMManager;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.Loader;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.MixtureComponent;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.Pool;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.Senone;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.SenoneHMM;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.SenoneSequence;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.tiedmixture.MixtureComponentSet;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.tiedmixture.PrunableMixtureComponent;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.tiedmixture.SetBasedGaussianMixture;
import edu.cmu.sphinx.util.ExtendedStreamTokenizer;
import edu.cmu.sphinx.util.LogMath;
import edu.cmu.sphinx.util.TimerPool;
import edu.cmu.sphinx.util.Utilities;
import edu.cmu.sphinx.util.props.ConfigurationManagerUtils;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.S4Boolean;
import edu.cmu.sphinx.util.props.S4Component;
import edu.cmu.sphinx.util.props.S4Double;
import edu.cmu.sphinx.util.props.S4Integer;
import edu.cmu.sphinx.util.props.S4String;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Sphinx3Loader
implements Loader {
    @S4Component(type=UnitManager.class)
    public static final String PROP_UNIT_MANAGER = "unitManager";
    @S4String(mandatory=true)
    public static final String PROP_LOCATION = "location";
    @S4Boolean(defaultValue=true)
    public static final String PROP_USE_CD_UNITS = "useCDUnits";
    @S4Double(defaultValue=0.0)
    public static final String PROP_MC_FLOOR = "mixtureComponentScoreFloor";
    @S4Double(defaultValue=9.999999747378752E-5)
    public static final String PROP_VARIANCE_FLOOR = "varianceFloor";
    @S4Double(defaultValue=1.0000000116860974E-7)
    public static final String PROP_MW_FLOOR = "mixtureWeightFloor";
    @S4Integer(defaultValue=4)
    public static final String PROP_TOPN = "topGaussiansNum";
    protected static final String FILLER = "filler";
    protected static final String SILENCE_CIPHONE = "SIL";
    protected static final int BYTE_ORDER_MAGIC = 287454020;
    public static final String MODEL_VERSION = "0.3";
    private static final int CONTEXT_SIZE = 1;
    protected Properties modelProps;
    protected Pool<float[]> meansPool;
    protected Pool<float[]> variancePool;
    protected Pool<float[][]> transitionsPool;
    protected GaussianWeights mixtureWeights;
    private int numStates;
    private int numStreams;
    private int numBase;
    private int numGaussiansPerState;
    private int[] vectorLength;
    private int[] senone2ci;
    protected Pool<float[][]> meanTransformationMatrixPool;
    protected Pool<float[]> meanTransformationVectorPool;
    protected Pool<float[][]> varianceTransformationMatrixPool;
    protected Pool<float[]> varianceTransformationVectorPool;
    protected float[][] transformMatrix;
    private MixtureComponentSet[] phoneticTiedMixtures;
    protected Pool<Senone> senonePool;
    private Map<String, Unit> contextIndependentUnits;
    private HMMManager hmmManager;
    protected LogMath logMath;
    private UnitManager unitManager;
    private boolean swap;
    private static final String DENSITY_FILE_VERSION = "1.0";
    private static final String MIXW_FILE_VERSION = "1.0";
    private static final String TMAT_FILE_VERSION = "1.0";
    private static final String TRANSFORM_FILE_VERSION = "0.1";
    protected Logger logger;
    private URL location;
    protected float distFloor;
    protected float mixtureWeightFloor;
    protected float varianceFloor;
    private int topGauNum;
    protected boolean useCDUnits;
    private boolean loaded;
    private long calculatedCheckSum = 0L;

    public Sphinx3Loader(URL location, UnitManager unitManager, float distFloor, float mixtureWeightFloor, float varianceFloor, int topGauNum, boolean useCDUnits) {
        this.init(location, unitManager, distFloor, mixtureWeightFloor, varianceFloor, topGauNum, useCDUnits, Logger.getLogger(this.getClass().getName()));
    }

    public Sphinx3Loader(String location, UnitManager unitManager, float distFloor, float mixtureWeightFloor, float varianceFloor, int topGauNum, boolean useCDUnits) throws MalformedURLException, ClassNotFoundException {
        this.init(ConfigurationManagerUtils.resourceToURL(location), unitManager, distFloor, mixtureWeightFloor, varianceFloor, topGauNum, useCDUnits, Logger.getLogger(this.getClass().getName()));
    }

    protected void init(URL location, UnitManager unitManager, float distFloor, float mixtureWeightFloor, float varianceFloor, int topGauNum, boolean useCDUnits, Logger logger) {
        this.logMath = LogMath.getLogMath();
        this.location = location;
        this.logger = logger;
        this.unitManager = unitManager;
        this.distFloor = distFloor;
        this.mixtureWeightFloor = mixtureWeightFloor;
        this.varianceFloor = varianceFloor;
        this.topGauNum = topGauNum;
        this.useCDUnits = useCDUnits;
    }

    public Sphinx3Loader() {
    }

    public int getNumStates() {
        return this.numStates;
    }

    public int getNumStreams() {
        return this.numStreams;
    }

    public int getNumGaussiansPerState() {
        return this.numGaussiansPerState;
    }

    public int[] getVectorLength() {
        return this.vectorLength;
    }

    public int[] getSenone2Ci() {
        return this.senone2ci;
    }

    public String getLocation() {
        return this.location.getPath();
    }

    public boolean hasTiedMixtures() {
        String modelType = this.modelProps.getProperty("-model", "cont");
        return modelType.equals("ptm");
    }

    @Override
    public void newProperties(PropertySheet ps) throws PropertyException {
        this.init(ConfigurationManagerUtils.getResource(PROP_LOCATION, ps), (UnitManager)ps.getComponent(PROP_UNIT_MANAGER), ps.getFloat(PROP_MC_FLOOR), ps.getFloat(PROP_MW_FLOOR), ps.getFloat(PROP_VARIANCE_FLOOR), ps.getInt(PROP_TOPN), ps.getBoolean(PROP_USE_CD_UNITS), ps.getLogger());
    }

    protected InputStream getDataStream(String path) throws IOException, URISyntaxException {
        return new URL(Utilities.pathJoin(this.location.toString(), path)).openStream();
    }

    @Override
    public void load() throws IOException {
        if (!this.loaded) {
            TimerPool.getTimer(this, "Load AM").start();
            this.hmmManager = new HMMManager();
            this.contextIndependentUnits = new LinkedHashMap<String, Unit>();
            this.meanTransformationMatrixPool = null;
            this.meanTransformationVectorPool = null;
            this.varianceTransformationMatrixPool = null;
            this.varianceTransformationVectorPool = null;
            this.transformMatrix = null;
            try {
                this.loadModelFiles();
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
            this.loaded = true;
            TimerPool.getTimer(this, "Load AM").stop();
        }
    }

    protected HMMManager getHmmManager() {
        return this.hmmManager;
    }

    protected Pool<float[][]> getMatrixPool() {
        return this.transitionsPool;
    }

    protected GaussianWeights getMixtureWeightsPool() {
        return this.mixtureWeights;
    }

    protected void loadModelFiles() throws IOException, URISyntaxException {
        this.meansPool = this.loadDensityFile("means", -3.4028235E38f);
        this.variancePool = this.loadDensityFile("variances", this.varianceFloor);
        this.mixtureWeights = this.loadMixtureWeights("mixture_weights", this.mixtureWeightFloor);
        this.transitionsPool = this.loadTransitionMatrices("transition_matrices");
        this.transformMatrix = this.loadTransformMatrix("feature_transform");
        this.modelProps = this.loadModelProps("feat.params");
        if (this.hasTiedMixtures()) {
            this.getSenoneToCIPhone();
            this.senonePool = this.createTiedSenonePool(this.distFloor, this.varianceFloor);
        } else {
            this.senonePool = this.createSenonePool(this.distFloor, this.varianceFloor);
        }
        InputStream modelStream = this.getDataStream("mdef");
        if (modelStream == null) {
            throw new IOException("can't find model definition");
        }
        this.loadHMMPool(this.useCDUnits, modelStream);
    }

    @Override
    public Map<String, Unit> getContextIndependentUnits() {
        return this.contextIndependentUnits;
    }

    private void getSenoneToCIPhone() throws IOException, URISyntaxException {
        InputStream inputStream = this.getDataStream("mdef");
        if (inputStream == null) {
            throw new IOException("can't find model definition");
        }
        ExtendedStreamTokenizer est = new ExtendedStreamTokenizer(inputStream, 35, false);
        this.logger.fine("Loading HMM file from " + this.location);
        est.expectString(MODEL_VERSION);
        this.numBase = est.getInt("numBase");
        est.expectString("n_base");
        int numTri = est.getInt("numTri");
        est.expectString("n_tri");
        int numStateMap = est.getInt("numStateMap");
        est.expectString("n_state_map");
        int numTiedState = est.getInt("numTiedState");
        est.expectString("n_tied_state");
        this.senone2ci = new int[numTiedState];
        est.getInt("numContextIndependentTiedState");
        est.expectString("n_tied_ci_state");
        int numTiedTransitionMatrices = est.getInt("numTiedTransitionMatrices");
        est.expectString("n_tied_tmat");
        int numStatePerHMM = numStateMap / (numTri + this.numBase);
        assert (numTiedState == this.mixtureWeights.getStatesNum());
        assert (numTiedTransitionMatrices == this.transitionsPool.size());
        int i = 0;
        while (i < this.numBase + numTri) {
            int j = 0;
            while (j < 5) {
                est.getString();
                ++j;
            }
            int tmat = est.getInt("tmat");
            int j2 = 0;
            while (j2 < numStatePerHMM - 1) {
                this.senone2ci[est.getInt((String)"j")] = tmat;
                ++j2;
            }
            est.expectString("N");
            assert (tmat < numTiedTransitionMatrices);
            ++i;
        }
        est.close();
    }

    protected Pool<Senone> createSenonePool(float distFloor, float varianceFloor) {
        Pool<Senone> pool = new Pool<Senone>("senones");
        int numMeans = this.meansPool.size();
        int numVariances = this.variancePool.size();
        int numGaussiansPerSenone = this.mixtureWeights.getGauPerState();
        int numSenones = this.mixtureWeights.getStatesNum();
        int numStreams = this.mixtureWeights.getStreamsNum();
        int whichGaussian = 0;
        this.logger.fine("Senones " + numSenones);
        this.logger.fine("Gaussians Per Senone " + numGaussiansPerSenone);
        this.logger.fine("Means " + numMeans);
        this.logger.fine("Variances " + numVariances);
        assert (numGaussiansPerSenone > 0);
        assert (numVariances == numSenones * numGaussiansPerSenone);
        assert (numMeans == numSenones * numGaussiansPerSenone);
        float[][] meansTransformationMatrix = this.meanTransformationMatrixPool == null ? null : this.meanTransformationMatrixPool.get(0);
        float[] meansTransformationVector = this.meanTransformationVectorPool == null ? null : this.meanTransformationVectorPool.get(0);
        float[][] varianceTransformationMatrix = this.varianceTransformationMatrixPool == null ? null : this.varianceTransformationMatrixPool.get(0);
        float[] varianceTransformationVector = this.varianceTransformationVectorPool == null ? null : this.varianceTransformationVectorPool.get(0);
        int i = 0;
        while (i < numSenones) {
            MixtureComponent[] mixtureComponents = new MixtureComponent[numGaussiansPerSenone * numStreams];
            int j = 0;
            while (j < numGaussiansPerSenone) {
                mixtureComponents[j] = new MixtureComponent(this.meansPool.get(whichGaussian), meansTransformationMatrix, meansTransformationVector, this.variancePool.get(whichGaussian), varianceTransformationMatrix, varianceTransformationVector, distFloor, varianceFloor);
                ++whichGaussian;
                ++j;
            }
            GaussianMixture senone = new GaussianMixture(this.mixtureWeights, mixtureComponents, i);
            pool.put(i, senone);
            ++i;
        }
        return pool;
    }

    private Pool<Senone> createTiedSenonePool(float distFloor, float varianceFloor) {
        Pool<Senone> pool = new Pool<Senone>("senones");
        int numMeans = this.meansPool.size();
        int numVariances = this.variancePool.size();
        int numGaussiansPerState = this.mixtureWeights.getGauPerState();
        int numSenones = this.mixtureWeights.getStatesNum();
        int numStreams = this.mixtureWeights.getStreamsNum();
        this.logger.fine("Senones " + numSenones);
        this.logger.fine("Gaussians Per State " + numGaussiansPerState);
        this.logger.fine("Means " + numMeans);
        this.logger.fine("Variances " + numVariances);
        assert (numGaussiansPerState > 0);
        assert (numVariances == this.numBase * numGaussiansPerState * numStreams);
        assert (numMeans == this.numBase * numGaussiansPerState * numStreams);
        float[][] meansTransformationMatrix = this.meanTransformationMatrixPool == null ? null : this.meanTransformationMatrixPool.get(0);
        float[] meansTransformationVector = this.meanTransformationVectorPool == null ? null : this.meanTransformationVectorPool.get(0);
        float[][] varianceTransformationMatrix = this.varianceTransformationMatrixPool == null ? null : this.varianceTransformationMatrixPool.get(0);
        float[] varianceTransformationVector = this.varianceTransformationVectorPool == null ? null : this.varianceTransformationVectorPool.get(0);
        this.phoneticTiedMixtures = new MixtureComponentSet[this.numBase];
        int i = 0;
        while (i < this.numBase) {
            ArrayList<PrunableMixtureComponent[]> mixtureComponents = new ArrayList<PrunableMixtureComponent[]>();
            int j = 0;
            while (j < numStreams) {
                PrunableMixtureComponent[] featMixtureComponents = new PrunableMixtureComponent[numGaussiansPerState];
                int k = 0;
                while (k < numGaussiansPerState) {
                    int whichGaussian = i * numGaussiansPerState * numStreams + j * numGaussiansPerState + k;
                    featMixtureComponents[k] = new PrunableMixtureComponent(this.meansPool.get(whichGaussian), meansTransformationMatrix, meansTransformationVector, this.variancePool.get(whichGaussian), varianceTransformationMatrix, varianceTransformationVector, distFloor, varianceFloor, k);
                    ++k;
                }
                mixtureComponents.add(featMixtureComponents);
                ++j;
            }
            this.phoneticTiedMixtures[i] = new MixtureComponentSet(mixtureComponents, this.topGauNum);
            ++i;
        }
        i = 0;
        while (i < numSenones) {
            SetBasedGaussianMixture senone = new SetBasedGaussianMixture(this.mixtureWeights, this.phoneticTiedMixtures[this.senone2ci[i]], i);
            pool.put(i, senone);
            ++i;
        }
        return pool;
    }

    public Pool<float[]> loadDensityFile(String path, float floor) throws IOException, URISyntaxException {
        Properties props = new Properties();
        int blockSize = 0;
        DataInputStream dis = this.readS3BinaryHeader(path, props);
        String version = props.getProperty("version");
        if (version == null || !version.equals("1.0")) {
            throw new IOException("Unsupported version in " + path);
        }
        String checksum = props.getProperty("chksum0");
        boolean doCheckSum = checksum != null && checksum.equals("yes");
        this.resetChecksum();
        int numStates = this.readInt(dis);
        int numStreams = this.readInt(dis);
        int numGaussiansPerState = this.readInt(dis);
        int[] vectorLength = new int[numStreams];
        int i = 0;
        while (i < numStreams) {
            vectorLength[i] = this.readInt(dis);
            ++i;
        }
        int rawLength = this.readInt(dis);
        this.logger.fine("Number of states " + numStates);
        this.logger.fine("Number of streams " + numStreams);
        this.logger.fine("Number of gaussians per state " + numGaussiansPerState);
        this.logger.fine("Vector length " + vectorLength.length);
        this.logger.fine("Raw length " + rawLength);
        int i2 = 0;
        while (i2 < numStreams) {
            blockSize += vectorLength[i2];
            ++i2;
        }
        assert (rawLength == numGaussiansPerState * blockSize * numStates);
        Pool<float[]> pool = new Pool<float[]>(path);
        pool.setFeature(Pool.Feature.NUM_SENONES, numStates);
        pool.setFeature(Pool.Feature.NUM_STREAMS, numStreams);
        pool.setFeature(Pool.Feature.NUM_GAUSSIANS_PER_STATE, numGaussiansPerState);
        int i3 = 0;
        while (i3 < numStates) {
            int j = 0;
            while (j < numStreams) {
                int k = 0;
                while (k < numGaussiansPerState) {
                    float[] density = this.readFloatArray(dis, vectorLength[j]);
                    Utilities.floorData(density, floor);
                    pool.put(i3 * numStreams * numGaussiansPerState + j * numGaussiansPerState + k, density);
                    ++k;
                }
                ++j;
            }
            ++i3;
        }
        this.validateChecksum(dis, doCheckSum);
        dis.close();
        this.numStates = numStates;
        this.numStreams = numStreams;
        this.numGaussiansPerState = numGaussiansPerState;
        this.vectorLength = vectorLength;
        return pool;
    }

    /*
     * Unable to fully structure code
     */
    public DataInputStream readS3BinaryHeader(String path, Properties props) throws IOException, URISyntaxException {
        inputStream = this.getDataStream(path);
        if (inputStream == null) {
            throw new IOException("Can't open " + path);
        }
        dis = new DataInputStream(new BufferedInputStream(inputStream));
        id = this.readWord(dis);
        if (id.equals("s3")) ** GOTO lbl12
        throw new IOException("Not proper s3 binary file " + path);
        while (!name.equals("endhdr")) {
            value = this.readWord(dis);
            props.setProperty(name, value);
lbl12:
            // 2 sources

            if ((name = this.readWord(dis)) != null) continue;
        }
        if ((byteOrderMagic = dis.readInt()) == 287454020) {
            this.logger.fine("Not swapping " + path);
            this.swap = false;
        } else if (Utilities.swapInteger(byteOrderMagic) == 287454020) {
            this.logger.fine("Swapping  " + path);
            this.swap = true;
        } else {
            throw new IOException("Corrupted S3 file " + path);
        }
        return dis;
    }

    String readWord(DataInputStream dis) throws IOException {
        char c;
        StringBuilder sb = new StringBuilder();
        while (Character.isWhitespace(c = this.readChar(dis))) {
        }
        do {
            sb.append(c);
        } while (!Character.isWhitespace(c = this.readChar(dis)));
        return sb.toString();
    }

    private char readChar(DataInputStream dis) throws IOException {
        return (char)dis.readByte();
    }

    private void resetChecksum() {
        this.calculatedCheckSum = 0L;
    }

    private void validateChecksum(DataInputStream dis, boolean doCheckSum) throws IOException {
        if (!doCheckSum) {
            return;
        }
        int oldCheckSum = (int)this.calculatedCheckSum;
        int checkSum = this.readInt(dis);
        if (checkSum != oldCheckSum) {
            throw new IOException("Invalid checksum " + Long.toHexString(this.calculatedCheckSum) + " must be " + Integer.toHexString(checkSum));
        }
    }

    public int readInt(DataInputStream dis) throws IOException {
        int val = this.swap ? Utilities.readLittleEndianInt(dis) : dis.readInt();
        this.calculatedCheckSum = (this.calculatedCheckSum << 20 | this.calculatedCheckSum >> 12) + (long)val & 0xFFFFFFFFL;
        return val;
    }

    public float readFloat(DataInputStream dis) throws IOException {
        int val = this.swap ? Utilities.readLittleEndianInt(dis) : dis.readInt();
        this.calculatedCheckSum = (this.calculatedCheckSum << 20 | this.calculatedCheckSum >> 12) + (long)val & 0xFFFFFFFFL;
        return Float.intBitsToFloat(val);
    }

    public float[] readFloatArray(DataInputStream dis, int size) throws IOException {
        float[] data = new float[size];
        int i = 0;
        while (i < size) {
            data[i] = this.readFloat(dis);
            ++i;
        }
        return data;
    }

    protected void loadHMMPool(boolean useCDUnits, InputStream inputStream) throws IOException {
        ExtendedStreamTokenizer est = new ExtendedStreamTokenizer(inputStream, 35, false);
        this.logger.fine("Loading HMM file from: " + this.location);
        est.expectString(MODEL_VERSION);
        int numBase = est.getInt("numBase");
        est.expectString("n_base");
        int numTri = est.getInt("numTri");
        est.expectString("n_tri");
        int numStateMap = est.getInt("numStateMap");
        est.expectString("n_state_map");
        int numTiedState = est.getInt("numTiedState");
        est.expectString("n_tied_state");
        int numContextIndependentTiedState = est.getInt("numContextIndependentTiedState");
        est.expectString("n_tied_ci_state");
        int numTiedTransitionMatrices = est.getInt("numTiedTransitionMatrices");
        est.expectString("n_tied_tmat");
        int numStatePerHMM = numStateMap / (numTri + numBase);
        assert (numTiedState == this.mixtureWeights.getStatesNum());
        assert (numTiedTransitionMatrices == this.transitionsPool.size());
        int i = 0;
        while (i < numBase) {
            String name = est.getString();
            String left = est.getString();
            String right = est.getString();
            String position = est.getString();
            String attribute = est.getString();
            int tmat = est.getInt("tmat");
            int[] stid = new int[numStatePerHMM - 1];
            int j = 0;
            while (j < numStatePerHMM - 1) {
                stid[j] = est.getInt("j");
                assert (stid[j] >= 0 && stid[j] < numContextIndependentTiedState);
                ++j;
            }
            est.expectString("N");
            assert (left.equals("-"));
            assert (right.equals("-"));
            assert (position.equals("-"));
            assert (tmat < numTiedTransitionMatrices);
            Unit unit = this.unitManager.getUnit(name, attribute.equals(FILLER));
            this.contextIndependentUnits.put(unit.getName(), unit);
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("Loaded " + unit);
            }
            if (unit.isFiller() && unit.getName().equals(SILENCE_CIPHONE)) {
                unit = UnitManager.SILENCE;
            }
            float[][] transitionMatrix = this.transitionsPool.get(tmat);
            SenoneSequence ss = this.getSenoneSequence(stid);
            SenoneHMM hmm = new SenoneHMM(unit, ss, transitionMatrix, HMMPosition.lookup(position));
            this.hmmManager.put(hmm);
            ++i;
        }
        if (this.hmmManager.get(HMMPosition.UNDEFINED, UnitManager.SILENCE) == null) {
            throw new IOException("Could not find SIL unit in acoustic model");
        }
        String lastUnitName = "";
        Unit lastUnit = null;
        int[] lastStid = null;
        SenoneSequence lastSenoneSequence = null;
        int i2 = 0;
        while (i2 < numTri) {
            String name = est.getString();
            String left = est.getString();
            String right = est.getString();
            String position = est.getString();
            String attribute = est.getString();
            int tmat = est.getInt("tmat");
            int[] stid = new int[numStatePerHMM - 1];
            int j = 0;
            while (j < numStatePerHMM - 1) {
                stid[j] = est.getInt("j");
                assert (stid[j] >= numContextIndependentTiedState && stid[j] < numTiedState);
                ++j;
            }
            est.expectString("N");
            assert (!left.equals("-"));
            assert (!right.equals("-"));
            assert (!position.equals("-"));
            assert (attribute.equals("n/a"));
            assert (tmat < numTiedTransitionMatrices);
            if (useCDUnits) {
                Unit unit;
                String unitName = String.valueOf(name) + ' ' + left + ' ' + right;
                if (unitName.equals(lastUnitName)) {
                    unit = lastUnit;
                } else {
                    Unit[] leftContext = new Unit[]{this.contextIndependentUnits.get(left)};
                    Unit[] rightContext = new Unit[]{this.contextIndependentUnits.get(right)};
                    LeftRightContext context = LeftRightContext.get(leftContext, rightContext);
                    unit = this.unitManager.getUnit(name, false, context);
                }
                lastUnitName = unitName;
                lastUnit = unit;
                if (this.logger.isLoggable(Level.FINE)) {
                    this.logger.fine("Loaded " + unit);
                }
                float[][] transitionMatrix = this.transitionsPool.get(tmat);
                SenoneSequence ss = lastSenoneSequence;
                if (ss == null || !this.sameSenoneSequence(stid, lastStid)) {
                    ss = this.getSenoneSequence(stid);
                }
                lastSenoneSequence = ss;
                lastStid = stid;
                SenoneHMM hmm = new SenoneHMM(unit, ss, transitionMatrix, HMMPosition.lookup(position));
                this.hmmManager.put(hmm);
            }
            ++i2;
        }
        est.close();
    }

    protected boolean sameSenoneSequence(int[] ssid1, int[] ssid2) {
        if (ssid1.length == ssid2.length) {
            int i = 0;
            while (i < ssid1.length) {
                if (ssid1[i] != ssid2[i]) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    protected SenoneSequence getSenoneSequence(int[] stateid) {
        Senone[] senones = new Senone[stateid.length];
        int i = 0;
        while (i < stateid.length) {
            senones[i] = this.senonePool.get(stateid[i]);
            ++i;
        }
        return new SenoneSequence(senones);
    }

    protected GaussianWeights loadMixtureWeights(String path, float floor) throws IOException, URISyntaxException {
        this.logger.fine("Loading mixture weights from: " + path);
        Properties props = new Properties();
        DataInputStream dis = this.readS3BinaryHeader(path, props);
        String version = props.getProperty("version");
        if (version == null || !version.equals("1.0")) {
            throw new IOException("Unsupported version in " + path);
        }
        String checksum = props.getProperty("chksum0");
        boolean doCheckSum = checksum != null && checksum.equals("yes");
        this.resetChecksum();
        int numStates = this.readInt(dis);
        int numStreams = this.readInt(dis);
        int numGaussiansPerState = this.readInt(dis);
        int numValues = this.readInt(dis);
        GaussianWeights mixtureWeights = new GaussianWeights(path, numStates, numGaussiansPerState, numStreams);
        this.logger.fine("Number of states " + numStates);
        this.logger.fine("Number of streams " + numStreams);
        this.logger.fine("Number of gaussians per state " + numGaussiansPerState);
        assert (numValues == numStates * numStreams * numGaussiansPerState);
        int i = 0;
        while (i < numStates) {
            int j = 0;
            while (j < numStreams) {
                float[] logStreamMixtureWeight = this.readFloatArray(dis, numGaussiansPerState);
                Utilities.normalize(logStreamMixtureWeight);
                Utilities.floorData(logStreamMixtureWeight, floor);
                this.logMath.linearToLog(logStreamMixtureWeight);
                mixtureWeights.put(i, j, logStreamMixtureWeight);
                ++j;
            }
            ++i;
        }
        this.validateChecksum(dis, doCheckSum);
        dis.close();
        return mixtureWeights;
    }

    protected Pool<float[][]> loadTransitionMatrices(String path) throws IOException, URISyntaxException {
        this.logger.fine("Loading transition matrices from: " + path);
        Properties props = new Properties();
        DataInputStream dis = this.readS3BinaryHeader(path, props);
        String version = props.getProperty("version");
        if (version == null || !version.equals("1.0")) {
            throw new IOException("Unsupported version in " + path);
        }
        String checksum = props.getProperty("chksum0");
        boolean doCheckSum = checksum != null && checksum.equals("yes");
        this.resetChecksum();
        Pool<float[][]> pool = new Pool<float[][]>(path);
        int numMatrices = this.readInt(dis);
        int numRows = this.readInt(dis);
        int numStates = this.readInt(dis);
        int numValues = this.readInt(dis);
        assert (numValues == numStates * numRows * numMatrices);
        int i = 0;
        while (i < numMatrices) {
            float[][] tmat = new float[numStates][];
            tmat[numStates - 1] = new float[numStates];
            this.logMath.linearToLog(tmat[numStates - 1]);
            int j = 0;
            while (j < numRows) {
                tmat[j] = this.readFloatArray(dis, numStates);
                Utilities.nonZeroFloor(tmat[j], 0.0f);
                Utilities.normalize(tmat[j]);
                this.logMath.linearToLog(tmat[j]);
                ++j;
            }
            pool.put(i, tmat);
            ++i;
        }
        this.validateChecksum(dis, doCheckSum);
        dis.close();
        return pool;
    }

    protected float[][] loadTransformMatrix(String path) throws IOException {
        DataInputStream dis;
        this.logger.fine("Loading transform matrix from: " + path);
        Properties props = new Properties();
        try {
            dis = this.readS3BinaryHeader(path, props);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            return null;
        }
        String version = props.getProperty("version");
        if (version == null || !version.equals(TRANSFORM_FILE_VERSION)) {
            throw new IOException("Unsupported version in " + path);
        }
        String checksum = props.getProperty("chksum0");
        boolean doCheckSum = checksum != null && checksum.equals("yes");
        this.resetChecksum();
        this.readInt(dis);
        int numRows = this.readInt(dis);
        int numValues = this.readInt(dis);
        int num = this.readInt(dis);
        assert (num == numRows * numValues);
        float[][] result = new float[numRows][];
        int i = 0;
        while (i < numRows) {
            result[i] = this.readFloatArray(dis, numValues);
            ++i;
        }
        this.validateChecksum(dis, doCheckSum);
        dis.close();
        return result;
    }

    public void clearGauScores() {
        if (this.phoneticTiedMixtures == null) {
            return;
        }
        MixtureComponentSet[] mixtureComponentSetArray = this.phoneticTiedMixtures;
        int n = this.phoneticTiedMixtures.length;
        int n2 = 0;
        while (n2 < n) {
            MixtureComponentSet mixture = mixtureComponentSetArray[n2];
            mixture.clearStoredScores();
            ++n2;
        }
    }

    public void setGauScoresQueueLength(int scoresQueueLen) {
        if (this.phoneticTiedMixtures == null) {
            return;
        }
        MixtureComponentSet[] mixtureComponentSetArray = this.phoneticTiedMixtures;
        int n = this.phoneticTiedMixtures.length;
        int n2 = 0;
        while (n2 < n) {
            MixtureComponentSet mixture = mixtureComponentSetArray[n2];
            mixture.setScoreQueueLength(scoresQueueLen);
            ++n2;
        }
    }

    @Override
    public Pool<float[]> getMeansPool() {
        return this.meansPool;
    }

    @Override
    public Pool<float[][]> getMeansTransformationMatrixPool() {
        return this.meanTransformationMatrixPool;
    }

    @Override
    public Pool<float[]> getMeansTransformationVectorPool() {
        return this.meanTransformationVectorPool;
    }

    @Override
    public Pool<float[]> getVariancePool() {
        return this.variancePool;
    }

    @Override
    public Pool<float[][]> getVarianceTransformationMatrixPool() {
        return this.varianceTransformationMatrixPool;
    }

    @Override
    public Pool<float[]> getVarianceTransformationVectorPool() {
        return this.varianceTransformationVectorPool;
    }

    @Override
    public GaussianWeights getMixtureWeights() {
        return this.mixtureWeights;
    }

    @Override
    public Pool<float[][]> getTransitionMatrixPool() {
        return this.transitionsPool;
    }

    @Override
    public float[][] getTransformMatrix() {
        return this.transformMatrix;
    }

    @Override
    public Pool<Senone> getSenonePool() {
        return this.senonePool;
    }

    @Override
    public int getLeftContextSize() {
        return 1;
    }

    @Override
    public int getRightContextSize() {
        return 1;
    }

    @Override
    public HMMManager getHMMManager() {
        return this.hmmManager;
    }

    @Override
    public void logInfo() {
        this.logger.info("Loading tied-state acoustic model from: " + this.location);
        this.meansPool.logInfo(this.logger);
        this.variancePool.logInfo(this.logger);
        this.transitionsPool.logInfo(this.logger);
        this.senonePool.logInfo(this.logger);
        if (this.meanTransformationMatrixPool != null) {
            this.meanTransformationMatrixPool.logInfo(this.logger);
        }
        if (this.meanTransformationVectorPool != null) {
            this.meanTransformationVectorPool.logInfo(this.logger);
        }
        if (this.varianceTransformationMatrixPool != null) {
            this.varianceTransformationMatrixPool.logInfo(this.logger);
        }
        if (this.varianceTransformationVectorPool != null) {
            this.varianceTransformationVectorPool.logInfo(this.logger);
        }
        this.mixtureWeights.logInfo(this.logger);
        this.senonePool.logInfo(this.logger);
        this.logger.info("Context Independent Unit Entries: " + this.contextIndependentUnits.size());
        this.hmmManager.logInfo(this.logger);
    }

    @Override
    public Properties getProperties() {
        return this.modelProps;
    }

    protected Properties loadModelProps(String path) throws MalformedURLException, IOException, URISyntaxException {
        String line;
        Properties props = new Properties();
        BufferedReader reader = new BufferedReader(new InputStreamReader(this.getDataStream(path)));
        while ((line = reader.readLine()) != null) {
            String[] tokens = line.split(" ");
            props.put(tokens[0], tokens[1]);
        }
        return props;
    }

    @Override
    public void update(Transform transform, ClusteredDensityFileData clusters) {
        int index = 0;
        while (index < this.meansPool.size()) {
            int transformClass = clusters.getClassIndex(index);
            float[] tmean = new float[this.getVectorLength()[0]];
            float[] mean = this.meansPool.get(index);
            int i = 0;
            while (i < this.numStreams) {
                int l = 0;
                while (l < this.getVectorLength()[i]) {
                    tmean[l] = 0.0f;
                    int m = 0;
                    while (m < this.getVectorLength()[i]) {
                        int n = l;
                        tmean[n] = tmean[n] + transform.getAs()[transformClass][i][l][m] * mean[m];
                        ++m;
                    }
                    int n = l;
                    tmean[n] = tmean[n] + transform.getBs()[transformClass][i][l];
                    ++l;
                }
                System.arraycopy(tmean, 0, mean, 0, tmean.length);
                ++i;
            }
            ++index;
        }
    }
}

