/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.linguist.acoustic.tiedstate;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class Pool<T> {
    private final String name;
    private final List<T> pool;
    private final Map<Feature, Integer> features = new EnumMap<Feature, Integer>(Feature.class);

    public Pool(String name) {
        this.name = name;
        this.pool = new ArrayList<T>();
    }

    public String getName() {
        return this.name;
    }

    public T get(int id) {
        return this.pool.get(id);
    }

    public int indexOf(T object) {
        return this.pool.indexOf(object);
    }

    public void put(int id, T o) {
        if (id == this.pool.size()) {
            this.pool.add(o);
        } else {
            this.pool.set(id, o);
        }
    }

    public int size() {
        return this.pool.size();
    }

    public void logInfo(Logger logger) {
        logger.info("Pool " + this.name + " Entries: " + this.size());
    }

    public void setFeature(Feature feature, int value) {
        this.features.put(feature, value);
    }

    public int getFeature(Feature feature, int defaultValue) {
        Integer val = this.features.get((Object)feature);
        return val == null ? defaultValue : val;
    }

    public static enum Feature {
        NUM_SENONES,
        NUM_GAUSSIANS_PER_STATE,
        NUM_STREAMS;

    }
}

