/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.linguist.acoustic.tiedstate;

import edu.cmu.sphinx.linguist.acoustic.HMM;
import edu.cmu.sphinx.linguist.acoustic.HMMPosition;
import edu.cmu.sphinx.linguist.acoustic.LeftRightContext;
import edu.cmu.sphinx.linguist.acoustic.Unit;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.HMMManager;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.Pool;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.Senone;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.SenoneHMM;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.SenoneSequence;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.kaldi.ConstantEventMap;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.kaldi.EventMap;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.kaldi.KaldiTextParser;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.kaldi.SplitEventMap;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.kaldi.TableEventMap;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.kaldi.TransitionModel;
import java.util.ArrayList;
import java.util.InputMismatchException;
import java.util.Map;

public class LazyHmmManager
extends HMMManager {
    private final EventMap eventMap;
    private final Pool<Senone> senonePool;
    private final Map<String, Integer> symbolTable;
    private final TransitionModel transitionModel;

    public LazyHmmManager(KaldiTextParser parser, TransitionModel transitionModel, Pool<Senone> senonePool, Map<String, Integer> symbolTable) {
        this.transitionModel = transitionModel;
        this.senonePool = senonePool;
        this.symbolTable = symbolTable;
        parser.expectToken("ContextDependency");
        parser.getInt();
        parser.getInt();
        parser.expectToken("ToPdf");
        this.eventMap = this.parseEventMap(parser);
        parser.expectToken("EndContextDependency");
    }

    private EventMap parseEventMap(KaldiTextParser parser) {
        String token = parser.getToken();
        if ("CE".equals(token)) {
            return new ConstantEventMap(parser.getInt());
        }
        if ("SE".equals(token)) {
            return this.parseSplitEventMap(parser);
        }
        if ("TE".equals(token)) {
            return this.parseTableEventMap(parser);
        }
        if ("NULL".equals(token)) {
            return null;
        }
        throw new InputMismatchException(token);
    }

    private EventMap parseSplitEventMap(KaldiTextParser parser) {
        int key = parser.getInt();
        ArrayList<Integer> values = new ArrayList<Integer>();
        int[] nArray = parser.getIntArray();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            Integer n3 = nArray[n2];
            values.add(n3);
            ++n2;
        }
        parser.expectToken("{");
        EventMap yesMap = this.parseEventMap(parser);
        EventMap noMap = this.parseEventMap(parser);
        SplitEventMap eventMap = new SplitEventMap(key, values, yesMap, noMap);
        parser.expectToken("}");
        return eventMap;
    }

    private EventMap parseTableEventMap(KaldiTextParser parser) {
        int key = parser.getInt();
        int size = parser.getInt();
        ArrayList<EventMap> table = new ArrayList<EventMap>(size);
        parser.expectToken("(");
        while (size-- > 0) {
            table.add(this.parseEventMap(parser));
        }
        parser.expectToken(")");
        return new TableEventMap(key, table);
    }

    @Override
    public HMM get(HMMPosition position, Unit unit) {
        HMM hmm = super.get(position, unit);
        if (hmm != null) {
            return hmm;
        }
        int[] ids = new int[3];
        ids[1] = this.symbolTable.get(unit.getName());
        if (unit.isContextDependent()) {
            LeftRightContext context = (LeftRightContext)unit.getContext();
            Unit left = context.getLeftContext()[0];
            Unit right = context.getRightContext()[0];
            ids[0] = this.symbolTable.get(left.getName());
            ids[2] = this.symbolTable.get(right.getName());
        } else {
            ids[0] = this.symbolTable.get("SIL");
            ids[2] = this.symbolTable.get("SIL");
        }
        int[] pdfs = new int[]{this.eventMap.map(0, ids), this.eventMap.map(1, ids), this.eventMap.map(2, ids)};
        Senone[] senones = new Senone[]{this.senonePool.get(pdfs[0]), this.senonePool.get(pdfs[1]), this.senonePool.get(pdfs[2])};
        SenoneSequence ss = new SenoneSequence(senones);
        float[][] transitionMatrix = this.transitionModel.getTransitionMatrix(ids[1], pdfs);
        hmm = new SenoneHMM(unit, ss, transitionMatrix, position);
        this.put(hmm);
        return hmm;
    }
}

