/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.linguist.acoustic.tiedstate;

import edu.cmu.sphinx.decoder.adaptation.ClusteredDensityFileData;
import edu.cmu.sphinx.decoder.adaptation.Transform;
import edu.cmu.sphinx.linguist.acoustic.HMMPosition;
import edu.cmu.sphinx.linguist.acoustic.Unit;
import edu.cmu.sphinx.linguist.acoustic.UnitManager;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.GaussianWeights;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.HMMManager;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.LazyHmmManager;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.Loader;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.Pool;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.Senone;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.kaldi.KaldiGmmPool;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.kaldi.KaldiTextParser;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.kaldi.TransitionModel;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.S4Component;
import edu.cmu.sphinx.util.props.S4String;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

public class KaldiLoader
implements Loader {
    @S4Component(type=UnitManager.class)
    public static final String PROP_UNIT_MANAGER = "unitManager";
    private String location;
    @S4String(mandatory=true)
    public static final String PROP_LOCATION = "location";
    private UnitManager unitManager;
    private Pool<Senone> senonePool;
    private HMMManager hmmManager;
    private Properties modelProperties;
    private Map<String, Unit> contextIndependentUnits;
    private float[][] transform;

    public KaldiLoader() {
    }

    public KaldiLoader(String location, UnitManager unitManager) {
        this.init(location, unitManager);
    }

    public void init(String location, UnitManager unitManager) {
        this.location = location;
        this.unitManager = unitManager;
    }

    @Override
    public void newProperties(PropertySheet ps) throws PropertyException {
        this.init(ps.getString(PROP_LOCATION), (UnitManager)ps.getComponent(PROP_UNIT_MANAGER));
    }

    @Override
    public void load() throws IOException {
        String line;
        KaldiTextParser parser = new KaldiTextParser(this.location);
        TransitionModel transitionModel = new TransitionModel(parser);
        this.senonePool = new KaldiGmmPool(parser);
        File file = new File(this.location, "phones.txt");
        InputStream stream = new URL(file.getPath()).openStream();
        InputStreamReader reader = new InputStreamReader(stream);
        BufferedReader br = new BufferedReader(reader);
        HashMap<String, Integer> symbolTable = new HashMap<String, Integer>();
        while ((line = br.readLine()) != null) {
            String[] fields = line.split(" ");
            if (!Character.isLetter(fields[0].charAt(0))) continue;
            symbolTable.put(fields[0], Integer.parseInt(fields[1]));
        }
        this.contextIndependentUnits = new HashMap<String, Unit>();
        this.hmmManager = new LazyHmmManager(parser, transitionModel, this.senonePool, symbolTable);
        for (String phone : symbolTable.keySet()) {
            Unit unit = this.unitManager.getUnit(phone, "SIL".equals(phone));
            this.contextIndependentUnits.put(unit.getName(), unit);
            this.hmmManager.get(HMMPosition.UNDEFINED, unit);
        }
        this.loadTransform();
        this.loadProperties();
    }

    private void loadTransform() throws IOException {
        String line;
        URL transformUrl = new URL(new File(this.location, "final.mat").getPath());
        InputStreamReader reader = new InputStreamReader(transformUrl.openStream());
        BufferedReader br = new BufferedReader(reader);
        ArrayList<Float> values = new ArrayList<Float>();
        int numRows = 0;
        int numCols = 0;
        while ((line = br.readLine()) != null) {
            int colCount = 0;
            String[] stringArray = line.split("\\s+");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String word = stringArray[n2];
                if (!(word.isEmpty() || "[".equals(word) || "]".equals(word))) {
                    values.add(Float.valueOf(Float.parseFloat(word)));
                    ++colCount;
                }
                ++n2;
            }
            if (colCount > 0) {
                ++numRows;
            }
            numCols = colCount;
        }
        this.transform = new float[numRows][numCols];
        Iterator valueIterator = values.iterator();
        int i = 0;
        while (i < numRows) {
            int j = 0;
            while (j < numCols) {
                this.transform[i][j] = ((Float)valueIterator.next()).floatValue();
                ++j;
            }
            ++i;
        }
    }

    private void loadProperties() throws IOException {
        String line;
        File file = new File(this.location, "feat.params");
        InputStream stream = new URL(file.getPath()).openStream();
        InputStreamReader reader = new InputStreamReader(stream);
        BufferedReader br = new BufferedReader(reader);
        this.modelProperties = new Properties();
        while ((line = br.readLine()) != null) {
            String[] tokens = line.split(" ");
            this.modelProperties.put(tokens[0], tokens[1]);
        }
    }

    @Override
    public Pool<Senone> getSenonePool() {
        return this.senonePool;
    }

    @Override
    public HMMManager getHMMManager() {
        return this.hmmManager;
    }

    @Override
    public Map<String, Unit> getContextIndependentUnits() {
        return this.contextIndependentUnits;
    }

    @Override
    public int getLeftContextSize() {
        return 1;
    }

    @Override
    public int getRightContextSize() {
        return 1;
    }

    @Override
    public Properties getProperties() {
        return this.modelProperties;
    }

    @Override
    public void logInfo() {
    }

    @Override
    public Pool<float[]> getMeansPool() {
        return null;
    }

    @Override
    public Pool<float[][]> getMeansTransformationMatrixPool() {
        return null;
    }

    @Override
    public Pool<float[]> getMeansTransformationVectorPool() {
        return null;
    }

    @Override
    public Pool<float[]> getVariancePool() {
        return null;
    }

    @Override
    public Pool<float[][]> getVarianceTransformationMatrixPool() {
        return null;
    }

    @Override
    public Pool<float[]> getVarianceTransformationVectorPool() {
        return null;
    }

    @Override
    public GaussianWeights getMixtureWeights() {
        return null;
    }

    @Override
    public Pool<float[][]> getTransitionMatrixPool() {
        return null;
    }

    @Override
    public float[][] getTransformMatrix() {
        return this.transform;
    }

    @Override
    public void update(Transform transform, ClusteredDensityFileData clusters) {
    }
}

