/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.linguist.acoustic.tiedstate.HTK;

import edu.cmu.sphinx.linguist.acoustic.tiedstate.HTK.GMMDiag;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.HTK.HMMState;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.HTK.Lab;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.HTK.SingleHMM;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class HMMSet {
    private GMMDiag g;
    private int nGaussians;
    float[][] trans;
    public final List<HMMState> states;
    public final List<float[][]> transitions = new ArrayList<float[][]>();
    public final Map<String, Integer> transNames = new HashMap<String, Integer>();
    public final List<GMMDiag> gmms;
    public final List<SingleHMM> hmms;
    private String[][] tiedHMMs;

    public Iterator<SingleHMM> get1phIt() {
        Iterator<SingleHMM> it = new Iterator<SingleHMM>(){
            int cur;

            @Override
            public void remove() {
            }

            @Override
            public SingleHMM next() {
                SingleHMM hmm;
                do {
                    if (this.cur < HMMSet.this.hmms.size()) continue;
                    return null;
                } while ((hmm = HMMSet.this.hmms.get(this.cur++)).getName().indexOf(45) >= 0 || hmm.getName().indexOf(43) >= 0);
                return hmm;
            }

            @Override
            public boolean hasNext() {
                return false;
            }
        };
        return it;
    }

    public Iterator<SingleHMM> get3phIt() {
        Iterator<SingleHMM> it = new Iterator<SingleHMM>(){
            int cur;

            @Override
            public void remove() {
            }

            @Override
            public SingleHMM next() {
                SingleHMM hmm;
                do {
                    if (this.cur < HMMSet.this.hmms.size()) continue;
                    return null;
                } while ((hmm = HMMSet.this.hmms.get(this.cur++)).getName().indexOf(45) < 0 && hmm.getName().indexOf(43) < 0);
                return hmm;
            }

            @Override
            public boolean hasNext() {
                return false;
            }
        };
        return it;
    }

    public int getStateIdx(HMMState st) {
        return st.gmmidx;
    }

    public int getHMMidx(SingleHMM hmm) {
        int i = 0;
        while (i < this.hmms.size()) {
            SingleHMM h = this.hmms.get(i);
            if (h == hmm) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int getNstates() {
        return this.gmms.size();
    }

    public String[] getHMMnames() {
        String[] rep = new String[this.hmms.size()];
        int i = 0;
        while (i < rep.length) {
            SingleHMM h = this.hmms.get(i);
            rep[i] = h.getName();
            ++i;
        }
        return rep;
    }

    public int getNhmms() {
        return this.hmms.size();
    }

    public int getNhmmsMono() {
        int n = 0;
        for (SingleHMM hmm : this.hmms) {
            if (hmm.getName().indexOf(45) >= 0 || hmm.getName().indexOf(43) >= 0) continue;
            ++n;
        }
        return n;
    }

    public int getNhmmsTri() {
        int n = 0;
        for (SingleHMM hmm : this.hmms) {
            if (hmm.getName().indexOf(45) < 0 && hmm.getName().indexOf(43) < 0) continue;
            ++n;
        }
        return n;
    }

    public int getHMMIndex(SingleHMM h) {
        return this.hmms.indexOf(h);
    }

    public int getStateIdx(int hmmidx, int stateidx) {
        SingleHMM hmm;
        int nEmittingStates = 0;
        int i = 0;
        while (i < hmmidx) {
            hmm = this.hmms.get(i);
            nEmittingStates += hmm.getNbEmittingStates();
            ++i;
        }
        hmm = this.hmms.get(hmmidx);
        i = 1;
        while (i < stateidx) {
            if (hmm.isEmitting(i)) {
                ++nEmittingStates;
            }
            ++i;
        }
        if (hmm.isEmitting(stateidx)) {
            return nEmittingStates;
        }
        return -1;
    }

    public SingleHMM getHMM(int idx) {
        return this.hmms.get(idx);
    }

    public SingleHMM getHMM(String nom) {
        SingleHMM h = null;
        for (SingleHMM hmm : this.hmms) {
            h = hmm;
            if (h.getName().equals(nom)) break;
        }
        return h;
    }

    public HMMSet() {
        this.states = new ArrayList<HMMState>();
        this.hmms = new ArrayList<SingleHMM>();
        this.gmms = new ArrayList<GMMDiag>();
    }

    public void loadHTK(String nomFich) {
        try {
            String s;
            BufferedReader f = new BufferedReader(new FileReader(nomFich));
            while ((s = f.readLine()) != null) {
                if (s.startsWith("~s")) {
                    String nomEtat = s.substring(s.indexOf(34) + 1, s.lastIndexOf(34));
                    this.loadState(f, nomEtat, null);
                    continue;
                }
                if (s.startsWith("~v")) continue;
                if (s.startsWith("~t")) {
                    String nomTrans = s.substring(s.indexOf(34) + 1, s.lastIndexOf(34));
                    this.loadTrans(f, nomTrans, null);
                    continue;
                }
                if (!s.startsWith("~h")) continue;
                String nomHMM = s.substring(s.indexOf(34) + 1, s.lastIndexOf(34));
                if (nomHMM.toUpperCase().equals(nomHMM)) {
                    System.out.println("WARNING: HMM is in lowercase, converting to upper");
                }
                this.hmms.add(this.loadHMM(f, nomHMM.toUpperCase(), this.gmms));
            }
            f.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void loadTiedList(String nomFich) {
        try {
            String[] ss;
            String s;
            BufferedReader f = new BufferedReader(new FileReader(nomFich));
            int ntiedstates = 0;
            while ((s = f.readLine()) != null) {
                ss = s.split(" ");
                if (ss.length < 2) continue;
                ++ntiedstates;
            }
            this.tiedHMMs = new String[ntiedstates][2];
            f.close();
            f = new BufferedReader(new FileReader(nomFich));
            int i = 0;
            while ((s = f.readLine()) != null) {
                ss = s.split(" ");
                if (ss.length < 2) continue;
                this.tiedHMMs[i][0] = ss[0];
                this.tiedHMMs[i++][1] = ss[1];
            }
            f.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private SingleHMM loadHMM(BufferedReader f, String n, List<GMMDiag> autresEtats) throws IOException {
        GMMDiag e = null;
        String name = n;
        String s = "";
        while (!s.startsWith("<NUMSTATES>")) {
            s = f.readLine();
        }
        int nstates = Integer.parseInt(s.substring(s.indexOf(32) + 1));
        SingleHMM theHMM = new SingleHMM(--nstates);
        theHMM.setName(n);
        theHMM.hmmset = this;
        while (!s.startsWith("<STATE>")) {
            s = f.readLine();
        }
        while (s.startsWith("<STATE>")) {
            int curstate = Integer.parseInt(s.substring(s.indexOf(32) + 1));
            --curstate;
            s = f.readLine();
            int gmmidx = -1;
            if (s.startsWith("~s")) {
                String nomEtat = s.substring(s.indexOf(34) + 1, s.lastIndexOf(34));
                int i = 0;
                while (i < autresEtats.size()) {
                    e = autresEtats.get(i);
                    if (e.nom.equals(nomEtat)) break;
                    ++i;
                }
                gmmidx = i;
                if (i == autresEtats.size()) {
                    System.err.println("Error creatiing HMM : state " + name + " not found");
                    System.exit(1);
                }
            } else {
                this.loadState(f, "", s);
                gmmidx = this.gmms.size() - 1;
                e = this.gmms.get(this.gmms.size() - 1);
            }
            HMMState st = new HMMState(e, new Lab(name, curstate));
            st.gmmidx = gmmidx;
            this.states.add(st);
            theHMM.setState(curstate - 1, st);
            s = f.readLine();
            if (!s.startsWith("<GCONST>")) continue;
            s = f.readLine();
        }
        if (s.startsWith("~t")) {
            String nomTrans = s.substring(s.indexOf(34) + 1, s.lastIndexOf(34));
            int tridx = this.getTrans(nomTrans);
            theHMM.setTrans(tridx);
        } else {
            if (!s.startsWith("<TRANSP>")) {
                System.err.println("Error reading model: missing transitions." + s);
                System.exit(1);
            }
            this.loadTrans(f, null, s);
            theHMM.setTrans(this.trans);
        }
        s = f.readLine();
        if (!s.startsWith("<ENDHMM>")) {
            System.err.println("Error reading model: missing ENDHMM." + s);
            System.exit(1);
        }
        return theHMM;
    }

    private int loadTrans(BufferedReader f, String nomEtat, String prem) throws IOException {
        int nstates = 0;
        String s = prem != null ? prem : f.readLine().trim();
        if (s.startsWith("<TRANSP>")) {
            nstates = Integer.parseInt(s.substring(s.indexOf(32) + 1));
            --nstates;
        } else {
            System.err.println("ERROR no TRANSP !");
            System.exit(1);
        }
        this.trans = new float[nstates][nstates];
        f.readLine();
        int i = 0;
        while (i < nstates) {
            s = f.readLine().trim();
            String[] ss = s.split(" ");
            int j = 0;
            while (j < nstates) {
                this.trans[i][j] = Float.parseFloat(ss[j + 1]);
                ++j;
            }
            ++i;
        }
        if (nomEtat != null) {
            int tridx = this.transitions.size();
            this.transNames.put(nomEtat, tridx);
            this.transitions.add(this.trans);
            return tridx;
        }
        return -1;
    }

    private int getTrans(String trnom) {
        int tridx = this.transNames.get(trnom);
        return tridx;
    }

    private void loadState(BufferedReader f, String nomEtat, String prem) throws IOException {
        this.nGaussians = 1;
        String s = prem != null ? prem : f.readLine().trim();
        if (s.startsWith("<NUMMIXES>")) {
            this.nGaussians = Integer.parseInt(s.substring(s.indexOf(32) + 1));
            s = f.readLine().trim();
        }
        this.g = null;
        if (!s.startsWith("<MIXTURE>")) {
            if (this.nGaussians != 1) {
                System.err.println("Error loading model: number of mixtures is " + this.nGaussians + " while state " + s + " has 1 mixture.");
                System.exit(1);
            }
            this.loadHTKGauss(f, 0, s);
            this.g.setWeight(0, 1.0f);
        } else {
            int i = 0;
            while (i < this.nGaussians) {
                String[] ss;
                if (i > 0) {
                    s = f.readLine().trim();
                }
                if (s.startsWith("<GCONST>")) {
                    s = f.readLine().trim();
                }
                if (Integer.parseInt((ss = s.split(" "))[1]) != i + 1) {
                    System.err.println("Error reading model: mixture conflict " + i + ' ' + s);
                    System.exit(1);
                }
                this.loadHTKGauss(f, i, null);
                this.g.setWeight(i, Float.parseFloat(ss[2]));
                ++i;
            }
        }
        this.g.precomputeDistance();
        this.g.setNom(nomEtat);
        this.gmms.add(this.g);
    }

    private void loadHTKGauss(BufferedReader f, int n, String prem) throws IOException {
        String[] ss;
        String s = prem != null ? prem : f.readLine().trim();
        if (s.startsWith("<GCONST>")) {
            s = f.readLine().trim();
        }
        if (s.startsWith("<RCLASS>")) {
            s = f.readLine().trim();
        }
        if (!s.startsWith("<MEAN>")) {
            System.err.println("Error loading model: can't find <MEAN> ! " + s);
            System.exit(1);
        }
        int ncoefs = Integer.parseInt(s.substring(s.indexOf(32) + 1));
        if (this.g == null) {
            this.g = new GMMDiag(this.nGaussians, ncoefs);
        }
        if ((ss = (s = f.readLine().trim()).split(" ")).length != ncoefs) {
            System.err.println("Error loading model: incorrect number of coefficients " + ncoefs + ' ' + s + ' ' + ss[0] + ' ' + ss[39]);
            System.exit(1);
        }
        int i = 0;
        while (i < ncoefs) {
            this.g.setMean(n, i, Float.parseFloat(ss[i]));
            ++i;
        }
        s = f.readLine().trim();
        if (!s.startsWith("<VARIANCE>")) {
            System.err.println("Error loading model: missing <VARIANCE> ! " + s);
            System.exit(1);
        }
        if ((ss = (s = f.readLine().trim()).split(" ")).length != ncoefs) {
            System.err.println("Error loading model: incorrect number of coefficients " + ncoefs + ' ' + s);
            System.exit(1);
        }
        i = 0;
        while (i < ncoefs) {
            this.g.setVar(n, i, Float.parseFloat(ss[i]));
            ++i;
        }
    }

    public GMMDiag findState(Lab l) {
        while (true) {
            HMMState s = null;
            int i = 0;
            while (i < this.states.size()) {
                s = this.states.get(i);
                if (s.getLab().isEqual(l)) break;
                ++i;
            }
            if (i < this.states.size()) {
                return s.gmm;
            }
            if (this.tiedHMMs == null) break;
            i = 0;
            while (i < this.tiedHMMs.length) {
                if (this.tiedHMMs[i][0].equals(l.getName())) break;
                ++i;
            }
            if (i >= this.tiedHMMs.length) break;
            l = new Lab(this.tiedHMMs[i][1], l.getState());
        }
        System.err.println("WARNING: state is not found in hmmset " + l);
        return null;
    }
}

