/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.linguist.acoustic.tiedstate;

import edu.cmu.sphinx.linguist.acoustic.tiedstate.Pool;
import java.util.logging.Logger;

public class GaussianWeights {
    private final float[][] weights;
    private final int numStates;
    private final int gauPerState;
    private final int numStreams;
    private final String name;

    public GaussianWeights(String name, int numStates, int gauPerState, int numStreams) {
        this.numStates = numStates;
        this.gauPerState = gauPerState;
        this.numStreams = numStreams;
        this.name = name;
        this.weights = new float[gauPerState][numStates * numStreams];
    }

    public void put(int stateId, int streamId, float[] gauWeights) {
        assert (gauWeights.length == this.gauPerState);
        int i = 0;
        while (i < this.gauPerState) {
            this.weights[i][stateId * this.numStreams + streamId] = gauWeights[i];
            ++i;
        }
    }

    public float get(int stateId, int streamId, int gaussianId) {
        return this.weights[gaussianId][stateId * this.numStreams + streamId];
    }

    public int getStatesNum() {
        return this.numStates;
    }

    public int getGauPerState() {
        return this.gauPerState;
    }

    public int getStreamsNum() {
        return this.numStreams;
    }

    public String getName() {
        return this.name;
    }

    public void logInfo(Logger logger) {
        logger.info("Gaussian weights: " + this.name + ". Entries: " + this.numStates * this.numStreams);
    }

    public Pool<float[]> convertToPool() {
        return null;
    }
}

