/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.linguist.acoustic.tiedstate;

import edu.cmu.sphinx.frontend.Data;
import edu.cmu.sphinx.frontend.DoubleData;
import edu.cmu.sphinx.frontend.FloatData;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.GaussianWeights;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.MixtureComponent;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.ScoreCachingSenone;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.Senone;
import edu.cmu.sphinx.util.LogMath;

public class GaussianMixture
extends ScoreCachingSenone {
    protected GaussianWeights mixtureWeights;
    private MixtureComponent[] mixtureComponents;
    protected int id;
    protected LogMath logMath = LogMath.getLogMath();

    public GaussianMixture(GaussianWeights mixtureWeights, MixtureComponent[] mixtureComponents, int id) {
        this.mixtureComponents = mixtureComponents;
        this.mixtureWeights = mixtureWeights;
        this.id = id;
    }

    @Override
    public void dump(String msg) {
        System.out.println(String.valueOf(msg) + " GaussianMixture: ID " + this.getID());
    }

    public boolean equals(Object o) {
        if (!(o instanceof Senone)) {
            return false;
        }
        Senone other = (Senone)o;
        return this.getID() == other.getID();
    }

    public int hashCode() {
        long id = this.getID();
        int high = (int)(id >> 32);
        int low = (int)id;
        return high + low;
    }

    @Override
    public long getID() {
        return this.id;
    }

    public String toString() {
        return "senone id: " + this.getID();
    }

    @Override
    public float calculateScore(Data feature) {
        if (feature instanceof DoubleData) {
            System.err.println("DoubleData conversion required on mixture level!");
        }
        float[] featureVector = FloatData.toFloatData(feature).getValues();
        float logTotal = -3.4028235E38f;
        int i = 0;
        while (i < this.mixtureComponents.length) {
            logTotal = this.logMath.addAsLinear(logTotal, this.mixtureComponents[i].getScore(featureVector) + this.mixtureWeights.get(this.id, 0, i));
            ++i;
        }
        return logTotal;
    }

    @Override
    public float[] calculateComponentScore(Data feature) {
        if (feature instanceof DoubleData) {
            System.err.println("DoubleData conversion required on mixture level!");
        }
        float[] featureVector = FloatData.toFloatData(feature).getValues();
        float[] logComponentScore = new float[this.mixtureComponents.length];
        int i = 0;
        while (i < this.mixtureComponents.length) {
            logComponentScore[i] = this.mixtureComponents[i].getScore(featureVector) + this.mixtureWeights.get(this.id, 0, i);
            ++i;
        }
        return logComponentScore;
    }

    @Override
    public MixtureComponent[] getMixtureComponents() {
        return this.mixtureComponents;
    }

    public int dimension() {
        return this.mixtureComponents[0].getMean().length;
    }

    public int numComponents() {
        return this.mixtureComponents.length;
    }

    @Override
    public float[] getLogMixtureWeights() {
        float[] logWeights = new float[this.getMixtureComponents().length];
        int i = 0;
        while (i < logWeights.length) {
            logWeights[i] = this.mixtureWeights.get(this.id, 0, i);
            ++i;
        }
        return logWeights;
    }

    public float[] getComponentWeights() {
        float[] mixWeights = new float[this.getMixtureComponents().length];
        int i = 0;
        while (i < mixWeights.length) {
            mixWeights[i] = (float)this.logMath.logToLinear(this.mixtureWeights.get(this.id, 0, i));
            ++i;
        }
        return mixWeights;
    }

    public float getLogComponentWeight(int index) {
        return this.mixtureWeights.get(this.id, 0, index);
    }
}

