/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.linguist.acoustic;

import edu.cmu.sphinx.linguist.acoustic.Context;
import edu.cmu.sphinx.linguist.acoustic.Unit;

public class LeftRightContext
extends Context {
    String stringRepresentation;
    final Unit[] leftContext;
    final Unit[] rightContext;

    private LeftRightContext(Unit[] leftContext, Unit[] rightContext) {
        this.leftContext = leftContext;
        this.rightContext = rightContext;
    }

    @Override
    public String toString() {
        return String.valueOf(LeftRightContext.getContextName(this.leftContext)) + ',' + LeftRightContext.getContextName(this.rightContext);
    }

    public static LeftRightContext get(Unit[] leftContext, Unit[] rightContext) {
        return new LeftRightContext(leftContext, rightContext);
    }

    public Unit[] getLeftContext() {
        return this.leftContext;
    }

    public Unit[] getRightContext() {
        return this.rightContext;
    }

    public static String getContextName(Unit[] context) {
        if (context == null) {
            return "*";
        }
        if (context.length == 0) {
            return "(empty)";
        }
        StringBuilder sb = new StringBuilder();
        Unit[] unitArray = context;
        int n = context.length;
        int n2 = 0;
        while (n2 < n) {
            Unit unit = unitArray[n2];
            sb.append(unit == null ? null : unit.getName()).append('.');
            ++n2;
        }
        sb.setLength(sb.length() - 1);
        return sb.toString();
    }

    @Override
    public boolean isPartialMatch(Context context) {
        if (context instanceof LeftRightContext) {
            LeftRightContext lrContext = (LeftRightContext)context;
            Unit[] lc = lrContext.getLeftContext();
            Unit[] rc = lrContext.getRightContext();
            return !(lc != null && this.leftContext != null && !Unit.isContextMatch(lc, this.leftContext) || rc != null && this.rightContext != null && !Unit.isContextMatch(rc, this.rightContext));
        }
        return context == Context.EMPTY_CONTEXT && this.leftContext == null && this.rightContext == null;
    }
}

