/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.linguist.acoustic;

import edu.cmu.sphinx.linguist.acoustic.AcousticModel;
import edu.cmu.sphinx.linguist.acoustic.HMM;
import edu.cmu.sphinx.linguist.acoustic.HMMPosition;
import edu.cmu.sphinx.linguist.acoustic.LeftRightContext;
import edu.cmu.sphinx.linguist.acoustic.Unit;
import edu.cmu.sphinx.linguist.acoustic.UnitManager;
import edu.cmu.sphinx.util.TimerPool;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HMMPool {
    private AcousticModel model;
    private Unit[] unitTable;
    private Map<HMMPosition, HMM[]> hmmTable;
    private int numCIUnits;
    private Logger logger;
    private UnitManager unitManager;
    static final HMMPosition[] pos = new HMMPosition[]{HMMPosition.BEGIN, HMMPosition.END, HMMPosition.SINGLE, HMMPosition.INTERNAL};
    static final int[] ids = new int[]{9206, 9320, 9620, 9865, 14831, 15836};

    protected HMMPool() {
    }

    public HMMPool(AcousticModel model, Logger logger, UnitManager unitManager) {
        this.logger = logger;
        int maxCIUnits = 0;
        this.model = model;
        this.unitManager = unitManager;
        if (model.getLeftContextSize() != 1) {
            throw new Error("LexTreeLinguist: Unsupported left context size");
        }
        if (model.getRightContextSize() != 1) {
            throw new Error("LexTreeLinguist: Unsupported right context size");
        }
        Iterator<Object> i = model.getContextIndependentUnitIterator();
        while (i.hasNext()) {
            Unit unit = i.next();
            logger.fine("CI unit " + unit);
            if (unit.getBaseID() <= maxCIUnits) continue;
            maxCIUnits = unit.getBaseID();
        }
        this.numCIUnits = maxCIUnits + 1;
        this.unitTable = new Unit[this.numCIUnits * this.numCIUnits * this.numCIUnits];
        i = model.getHMMIterator();
        while (i.hasNext()) {
            HMM hmm = (HMM)i.next();
            Unit unit = hmm.getUnit();
            int id = this.getID(unit);
            this.unitTable[id] = unit;
            if (!logger.isLoggable(Level.FINER)) continue;
            logger.finer("Unit " + unit + " id " + id);
        }
        this.hmmTable = new EnumMap<HMMPosition, HMM[]>(HMMPosition.class);
        HMMPosition[] hMMPositionArray = HMMPosition.values();
        int n = hMMPositionArray.length;
        int n2 = 0;
        while (n2 < n) {
            HMMPosition position = hMMPositionArray[n2];
            HMM[] hmms = new HMM[this.unitTable.length];
            this.hmmTable.put(position, hmms);
            int j = 1;
            while (j < this.unitTable.length) {
                Unit unit = this.unitTable[j];
                if (unit == null) {
                    unit = this.synthesizeUnit(j);
                }
                if (unit != null) {
                    hmms[j] = model.lookupNearestHMM(unit, position, false);
                    assert (hmms[j] != null);
                }
                ++j;
            }
            ++n2;
        }
    }

    public AcousticModel getModel() {
        return this.model;
    }

    private Unit synthesizeUnit(int id) {
        int centralID = this.getCentralUnitID(id);
        int leftID = this.getLeftUnitID(id);
        int rightID = this.getRightUnitID(id);
        if (centralID == 0 || leftID == 0 || rightID == 0) {
            return null;
        }
        Unit centralUnit = this.unitTable[centralID];
        Unit leftUnit = this.unitTable[leftID];
        Unit rightUnit = this.unitTable[rightID];
        assert (centralUnit != null);
        assert (leftUnit != null);
        assert (rightUnit != null);
        Unit[] lc = new Unit[1];
        Unit[] rc = new Unit[1];
        lc[0] = leftUnit;
        rc[0] = rightUnit;
        LeftRightContext context = LeftRightContext.get(lc, rc);
        Unit unit = this.unitManager.getUnit(centralUnit.getName(), centralUnit.isFiller(), context);
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.finer("Missing " + this.getUnitNameFromID(id) + " returning " + unit);
        }
        return unit;
    }

    public int getNumCIUnits() {
        return this.numCIUnits;
    }

    public Unit getUnit(int unitID) {
        return this.unitTable[unitID];
    }

    public HMM getHMM(int unitID, HMMPosition position) {
        return this.hmmTable.get((Object)position)[unitID];
    }

    public int getID(Unit unit) {
        if (unit.isContextDependent()) {
            LeftRightContext context = (LeftRightContext)unit.getContext();
            assert (context.getLeftContext().length == 1);
            assert (context.getRightContext().length == 1);
            return this.buildID(this.getSimpleUnitID(unit), this.getSimpleUnitID(context.getLeftContext()[0]), this.getSimpleUnitID(context.getRightContext()[0]));
        }
        return this.getSimpleUnitID(unit);
    }

    private int getSimpleUnitID(Unit unit) {
        return unit.getBaseID();
    }

    public boolean isValidID(int unitID) {
        return unitID >= 0 && unitID < this.unitTable.length && this.unitTable[unitID] != null;
    }

    public int buildID(int unitID, int leftID, int rightID) {
        if (this.unitTable[unitID] == null) {
            return -1;
        }
        int id = this.unitTable[unitID].isFiller() ? unitID : unitID * (this.numCIUnits * this.numCIUnits) + leftID * this.numCIUnits + rightID;
        assert (id < this.unitTable.length);
        return id;
    }

    private int getLeftUnitID(int id) {
        return id / this.numCIUnits % this.numCIUnits;
    }

    private int getRightUnitID(int id) {
        return id % this.numCIUnits;
    }

    private int getCentralUnitID(int id) {
        return id / (this.numCIUnits * this.numCIUnits);
    }

    private String getUnitNameFromID(int id) {
        int centralID = this.getCentralUnitID(id);
        int leftID = this.getLeftUnitID(id);
        int rightID = this.getRightUnitID(id);
        String cs = this.unitTable[centralID] == null ? "(" + centralID + ')' : this.unitTable[centralID].toString();
        String ls = this.unitTable[leftID] == null ? "(" + leftID + ')' : this.unitTable[leftID].toString();
        String rs = this.unitTable[rightID] == null ? "(" + rightID + ')' : this.unitTable[rightID].toString();
        return String.valueOf(cs) + '[' + ls + ',' + rs + ']';
    }

    public HMM getHMM(Unit base, Unit lc, Unit rc, HMMPosition pos) {
        int id = -1;
        int bid = this.getID(base);
        int lid = this.getID(lc);
        int rid = this.getID(rc);
        if (!this.isValidID(bid)) {
            this.logger.severe("Bad HMM Unit: " + base.getName());
            return null;
        }
        if (!this.isValidID(lid)) {
            this.logger.severe("Bad HMM Unit: " + lc.getName());
            return null;
        }
        if (!this.isValidID(rid)) {
            this.logger.severe("Bad HMM Unit: " + rc.getName());
            return null;
        }
        id = this.buildID(bid, lid, rid);
        if (id < 0) {
            this.logger.severe("Unable to build HMM Unit ID for " + base.getName() + " lc=" + lc.getName() + " rc=" + rc.getName());
            return null;
        }
        HMM hmm = this.getHMM(id, pos);
        if (hmm == null) {
            this.logger.severe("Missing HMM Unit for " + base.getName() + " lc=" + lc.getName() + " rc=" + rc.getName());
        }
        return hmm;
    }

    public void dumpInfo() {
        this.logger.info("Max CI Units " + this.numCIUnits);
        this.logger.info("Unit table size " + this.unitTable.length);
        if (this.logger.isLoggable(Level.FINER)) {
            int i = 0;
            while (i < this.unitTable.length) {
                this.logger.finer(String.valueOf(String.valueOf(i)) + ' ' + this.unitTable[i]);
                ++i;
            }
        }
    }

    void benchmark() {
        int nullCount = 0;
        System.out.println("benchmarking ...");
        TimerPool.getTimer(this, "hmmPoolBenchmark").start();
        int i = 0;
        while (i < 1000000) {
            int id = ids[i % ids.length];
            HMMPosition position = pos[i % pos.length];
            HMM hmm = this.getHMM(id, position);
            if (hmm == null) {
                ++nullCount;
            }
            ++i;
        }
        TimerPool.getTimer(this, "hmmPoolBenchmark").stop();
        System.out.println("null count " + nullCount);
    }
}

