/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.jsgf;

import edu.cmu.sphinx.jsgf.JSGFBaseGrammar;
import edu.cmu.sphinx.jsgf.JSGFGrammarException;
import edu.cmu.sphinx.jsgf.JSGFGrammarParseException;
import edu.cmu.sphinx.jsgf.JSGFRuleGrammar;
import edu.cmu.sphinx.jsgf.JSGFRuleGrammarFactory;
import edu.cmu.sphinx.jsgf.parser.JSGFParser;
import edu.cmu.sphinx.jsgf.rule.JSGFRule;
import edu.cmu.sphinx.jsgf.rule.JSGFRuleName;
import edu.cmu.sphinx.linguist.dictionary.Dictionary;
import edu.cmu.sphinx.linguist.language.grammar.GrammarNode;
import edu.cmu.sphinx.util.props.ConfigurationManagerUtils;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;

public class JSGFGrammar
extends JSGFBaseGrammar {
    public JSGFGrammar(String location, String grammarName, boolean showGrammar, boolean optimizeGrammar, boolean addSilenceWords, boolean addFillerWords, Dictionary dictionary) throws MalformedURLException, ClassNotFoundException {
        this(ConfigurationManagerUtils.resourceToURL(location), grammarName, showGrammar, optimizeGrammar, addSilenceWords, addFillerWords, dictionary);
    }

    public JSGFGrammar(URL baseURL, String grammarName, boolean showGrammar, boolean optimizeGrammar, boolean addSilenceWords, boolean addFillerWords, Dictionary dictionary) {
        super(baseURL, grammarName, showGrammar, optimizeGrammar, addSilenceWords, addFillerWords, dictionary);
    }

    public JSGFGrammar() {
    }

    private static URL grammarNameToURL(URL baseURL, String grammarName) throws MalformedURLException {
        URL grammarURL;
        block4: {
            grammarName = grammarName.replace('.', '/');
            StringBuilder sb = new StringBuilder();
            if (baseURL != null) {
                sb.append(baseURL);
                if (sb.charAt(sb.length() - 1) != '/') {
                    sb.append('/');
                }
            }
            sb.append(grammarName).append(".gram");
            String urlstr = sb.toString();
            grammarURL = null;
            try {
                grammarURL = new URL(urlstr);
            }
            catch (MalformedURLException me) {
                grammarURL = ClassLoader.getSystemResource(urlstr);
                if (grammarURL != null) break block4;
                throw new MalformedURLException(urlstr);
            }
        }
        return grammarURL;
    }

    @Override
    public void commitChanges() throws IOException, JSGFGrammarParseException, JSGFGrammarException {
        try {
            if (this.loadGrammar) {
                if (this.manager == null) {
                    this.getGrammarManager();
                }
                this.ruleGrammar = this.loadNamedGrammar(this.grammarName);
                this.loadImports(this.ruleGrammar);
                this.loadGrammar = false;
            }
            this.manager.linkGrammars();
            this.ruleStack = new JSGFBaseGrammar.RuleStack();
            this.newGrammar();
            this.firstNode = this.createGrammarNode("<sil>");
            GrammarNode finalNode = this.createGrammarNode("<sil>");
            finalNode.setFinalNode(true);
            for (String ruleName : this.ruleGrammar.getRuleNames()) {
                if (!this.ruleGrammar.isRulePublic(ruleName)) continue;
                String fullName = this.getFullRuleName(ruleName);
                JSGFBaseGrammar.GrammarGraph publicRuleGraph = new JSGFBaseGrammar.GrammarGraph();
                this.ruleStack.push(fullName, publicRuleGraph);
                JSGFRule rule = this.ruleGrammar.getRule(ruleName);
                JSGFBaseGrammar.GrammarGraph graph = this.processRule(rule);
                this.ruleStack.pop();
                this.firstNode.add(publicRuleGraph.getStartNode(), 0.0f);
                publicRuleGraph.getEndNode().add(finalNode, 0.0f);
                publicRuleGraph.getStartNode().add(graph.getStartNode(), 0.0f);
                graph.getEndNode().add(publicRuleGraph.getEndNode(), 0.0f);
            }
            this.postProcessGrammar();
            if (this.logger.isLoggable(Level.FINEST)) {
                this.dumpGrammar();
            }
        }
        catch (MalformedURLException mue) {
            throw new IOException("bad base grammar URL " + this.baseURL + ' ' + mue);
        }
    }

    private void loadImports(JSGFRuleGrammar grammar) throws IOException, JSGFGrammarParseException {
        for (JSGFRuleName ruleName : grammar.imports) {
            String grammarName = ruleName.getFullGrammarName();
            JSGFRuleGrammar importedGrammar = this.getNamedRuleGrammar(grammarName);
            if (importedGrammar == null) {
                importedGrammar = this.loadNamedGrammar(ruleName.getFullGrammarName());
            }
            if (importedGrammar == null) continue;
            this.loadImports(importedGrammar);
        }
        this.loadFullQualifiedRules(grammar);
    }

    private JSGFRuleGrammar getNamedRuleGrammar(String grammarName) {
        return this.manager.retrieveGrammar(grammarName);
    }

    private JSGFRuleGrammar loadNamedGrammar(String grammarName) throws JSGFGrammarParseException, IOException {
        URL url = JSGFGrammar.grammarNameToURL(this.baseURL, grammarName);
        JSGFRuleGrammar ruleGrammar = JSGFParser.newGrammarFromJSGF(url, new JSGFRuleGrammarFactory(this.manager));
        ruleGrammar.setEnabled(true);
        return ruleGrammar;
    }

    private void loadFullQualifiedRules(JSGFRuleGrammar grammar) throws IOException, JSGFGrammarParseException {
        block0: for (String ruleName : grammar.getRuleNames()) {
            String rule = grammar.getRule(ruleName).toString();
            int index = 0;
            while (index < rule.length()) {
                if ((index = rule.indexOf(60, index)) < 0) continue block0;
                JSGFRuleName extractedRuleName = new JSGFRuleName(rule.substring(index + 1, rule.indexOf(62, index + 1)).trim());
                index = rule.indexOf(62, index) + 1;
                if (extractedRuleName.getFullGrammarName() == null) continue;
                String grammarName = extractedRuleName.getFullGrammarName();
                JSGFRuleGrammar importedGrammar = this.getNamedRuleGrammar(grammarName);
                if (importedGrammar == null) {
                    importedGrammar = this.loadNamedGrammar(grammarName);
                }
                if (importedGrammar == null) continue;
                this.loadImports(importedGrammar);
            }
        }
    }
}

