/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.jsgf;

import edu.cmu.sphinx.jsgf.JSGFGrammarException;
import edu.cmu.sphinx.jsgf.JSGFGrammarParseException;
import edu.cmu.sphinx.jsgf.JSGFRuleGrammar;
import edu.cmu.sphinx.jsgf.JSGFRuleGrammarManager;
import edu.cmu.sphinx.jsgf.rule.JSGFRule;
import edu.cmu.sphinx.jsgf.rule.JSGFRuleAlternatives;
import edu.cmu.sphinx.jsgf.rule.JSGFRuleCount;
import edu.cmu.sphinx.jsgf.rule.JSGFRuleName;
import edu.cmu.sphinx.jsgf.rule.JSGFRuleSequence;
import edu.cmu.sphinx.jsgf.rule.JSGFRuleTag;
import edu.cmu.sphinx.jsgf.rule.JSGFRuleToken;
import edu.cmu.sphinx.linguist.dictionary.Dictionary;
import edu.cmu.sphinx.linguist.language.grammar.Grammar;
import edu.cmu.sphinx.linguist.language.grammar.GrammarNode;
import edu.cmu.sphinx.util.LogMath;
import edu.cmu.sphinx.util.props.ConfigurationManagerUtils;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.S4String;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;

public abstract class JSGFBaseGrammar
extends Grammar {
    @S4String
    public static final String PROP_BASE_GRAMMAR_URL = "grammarLocation";
    @S4String(defaultValue="default.gram")
    public static final String PROP_GRAMMAR_NAME = "grammarName";
    protected JSGFRuleGrammar ruleGrammar;
    protected JSGFRuleGrammarManager manager;
    protected RuleStack ruleStack;
    protected String grammarName;
    protected URL baseURL;
    private LogMath logMath;
    protected boolean loadGrammar = true;
    protected GrammarNode firstNode;
    protected Logger logger;

    public JSGFBaseGrammar(URL baseURL, String grammarName, boolean showGrammar, boolean optimizeGrammar, boolean addSilenceWords, boolean addFillerWords, Dictionary dictionary) {
        super(showGrammar, optimizeGrammar, addSilenceWords, addFillerWords, dictionary);
        this.logger = Logger.getLogger(this.getClass().getName());
        this.logMath = LogMath.getLogMath();
        this.baseURL = baseURL;
        this.grammarName = grammarName;
        this.loadGrammar = true;
    }

    public JSGFBaseGrammar() {
    }

    @Override
    public void newProperties(PropertySheet ps) throws PropertyException {
        super.newProperties(ps);
        this.logger = ps.getLogger();
        this.logMath = LogMath.getLogMath();
        this.baseURL = ConfigurationManagerUtils.getResource(PROP_BASE_GRAMMAR_URL, ps);
        this.grammarName = ps.getString(PROP_GRAMMAR_NAME);
        this.loadGrammar = true;
    }

    public JSGFRuleGrammar getRuleGrammar() {
        return this.ruleGrammar;
    }

    public JSGFRuleGrammarManager getGrammarManager() {
        if (this.manager == null) {
            this.manager = new JSGFRuleGrammarManager();
        }
        return this.manager;
    }

    public void setBaseURL(URL url) {
        this.baseURL = url;
    }

    public String getGrammarName() {
        return this.grammarName;
    }

    public void loadJSGF(String grammarName) throws IOException, JSGFGrammarParseException, JSGFGrammarException {
        this.grammarName = grammarName;
        this.loadGrammar = true;
        this.commitChanges();
    }

    @Override
    protected GrammarNode createGrammar() throws IOException {
        try {
            this.commitChanges();
        }
        catch (JSGFGrammarException e) {
            throw new IOException(e);
        }
        catch (JSGFGrammarParseException e) {
            throw new IOException(e);
        }
        return this.firstNode;
    }

    @Override
    public GrammarNode getInitialNode() {
        return this.firstNode;
    }

    protected GrammarGraph processRule(JSGFRule rule) throws JSGFGrammarException {
        GrammarGraph result;
        if (rule != null) {
            this.logger.fine("parseRule: " + rule);
        }
        if (rule instanceof JSGFRuleAlternatives) {
            result = this.processRuleAlternatives((JSGFRuleAlternatives)rule);
        } else if (rule instanceof JSGFRuleCount) {
            result = this.processRuleCount((JSGFRuleCount)rule);
        } else if (rule instanceof JSGFRuleName) {
            result = this.processRuleName((JSGFRuleName)rule);
        } else if (rule instanceof JSGFRuleSequence) {
            result = this.processRuleSequence((JSGFRuleSequence)rule);
        } else if (rule instanceof JSGFRuleTag) {
            result = this.processRuleTag((JSGFRuleTag)rule);
        } else if (rule instanceof JSGFRuleToken) {
            result = this.processRuleToken((JSGFRuleToken)rule);
        } else {
            throw new IllegalArgumentException("Unsupported Rule type: " + rule);
        }
        return result;
    }

    private GrammarGraph processRuleName(JSGFRuleName initialRuleName) throws JSGFGrammarException {
        this.logger.fine("parseRuleName: " + initialRuleName);
        GrammarGraph result = this.ruleStack.contains(initialRuleName.getRuleName());
        if (result != null) {
            return result;
        }
        result = new GrammarGraph();
        this.ruleStack.push(initialRuleName.getRuleName(), result);
        JSGFRuleName ruleName = this.ruleGrammar.resolve(initialRuleName);
        if (ruleName == JSGFRuleName.NULL) {
            result.getStartNode().add(result.getEndNode(), 0.0f);
        } else if (ruleName != JSGFRuleName.VOID) {
            if (ruleName == null) {
                throw new JSGFGrammarException("Can't resolve " + initialRuleName + " g " + initialRuleName.getFullGrammarName());
            }
            JSGFRuleGrammar rg = this.manager.retrieveGrammar(ruleName.getFullGrammarName());
            if (rg == null) {
                throw new JSGFGrammarException("Can't resolve grammar name " + ruleName.getFullGrammarName());
            }
            JSGFRule rule = rg.getRule(ruleName.getSimpleRuleName());
            if (rule == null) {
                throw new JSGFGrammarException("Can't resolve rule: " + ruleName.getRuleName());
            }
            GrammarGraph ruleResult = this.processRule(rule);
            if (result != ruleResult) {
                result.getStartNode().add(ruleResult.getStartNode(), 0.0f);
                ruleResult.getEndNode().add(result.getEndNode(), 0.0f);
            }
        }
        this.ruleStack.pop();
        return result;
    }

    private GrammarGraph processRuleCount(JSGFRuleCount ruleCount) throws JSGFGrammarException {
        this.logger.fine("parseRuleCount: " + ruleCount);
        GrammarGraph result = new GrammarGraph();
        int count = ruleCount.getCount();
        GrammarGraph newNodes = this.processRule(ruleCount.getRule());
        result.getStartNode().add(newNodes.getStartNode(), 0.0f);
        newNodes.getEndNode().add(result.getEndNode(), 0.0f);
        if (count == 4 || count == 2) {
            result.getStartNode().add(result.getEndNode(), 0.0f);
        }
        if (count == 3 || count == 4) {
            newNodes.getEndNode().add(newNodes.getStartNode(), 0.0f);
        }
        return result;
    }

    private GrammarGraph processRuleAlternatives(JSGFRuleAlternatives ruleAlternatives) throws JSGFGrammarException {
        this.logger.fine("parseRuleAlternatives: " + ruleAlternatives);
        GrammarGraph result = new GrammarGraph();
        List<JSGFRule> rules = ruleAlternatives.getRules();
        List<Float> weights = this.getNormalizedWeights(ruleAlternatives.getWeights());
        int i = 0;
        while (i < rules.size()) {
            JSGFRule rule = rules.get(i);
            float weight = 0.0f;
            if (weights != null) {
                weight = weights.get(i).floatValue();
            }
            this.logger.fine("Alternative: " + rule);
            GrammarGraph newNodes = this.processRule(rule);
            result.getStartNode().add(newNodes.getStartNode(), weight);
            newNodes.getEndNode().add(result.getEndNode(), 0.0f);
            ++i;
        }
        return result;
    }

    private List<Float> getNormalizedWeights(List<Float> weights) {
        if (weights == null) {
            return null;
        }
        double sum = 0.0;
        for (float weight : weights) {
            if (weight < 0.0f) {
                throw new IllegalArgumentException("Negative weight " + weight);
            }
            sum += (double)weight;
        }
        LinkedList<Float> normalized = new LinkedList<Float>(weights);
        int i = 0;
        while (i < weights.size()) {
            if (sum == 0.0) {
                normalized.set(i, Float.valueOf(-3.4028235E38f));
            } else {
                normalized.set(i, Float.valueOf(this.logMath.linearToLog((double)weights.get(i).floatValue() / sum)));
            }
            ++i;
        }
        return normalized;
    }

    private GrammarGraph processRuleSequence(JSGFRuleSequence ruleSequence) throws JSGFGrammarException {
        GrammarNode startNode = null;
        GrammarNode endNode = null;
        this.logger.fine("parseRuleSequence: " + ruleSequence);
        List<JSGFRule> rules = ruleSequence.getRules();
        GrammarNode lastGrammarNode = null;
        int i = 0;
        while (i < rules.size()) {
            JSGFRule rule = rules.get(i);
            GrammarGraph newNodes = this.processRule(rule);
            if (i == 0) {
                startNode = newNodes.getStartNode();
            }
            if (i == rules.size() - 1) {
                endNode = newNodes.getEndNode();
            }
            if (i > 0) {
                lastGrammarNode.add(newNodes.getStartNode(), 0.0f);
            }
            lastGrammarNode = newNodes.getEndNode();
            ++i;
        }
        return new GrammarGraph(startNode, endNode);
    }

    private GrammarGraph processRuleTag(JSGFRuleTag ruleTag) throws JSGFGrammarException {
        this.logger.fine("parseRuleTag: " + ruleTag);
        JSGFRule rule = ruleTag.getRule();
        return this.processRule(rule);
    }

    private GrammarGraph processRuleToken(JSGFRuleToken ruleToken) {
        GrammarNode node = this.createGrammarNode(ruleToken.getText());
        return new GrammarGraph(node, node);
    }

    public abstract void commitChanges() throws IOException, JSGFGrammarParseException, JSGFGrammarException;

    protected String getFullRuleName(String ruleName) throws JSGFGrammarException {
        JSGFRuleName rname = this.ruleGrammar.resolve(new JSGFRuleName(ruleName));
        return rname.getRuleName();
    }

    protected void dumpGrammar() {
        System.out.println("Imported rules { ");
        for (JSGFRuleName imp : this.ruleGrammar.getImports()) {
            System.out.println("  Import " + imp.getRuleName());
        }
        System.out.println("}");
        System.out.println("Rulenames { ");
        for (String name : this.ruleGrammar.getRuleNames()) {
            System.out.println("  Name " + name);
        }
        System.out.println("}");
    }

    class GrammarGraph {
        private GrammarNode startNode;
        private GrammarNode endNode;

        GrammarGraph(GrammarNode startNode, GrammarNode endNode) {
            this.startNode = startNode;
            this.endNode = endNode;
        }

        GrammarGraph() {
            this.startNode = JSGFBaseGrammar.this.createGrammarNode(false);
            this.endNode = JSGFBaseGrammar.this.createGrammarNode(false);
        }

        GrammarNode getStartNode() {
            return this.startNode;
        }

        GrammarNode getEndNode() {
            return this.endNode;
        }
    }

    class RuleStack {
        private List<String> stack;
        private HashMap<String, GrammarGraph> map;

        public RuleStack() {
            this.clear();
        }

        public void push(String name, GrammarGraph g) {
            this.stack.add(0, name);
            this.map.put(name, g);
        }

        public void pop() {
            this.map.remove(this.stack.remove(0));
        }

        public GrammarGraph contains(String name) {
            if (this.stack.contains(name)) {
                return this.map.get(name);
            }
            return null;
        }

        public void clear() {
            this.stack = new LinkedList<String>();
            this.map = new HashMap();
        }
    }
}

