/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.jsgf;

import edu.cmu.sphinx.jsgf.rule.JSGFRule;
import edu.cmu.sphinx.jsgf.rule.JSGFRuleAlternatives;
import edu.cmu.sphinx.jsgf.rule.JSGFRuleCount;
import edu.cmu.sphinx.jsgf.rule.JSGFRuleSequence;
import edu.cmu.sphinx.jsgf.rule.JSGFRuleToken;
import java.net.URL;
import java.util.ArrayList;
import java.util.Map;
import java.util.logging.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class GrXMLHandler
extends DefaultHandler {
    protected final Map<String, JSGFRule> topRuleMap;
    Logger logger;
    JSGFRule currentRule;
    URL baseURL;

    public GrXMLHandler(URL baseURL, Map<String, JSGFRule> rules, Logger logger) {
        this.baseURL = baseURL;
        this.topRuleMap = rules;
        this.logger = logger;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        String id;
        JSGFRule newRule = null;
        JSGFRule topRule = null;
        this.logger.fine("Starting element " + qName);
        if (qName.equals("rule") && (id = attributes.getValue("id")) != null) {
            newRule = new JSGFRuleSequence(new ArrayList<JSGFRule>());
            this.topRuleMap.put(id, newRule);
            topRule = newRule;
        }
        if (qName.equals("item")) {
            String repeat = attributes.getValue("repeat");
            if (repeat != null) {
                newRule = new JSGFRuleSequence(new ArrayList<JSGFRule>());
                JSGFRuleCount ruleCount = new JSGFRuleCount(newRule, 3);
                topRule = ruleCount;
            } else {
                topRule = newRule = new JSGFRuleSequence(new ArrayList<JSGFRule>());
            }
        }
        if (qName.equals("one-of")) {
            topRule = newRule = new JSGFRuleAlternatives(new ArrayList<JSGFRule>());
        }
        this.addToCurrent(newRule, topRule);
    }

    @Override
    public void characters(char[] buf, int offset, int len) throws SAXException {
        String item = new String(buf, offset, len).trim();
        if (item.length() == 0) {
            return;
        }
        this.logger.fine("Processing text " + item);
        JSGFRuleToken newRule = new JSGFRuleToken(item);
        this.addToCurrent(newRule, newRule);
        this.currentRule = newRule.parent;
    }

    private void addToCurrent(JSGFRule newRule, JSGFRule topRule) {
        if (newRule == null) {
            return;
        }
        if (this.currentRule == null) {
            this.currentRule = newRule;
            return;
        }
        if (this.currentRule instanceof JSGFRuleSequence) {
            JSGFRuleSequence ruleSequence = (JSGFRuleSequence)this.currentRule;
            ruleSequence.append(topRule);
            newRule.parent = this.currentRule;
            this.currentRule = newRule;
        } else if (this.currentRule instanceof JSGFRuleAlternatives) {
            JSGFRuleAlternatives ruleAlternatives = (JSGFRuleAlternatives)this.currentRule;
            ruleAlternatives.append(topRule);
            newRule.parent = this.currentRule;
            this.currentRule = newRule;
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXParseException {
        this.logger.fine("Ending element " + qName);
        if (qName.equals("item") || qName.equals("one-of") || qName.equals("rule")) {
            this.currentRule = this.currentRule.parent;
        }
    }
}

