/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.instrumentation;

import edu.cmu.sphinx.instrumentation.Monitor;
import edu.cmu.sphinx.recognizer.Recognizer;
import edu.cmu.sphinx.recognizer.StateListener;
import edu.cmu.sphinx.util.props.Configurable;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.S4Component;
import edu.cmu.sphinx.util.props.S4ComponentList;
import java.util.List;

public class RecognizerMonitor
implements StateListener,
Monitor {
    @S4Component(type=Recognizer.class)
    public static final String PROP_RECOGNIZER = "recognizer";
    @S4ComponentList(type=Configurable.class)
    public static final String PROP_ALLOCATED_MONITORS = "allocatedMonitors";
    @S4ComponentList(type=Configurable.class)
    public static final String PROP_DEALLOCATED_MONITORS = "deallocatedMonitors";
    Recognizer recognizer;
    List<Runnable> allocatedMonitors;
    List<Runnable> deallocatedMonitors;
    String name;

    public RecognizerMonitor(Recognizer recognizer, List<Runnable> allocatedMonitors, List<Runnable> deallocatedMonitors) {
        this.initRecognizer(recognizer);
        this.allocatedMonitors = allocatedMonitors;
        this.deallocatedMonitors = deallocatedMonitors;
    }

    public RecognizerMonitor() {
    }

    @Override
    public void newProperties(PropertySheet ps) throws PropertyException {
        this.initRecognizer((Recognizer)ps.getComponent(PROP_RECOGNIZER));
        this.allocatedMonitors = ps.getComponentList(PROP_ALLOCATED_MONITORS, Runnable.class);
        this.deallocatedMonitors = ps.getComponentList(PROP_DEALLOCATED_MONITORS, Runnable.class);
    }

    private void initRecognizer(Recognizer newRecognizer) {
        if (this.recognizer == null) {
            this.recognizer = newRecognizer;
            this.recognizer.addStateListener(this);
        } else if (this.recognizer != newRecognizer) {
            this.recognizer.removeStateListener(this);
            this.recognizer = newRecognizer;
            this.recognizer.addStateListener(this);
        }
    }

    @Override
    public void statusChanged(Recognizer.State status) {
        List<Runnable> runnableList = null;
        if (status == Recognizer.State.ALLOCATED) {
            runnableList = this.allocatedMonitors;
        } else if (status == Recognizer.State.DEALLOCATED) {
            runnableList = this.deallocatedMonitors;
        }
        if (runnableList != null) {
            for (Runnable r : runnableList) {
                r.run();
            }
        }
    }
}

