/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.instrumentation;

import edu.cmu.sphinx.decoder.ResultListener;
import edu.cmu.sphinx.instrumentation.Monitor;
import edu.cmu.sphinx.instrumentation.Resetable;
import edu.cmu.sphinx.recognizer.Recognizer;
import edu.cmu.sphinx.recognizer.StateListener;
import edu.cmu.sphinx.result.Result;
import edu.cmu.sphinx.util.NISTAlign;
import edu.cmu.sphinx.util.props.ConfigurableAdapter;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.S4Boolean;
import edu.cmu.sphinx.util.props.S4Component;

public abstract class AccuracyTracker
extends ConfigurableAdapter
implements ResultListener,
Resetable,
StateListener,
Monitor {
    @S4Component(type=Recognizer.class)
    public static final String PROP_RECOGNIZER = "recognizer";
    @S4Boolean(defaultValue=true)
    public static final String PROP_SHOW_SUMMARY = "showSummary";
    @S4Boolean(defaultValue=true)
    public static final String PROP_SHOW_DETAILS = "showDetails";
    @S4Boolean(defaultValue=true)
    public static final String PROP_SHOW_RESULTS = "showResults";
    @S4Boolean(defaultValue=true)
    public static final String PROP_SHOW_ALIGNED_RESULTS = "showAlignedResults";
    @S4Boolean(defaultValue=true)
    public static final String PROP_SHOW_RAW_RESULTS = "showRawResults";
    private String name;
    private Recognizer recognizer;
    private boolean showSummary;
    private boolean showDetails;
    private boolean showResults;
    private boolean showAlignedResults;
    private boolean showRaw;
    private final NISTAlign aligner = new NISTAlign(false, false);

    public AccuracyTracker(Recognizer recognizer, boolean showSummary, boolean showDetails, boolean showResults, boolean showAlignedResults, boolean showRawResults) {
        this.initRecognizer(recognizer);
        this.initLogger();
        this.showSummary = showSummary;
        this.showDetails = showDetails;
        this.showResults = showResults;
        this.showAlignedResults = showAlignedResults;
        this.showRaw = showRawResults;
        this.aligner.setShowResults(showResults);
        this.aligner.setShowAlignedResults(showAlignedResults);
    }

    public AccuracyTracker() {
    }

    @Override
    public void newProperties(PropertySheet ps) throws PropertyException {
        super.newProperties(ps);
        this.initRecognizer((Recognizer)ps.getComponent(PROP_RECOGNIZER));
        this.showSummary = ps.getBoolean(PROP_SHOW_SUMMARY);
        this.showDetails = ps.getBoolean(PROP_SHOW_DETAILS);
        this.showResults = ps.getBoolean(PROP_SHOW_RESULTS);
        this.showAlignedResults = ps.getBoolean(PROP_SHOW_ALIGNED_RESULTS);
        this.showRaw = ps.getBoolean(PROP_SHOW_RAW_RESULTS);
        this.aligner.setShowResults(this.showResults);
        this.aligner.setShowAlignedResults(this.showAlignedResults);
    }

    private void initRecognizer(Recognizer newRecognizer) {
        if (this.recognizer == null) {
            this.recognizer = newRecognizer;
            this.recognizer.addResultListener(this);
            this.recognizer.addStateListener(this);
        } else if (this.recognizer != newRecognizer) {
            this.recognizer.removeResultListener(this);
            this.recognizer.removeStateListener(this);
            this.recognizer = newRecognizer;
            this.recognizer.addResultListener(this);
            this.recognizer.addStateListener(this);
        }
    }

    @Override
    public void reset() {
        this.aligner.resetTotals();
    }

    @Override
    public String getName() {
        return this.name;
    }

    public NISTAlign getAligner() {
        return this.aligner;
    }

    protected void showDetails(String rawText) {
        if (this.showDetails) {
            this.aligner.printSentenceSummary();
            if (this.showRaw) {
                this.logger.info("RAW     " + rawText);
            }
            this.aligner.printTotalSummary();
        }
    }

    @Override
    public abstract void newResult(Result var1);

    @Override
    public void statusChanged(Recognizer.State status) {
        if (status == Recognizer.State.DEALLOCATED && this.showSummary) {
            this.logger.info("\n# --------------- Summary statistics ---------");
            this.aligner.printTotalSummary();
        }
    }
}

