/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.fst.operations;

import edu.cmu.sphinx.fst.Arc;
import edu.cmu.sphinx.fst.Fst;
import edu.cmu.sphinx.fst.State;
import edu.cmu.sphinx.fst.operations.ExtendFinal;
import edu.cmu.sphinx.fst.semiring.Semiring;

public class Reverse {
    private Reverse() {
    }

    public static Fst get(Fst fst) {
        if (fst.getSemiring() == null) {
            return null;
        }
        ExtendFinal.apply(fst);
        Semiring semiring = fst.getSemiring();
        Fst res = new Fst(fst.getNumStates());
        res.setSemiring(semiring);
        res.setIsyms(fst.getOsyms());
        res.setOsyms(fst.getIsyms());
        State[] stateMap = new State[fst.getNumStates()];
        int numStates = fst.getNumStates();
        int i = 0;
        while (i < numStates) {
            State is = fst.getState(i);
            State s = new State(semiring.zero());
            res.addState(s);
            stateMap[is.getId()] = s;
            if (is.getFinalWeight() != semiring.zero()) {
                res.setStart(s);
            }
            ++i;
        }
        stateMap[fst.getStart().getId()].setFinalWeight(semiring.one());
        i = 0;
        while (i < numStates) {
            State olds = fst.getState(i);
            State news = stateMap[olds.getId()];
            int numArcs = olds.getNumArcs();
            int j = 0;
            while (j < numArcs) {
                Arc olda = olds.getArc(j);
                State next = stateMap[olda.getNextState().getId()];
                Arc newa = new Arc(olda.getIlabel(), olda.getOlabel(), semiring.reverse(olda.getWeight()), news);
                next.addArc(newa);
                ++j;
            }
            ++i;
        }
        ExtendFinal.undo(fst);
        return res;
    }
}

