/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.fst.operations;

import edu.cmu.sphinx.fst.Arc;
import edu.cmu.sphinx.fst.Fst;
import edu.cmu.sphinx.fst.ImmutableFst;
import edu.cmu.sphinx.fst.State;
import edu.cmu.sphinx.fst.operations.ProjectType;

public class Project {
    private Project() {
    }

    public static void apply(Fst fst, ProjectType pType) {
        if (pType == ProjectType.INPUT) {
            fst.setOsyms(fst.getIsyms());
        } else if (pType == ProjectType.OUTPUT) {
            fst.setIsyms(fst.getOsyms());
        }
        int numStates = fst.getNumStates();
        int i = 0;
        while (i < numStates) {
            State s = fst.getState(i);
            int numArcs = fst instanceof ImmutableFst ? s.getNumArcs() - 1 : s.getNumArcs();
            int j = 0;
            while (j < numArcs) {
                Arc a = s.getArc(j);
                if (pType == ProjectType.INPUT) {
                    a.setOlabel(a.getIlabel());
                } else if (pType == ProjectType.OUTPUT) {
                    a.setIlabel(a.getOlabel());
                }
                ++j;
            }
            ++i;
        }
    }
}

