/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.fst.operations;

import edu.cmu.sphinx.fst.Arc;
import edu.cmu.sphinx.fst.Fst;
import edu.cmu.sphinx.fst.State;
import edu.cmu.sphinx.fst.semiring.Semiring;
import edu.cmu.sphinx.fst.utils.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;

public class Determinize {
    private Determinize() {
    }

    private static Pair<State, Float> getPair(ArrayList<Pair<State, Float>> queue, State state, Float zero) {
        Pair<State, Float> res = null;
        for (Pair<State, Float> tmp : queue) {
            if (state.getId() != tmp.getLeft().getId()) continue;
            res = tmp;
            break;
        }
        if (res == null) {
            res = new Pair<State, Float>(state, zero);
            queue.add(res);
        }
        return res;
    }

    private static ArrayList<Integer> getUniqueLabels(Fst fst, ArrayList<Pair<State, Float>> pa) {
        ArrayList<Integer> res = new ArrayList<Integer>();
        for (Pair<State, Float> p : pa) {
            State s = p.getLeft();
            int numArcs = s.getNumArcs();
            int j = 0;
            while (j < numArcs) {
                Arc arc = s.getArc(j);
                if (!res.contains(arc.getIlabel())) {
                    res.add(arc.getIlabel());
                }
                ++j;
            }
        }
        return res;
    }

    private static State getStateLabel(ArrayList<Pair<State, Float>> pa, HashMap<String, State> stateMapper) {
        StringBuilder sb = new StringBuilder();
        for (Pair<State, Float> p : pa) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append("(" + p.getLeft() + "," + p.getRight() + ")");
        }
        return stateMapper.get(sb.toString());
    }

    public static Fst get(Fst fst) {
        if (fst.getSemiring() == null) {
            return null;
        }
        Semiring semiring = fst.getSemiring();
        Fst res = new Fst(semiring);
        res.setIsyms(fst.getIsyms());
        res.setOsyms(fst.getOsyms());
        LinkedList queue = new LinkedList();
        HashMap<String, State> stateMapper = new HashMap<String, State>();
        State s = new State(semiring.zero());
        String stateString = "(" + fst.getStart() + "," + semiring.one() + ")";
        queue.add(new ArrayList());
        ((ArrayList)queue.peek()).add(new Pair<State, Float>(fst.getStart(), Float.valueOf(semiring.one())));
        res.addState(s);
        stateMapper.put(stateString, s);
        res.setStart(s);
        while (!queue.isEmpty()) {
            ArrayList p = (ArrayList)queue.remove();
            State pnew = Determinize.getStateLabel(p, stateMapper);
            ArrayList<Integer> labels = Determinize.getUniqueLabels(fst, p);
            for (int label : labels) {
                Float wnew = Float.valueOf(semiring.zero());
                for (Pair ps : p) {
                    State state = (State)ps.getLeft();
                    Float u = (Float)ps.getRight();
                    int n = state.getNumArcs();
                    int j = 0;
                    while (j < n) {
                        Arc arc = state.getArc(j);
                        if (label == arc.getIlabel()) {
                            wnew = Float.valueOf(semiring.plus(wnew.floatValue(), semiring.times(u.floatValue(), arc.getWeight())));
                        }
                        ++j;
                    }
                }
                ArrayList<Pair<State, Float>> forQueue = new ArrayList<Pair<State, Float>>();
                for (Pair ps : p) {
                    State old = (State)ps.getLeft();
                    Float f = (Float)ps.getRight();
                    Float wnewRevert = Float.valueOf(semiring.divide(semiring.one(), wnew.floatValue()));
                    int numArcs = old.getNumArcs();
                    int j = 0;
                    while (j < numArcs) {
                        Arc arc = old.getArc(j);
                        if (label == arc.getIlabel()) {
                            State oldstate = arc.getNextState();
                            Pair<State, Float> pair = Determinize.getPair(forQueue, oldstate, Float.valueOf(semiring.zero()));
                            pair.setRight(Float.valueOf(semiring.plus(pair.getRight().floatValue(), semiring.times(wnewRevert.floatValue(), semiring.times(f.floatValue(), arc.getWeight())))));
                        }
                        ++j;
                    }
                }
                String qnewid = "";
                for (Pair pair : forQueue) {
                    State state = (State)pair.getLeft();
                    Float unew = (Float)pair.getRight();
                    if (!qnewid.equals("")) {
                        qnewid = String.valueOf(qnewid) + ",";
                    }
                    qnewid = String.valueOf(qnewid) + "(" + state + "," + unew + ")";
                }
                if (stateMapper.get(qnewid) == null) {
                    State state = new State(semiring.zero());
                    res.addState(state);
                    stateMapper.put(qnewid, state);
                    Float fw = Float.valueOf(state.getFinalWeight());
                    for (Pair pair : forQueue) {
                        fw = Float.valueOf(semiring.plus(fw.floatValue(), semiring.times(((State)pair.getLeft()).getFinalWeight(), ((Float)pair.getRight()).floatValue())));
                    }
                    state.setFinalWeight(fw.floatValue());
                    queue.add(forQueue);
                }
                pnew.addArc(new Arc(label, label, wnew.floatValue(), stateMapper.get(qnewid)));
            }
        }
        return res;
    }
}

