/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.frontend.window;

import java.util.Arrays;

class DoubleBuffer {
    private final double[] buffer;
    private int occupancy;

    DoubleBuffer(int size) {
        this.buffer = new double[size];
        this.occupancy = 0;
    }

    public int getOccupancy() {
        return this.occupancy;
    }

    public double[] getBuffer() {
        return this.buffer;
    }

    public int appendAll(double[] src) {
        return this.append(src, 0, src.length);
    }

    public int append(double[] src, int srcPos, int length) {
        if (this.occupancy + length > this.buffer.length) {
            throw new Error("RaisedCosineWindower: overflow-buffer: attempting to fill buffer beyond its capacity.");
        }
        System.arraycopy(src, srcPos, this.buffer, this.occupancy, length);
        this.occupancy += length;
        return this.occupancy;
    }

    public void padWindow(int windowSize) {
        if (this.occupancy < windowSize) {
            Arrays.fill(this.buffer, this.occupancy, windowSize, 0.0);
        }
    }

    public void reset() {
        this.occupancy = 0;
    }
}

