/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.frontend.util;

import edu.cmu.sphinx.frontend.BaseDataProcessor;
import edu.cmu.sphinx.frontend.Data;
import edu.cmu.sphinx.frontend.DataEndSignal;
import edu.cmu.sphinx.frontend.DataProcessingException;
import edu.cmu.sphinx.frontend.DataStartSignal;
import edu.cmu.sphinx.frontend.DoubleData;
import edu.cmu.sphinx.frontend.util.DataUtil;
import edu.cmu.sphinx.util.Utilities;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.S4Boolean;
import edu.cmu.sphinx.util.props.S4Double;
import edu.cmu.sphinx.util.props.S4Integer;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;

public class StreamHTKCepstrum
extends BaseDataProcessor {
    @S4Boolean(defaultValue=true)
    public static final String PROP_BINARY = "binary";
    @S4Boolean(defaultValue=true)
    public static final String PROP_BIGENDIAN = "bigEndian";
    @S4Double(defaultValue=25.625)
    public static final String PROP_FRAME_SIZE_MS = "frameSizeInMs";
    @S4Double(defaultValue=10.0)
    public static final String PROP_FRAME_SHIFT_MS = "frameShiftInMs";
    @S4Integer(defaultValue=13)
    public static final String PROP_CEPSTRUM_LENGTH = "cepstrumLength";
    @S4Integer(defaultValue=16000)
    public static final String PROP_SAMPLE_RATE = "sampleRate";
    private DataInputStream binaryStream;
    private int numPoints;
    private int curPoint;
    private int cepstrumLength;
    private int frameShift;
    private int frameSize;
    private int sampleRate;
    private long firstSampleNumber;
    private boolean bigEndian;

    public StreamHTKCepstrum(float frameShiftMs, float frameSizeMs, boolean bigEndian, int sampleRate) {
        this.initLogger();
        this.bigEndian = bigEndian;
        this.sampleRate = sampleRate;
        this.frameShift = DataUtil.getSamplesPerWindow(sampleRate, frameShiftMs);
        this.frameSize = DataUtil.getSamplesPerShift(sampleRate, frameSizeMs);
    }

    public StreamHTKCepstrum() {
    }

    @Override
    public void newProperties(PropertySheet ps) throws PropertyException {
        super.newProperties(ps);
        float frameShiftMs = ps.getFloat(PROP_FRAME_SHIFT_MS);
        float frameSizeMs = ps.getFloat(PROP_FRAME_SIZE_MS);
        this.bigEndian = ps.getBoolean(PROP_BIGENDIAN);
        this.sampleRate = ps.getInt(PROP_SAMPLE_RATE);
        this.frameShift = DataUtil.getSamplesPerWindow(this.sampleRate, frameShiftMs);
        this.frameSize = DataUtil.getSamplesPerShift(this.sampleRate, frameSizeMs);
        this.logger = ps.getLogger();
    }

    @Override
    public void initialize() {
        super.initialize();
        this.curPoint = -1;
        this.firstSampleNumber = 0L;
    }

    public void setInputStream(InputStream stream) throws IOException {
        this.binaryStream = new DataInputStream(new BufferedInputStream(stream));
        if (this.bigEndian) {
            this.numPoints = this.binaryStream.readInt();
            int sampPeriod = this.binaryStream.readInt();
            short sampSize = this.binaryStream.readShort();
            short parmKind = this.binaryStream.readShort();
            this.cepstrumLength = sampSize / 4;
            this.numPoints *= this.cepstrumLength;
            this.logger.info("Sample period is " + sampPeriod);
            this.logger.info("Sample size " + sampSize);
            this.logger.info("Parameter kind " + parmKind);
            this.logger.info("BigEndian");
        } else {
            this.numPoints = Utilities.readLittleEndianInt(this.binaryStream);
            int sampPeriod = Utilities.readLittleEndianInt(this.binaryStream);
            short sampSize = StreamHTKCepstrum.readLittleEndianShort(this.binaryStream);
            short parmKind = StreamHTKCepstrum.readLittleEndianShort(this.binaryStream);
            this.cepstrumLength = sampSize / 4;
            this.numPoints *= this.cepstrumLength;
            this.logger.info("Sample period is " + sampPeriod);
            this.logger.info("Sample size " + sampSize);
            this.logger.info("Parameter kind " + parmKind);
            this.logger.info("LittleEndian");
        }
        System.out.println("Frames: " + this.numPoints / this.cepstrumLength);
        this.curPoint = -1;
        this.firstSampleNumber = 0L;
    }

    public static short readLittleEndianShort(DataInputStream dataStream) throws IOException {
        short bits = 0;
        int shift = 0;
        while (shift < 16) {
            int byteRead = 0xFF & dataStream.readByte();
            bits = (short)(bits | byteRead << shift);
            shift += 8;
        }
        return bits;
    }

    @Override
    public Data getData() throws DataProcessingException {
        Data data;
        if (this.curPoint == -1) {
            data = new DataStartSignal(this.sampleRate);
            ++this.curPoint;
        } else {
            if (this.curPoint == this.numPoints) {
                if (this.numPoints > 0) {
                    this.firstSampleNumber = this.firstSampleNumber - (long)this.frameShift + (long)this.frameSize - 1L;
                }
                int numberFrames = this.curPoint / this.cepstrumLength;
                int totalSamples = (numberFrames - 1) * this.frameShift + this.frameSize;
                long duration = (long)((double)totalSamples / (double)this.sampleRate * 1000.0);
                data = new DataEndSignal(duration);
                try {
                    this.binaryStream.close();
                    ++this.curPoint;
                }
                catch (IOException ioe) {
                    throw new DataProcessingException("IOException closing cepstrum stream", ioe);
                }
            }
            if (this.curPoint > this.numPoints) {
                data = null;
            } else {
                double[] vectorData = new double[this.cepstrumLength];
                int i = 0;
                while (i < this.cepstrumLength) {
                    try {
                        vectorData[i] = this.bigEndian ? (double)this.binaryStream.readFloat() : (double)Utilities.readLittleEndianFloat(this.binaryStream);
                        ++this.curPoint;
                    }
                    catch (IOException ioe) {
                        throw new DataProcessingException("IOException reading from cepstrum stream", ioe);
                    }
                    ++i;
                }
                data = new DoubleData(vectorData, this.sampleRate, this.firstSampleNumber);
                this.firstSampleNumber += (long)this.frameShift;
            }
        }
        return data;
    }
}

